/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableGroebnerBaseTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    List<GenSolvablePolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    GenSolvablePolynomialRing<BigRational> ring;
    SolvableGroebnerBase<BigRational> sbb;
    BigRational cfac;
    TermOrder tord;
    RelationTable<BigRational> table;
    int rl = 4;
    int kl = 10;
    int ll = 4;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableGroebnerBaseTest.suite());
    }

    public SolvableGroebnerBaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SolvableGroebnerBaseTest.class);
        return suite;
    }

    protected void setUp() {
        this.cfac = new BigRational(9L);
        this.tord = new TermOrder();
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.sbb = new SolvableGroebnerBaseSeq<BigRational>();
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.table = null;
        this.cfac = null;
        this.sbb = null;
    }

    public void testSequentialGBase() {
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testWeylSequentialGBase() {
        int rloc = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.ring);
        wl.generate();
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testSequentialTSGBase() {
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testWeylSequentialTSGBase() {
        int rloc = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.ring);
        wl.generate();
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }
}

