/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

class SolvableMiReducer<C extends RingElem<C>>
implements Runnable {
    private List<GenSolvablePolynomial<C>> G;
    private List<GenSolvablePolynomial<C>> F;
    private GenSolvablePolynomial<C> S;
    private GenSolvablePolynomial<C> H;
    private SolvableReductionPar<C> sred;
    private Semaphore done = new Semaphore(0);
    private static final Logger logger = Logger.getLogger(SolvableMiReducer.class);
    private static final boolean debug = logger.isDebugEnabled();

    SolvableMiReducer(List<GenSolvablePolynomial<C>> G, List<GenSolvablePolynomial<C>> F2, GenSolvablePolynomial<C> p) {
        this.G = G;
        this.F = F2;
        this.S = p;
        this.H = this.S;
        this.sred = new SolvableReductionPar();
    }

    public GenSolvablePolynomial<C> getNF() {
        try {
            this.done.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.H;
    }

    @Override
    public void run() {
        if (debug) {
            logger.debug((Object)("ht(S) = " + this.S.leadingExpVector()));
        }
        this.H = this.sred.leftNormalform(this.G, this.H);
        this.H = this.sred.leftNormalform(this.F, this.H);
        this.done.release();
        if (debug) {
            logger.debug((Object)("ht(H) = " + this.H.leadingExpVector()));
        }
    }
}

