/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableReductionTest
extends TestCase {
    GenSolvablePolynomialRing<BigRational> fac;
    RelationTable table;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    List<GenSolvablePolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    SolvableReduction<BigRational> sred;
    SolvableReduction<BigRational> sredpar;
    int rl = 4;
    int kl = 10;
    int ll = 5;
    int el = 3;
    float q = 0.4f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableReductionTest.suite());
    }

    public SolvableReductionTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SolvableReductionTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenSolvablePolynomialRing<BigRational>(new BigRational(0L), this.rl);
        this.sred = new SolvableReductionSeq<BigRational>();
        this.sredpar = new SolvableReductionPar<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.sred = null;
        this.sredpar = null;
    }

    public void testRatReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testWeylRatReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.fac);
        wl.generate();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvableReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvableReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvableReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testRatReductionPar() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvableReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.sredpar.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvableReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sredpar.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testWeylRatReduction() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.fac);
        wl.generate();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvableReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvableReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testWeylRatReductionPar() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.fac);
        wl.generate();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvableReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.e = this.sredpar.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvableReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sredpar.leftNormalform(this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testRatReductionRecording() {
        ArrayList row = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvableReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        row = new ArrayList(this.L.size());
        int m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.sred.leftNormalform(row, this.L, this.a);
        SolvableReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvableReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        SolvableReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(row, this.L, this.a, this.e));
        this.L.add(this.b);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.sred.leftNormalform(row, this.L, this.b);
        SolvableReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(row, this.L, this.b, this.e));
        this.L.add(this.c);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.sred.leftNormalform(row, this.L, this.c);
        SolvableReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(row, this.L, this.c, this.e));
        this.L.add(this.d);
        row = new ArrayList(this.L.size());
        m = 0;
        while (m < this.L.size()) {
            row.add(null);
            ++m;
        }
        this.e = this.sred.leftNormalform(row, this.L, this.d);
        SolvableReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(row, this.L, this.d, this.e));
    }
}

