/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.arith.BigRational;
import edu.jas.gbmod.ModGroebnerBase;
import edu.jas.gbmod.ModGroebnerBaseAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ModGroebnerBaseTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    TermOrder tord;
    List<List<GenPolynomial<BigRational>>> L;
    List<GenPolynomial<BigRational>> V;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModGroebnerBase<BigRational> mbb;
    int rl = 3;
    int kl = 8;
    int ll = 5;
    int el = 2;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ModGroebnerBaseTest.suite());
    }

    public ModGroebnerBaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModGroebnerBaseTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(9L);
        this.tord = new TermOrder();
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.tord);
        this.mbb = new ModGroebnerBaseAbstract<BigRational>(coeff);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
    }

    protected void tearDown() {
        this.mbb = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.tord = null;
    }

    public void testSequentialModGB() {
        this.L = new ArrayList<List<GenPolynomial<BigRational>>>();
        ModGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.N));
        ModGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isDIRPGB( { (a,0,1),(b,1,0) } )", (boolean)this.mbb.isGB(this.N));
        ModGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isDIRPGB( { (a,),(b,),(c,) } )", (boolean)this.mbb.isGB(this.N));
        ModGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isDIRPGB( { (a,b,c,d) } )", (boolean)this.mbb.isGB(this.N));
    }
}

