/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ModSolvableGroebnerBaseAbstract<C extends RingElem<C>>
implements ModSolvableGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(ModSolvableGroebnerBase.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final SolvableGroebnerBase<C> sbb = new SolvableGroebnerBaseSeq();

    @Override
    public boolean isLeftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.sbb.isLeftGB(modv, F2);
    }

    @Override
    public boolean isLeftGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        int modv = M.cols;
        PolynomialList<C> F2 = M.getPolynomialList();
        return this.sbb.isLeftGB(modv, F2.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.sbb.leftGB(modv, F2);
    }

    @Override
    public ModuleList<C> leftGB(ModuleList<C> M) {
        ModuleList<C> N2 = M;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        PolynomialList<C> F2 = M.getPolynomialList();
        if (this.debug) {
            logger.info((Object)("F left +++++++++++++++++++ \n" + F2));
        }
        GenSolvablePolynomialRing sring = (GenSolvablePolynomialRing)F2.ring;
        int modv = M.cols;
        List<GenSolvablePolynomial<C>> G = this.sbb.leftGB(modv, F2.castToSolvableList());
        F2 = new PolynomialList<C>(sring, G);
        if (this.debug) {
            logger.info((Object)("G left +++++++++++++++++++ \n" + F2));
        }
        N2 = F2.getModuleList(modv);
        return N2;
    }

    @Override
    public boolean isTwosidedGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.sbb.isTwosidedGB(modv, F2);
    }

    @Override
    public boolean isTwosidedGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        return this.sbb.isTwosidedGB(modv, F2.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.sbb.twosidedGB(modv, F2);
    }

    @Override
    public ModuleList<C> twosidedGB(ModuleList<C> M) {
        ModuleList<C> N2 = M;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        PolynomialList<C> F2 = M.getPolynomialList();
        GenSolvablePolynomialRing sring = (GenSolvablePolynomialRing)F2.ring;
        int modv = M.cols;
        List<GenSolvablePolynomial<C>> G = this.sbb.twosidedGB(modv, F2.castToSolvableList());
        F2 = new PolynomialList<C>(sring, G);
        N2 = F2.getModuleList(modv);
        return N2;
    }

    @Override
    public boolean isRightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.sbb.isRightGB(modv, F2);
    }

    @Override
    public boolean isRightGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        int modv = M.cols;
        PolynomialList<C> F2 = M.getPolynomialList();
        return this.sbb.isRightGB(modv, F2.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (modv == 0) {
            return this.sbb.rightGB(modv, F2);
        }
        throw new UnsupportedOperationException("modv != 0 not jet implemented");
    }

    @Override
    public ModuleList<C> rightGB(ModuleList<C> M) {
        ModuleList<C> N2 = M;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        if (this.debug) {
            logger.info((Object)("M ====================== \n" + M));
        }
        List<List<GenSolvablePolynomial<C>>> mlist = M.castToSolvableList();
        GenPolynomialRing sring = (GenSolvablePolynomialRing)M.ring;
        GenPolynomialRing rring = sring.reverse(true);
        sring = ((GenSolvablePolynomialRing)rring).reverse(true);
        ArrayList<List<GenSolvablePolynomial<Object>>> nlist = new ArrayList(M.rows);
        for (List<GenSolvablePolynomial<C>> row : mlist) {
            ArrayList<GenSolvablePolynomial> nrow = new ArrayList<GenSolvablePolynomial>(row.size());
            for (GenSolvablePolynomial<C> elem : row) {
                GenSolvablePolynomial nelem = (GenSolvablePolynomial)elem.reverse(rring);
                nrow.add(nelem);
            }
            nlist.add(nrow);
        }
        ModuleList rM = new ModuleList(rring, nlist);
        if (this.debug) {
            logger.info((Object)("rM -------------------- \n" + rM));
        }
        ModuleList rMg = this.leftGB(rM);
        if (this.debug) {
            logger.info((Object)("rMg -------------------- \n" + rMg));
        }
        mlist = rMg.castToSolvableList();
        nlist = new ArrayList(rMg.rows);
        for (List<GenSolvablePolynomial<C>> row : mlist) {
            ArrayList<GenSolvablePolynomial> nrow = new ArrayList<GenSolvablePolynomial>(row.size());
            for (GenSolvablePolynomial<C> elem : row) {
                GenSolvablePolynomial nelem = (GenSolvablePolynomial)elem.reverse(sring);
                nrow.add(nelem);
            }
            nlist.add(nrow);
        }
        ModuleList Mg = new ModuleList(sring, nlist);
        if (this.debug) {
            logger.info((Object)("Mg -------------------- \n" + Mg));
        }
        return Mg;
    }
}

