/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.arith.BigRational;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.gbmod.ModSolvableGroebnerBaseAbstract;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ModSolvableGroebnerBaseTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> pfac;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    TermOrder tord;
    GenSolvablePolynomial<BigRational> one;
    GenSolvablePolynomial<BigRational> zero;
    RelationTable<BigRational> table;
    List<List<GenSolvablePolynomial<BigRational>>> L;
    List<GenSolvablePolynomial<BigRational>> V;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModSolvableGroebnerBase<BigRational> msbb;
    int rl = 3;
    int kl = 4;
    int ll = 3;
    int el = 2;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ModSolvableGroebnerBaseTest.suite());
    }

    public ModSolvableGroebnerBaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModSolvableGroebnerBaseTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigRational(1L);
        this.tord = new TermOrder();
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.msbb = new ModSolvableGroebnerBaseAbstract<BigRational>();
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.one = null;
        this.zero = null;
        this.msbb = null;
    }

    public void testSequentialLeftModSolvableGB() {
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1),(b,1,0) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,),(b,),(c,) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,b,c,d) } )", (boolean)this.msbb.isLeftGB(this.N));
    }

    public void testSequentialTSModSolvableGB() {
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (boolean)this.msbb.isTwosidedGB(this.M));
        this.N = this.msbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (boolean)this.msbb.isTwosidedGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1),(b,1,0) } )", (boolean)this.msbb.isTwosidedGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,),(b,),(c,) } )", (boolean)this.msbb.isTwosidedGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,b,c,d) } )", (boolean)this.msbb.isTwosidedGB(this.N));
    }

    public void testSequentialLeftModSolvableWeylGB() {
        int rloc = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc, this.tord);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.pfac);
        wl.generate();
        this.table = this.pfac.table;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1),(b,1,0) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,),(b,),(c,) } )", (boolean)this.msbb.isLeftGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,b,c,d) } )", (boolean)this.msbb.isLeftGB(this.N));
    }

    public void testSequentialRightModSolvableGB() {
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.msbb.isRightGB(this.M));
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1),(b,1,0) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,),(b,),(c,) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,b,c,d) } )", (boolean)this.msbb.isRightGB(this.N));
    }

    public void testSequentialRightModSolvableWeylGB() {
        int rloc = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc, this.tord);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.pfac);
        wl.generate();
        this.table = this.pfac.table;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.msbb.isRightGB(this.M));
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1),(b,1,0) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,),(b,),(c,) } )", (boolean)this.msbb.isRightGB(this.N));
        ModSolvableGroebnerBaseTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.msbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,b,c,d) } )", (boolean)this.msbb.isRightGB(this.N));
    }
}

