/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbmod.ModSolvableGroebnerBaseAbstract;
import edu.jas.gbmod.SolvResPart;
import edu.jas.gbmod.SolvResPolPart;
import edu.jas.gbmod.SolvableSyzygy;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.vector.ModuleList;
import edu.jas.vector.SolvableBasicLinAlg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SolvableSyzygyAbstract<C extends RingElem<C>>
implements SolvableSyzygy<C> {
    private static final Logger logger = Logger.getLogger(SolvableSyzygyAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected SolvableReduction<C> sred;
    protected Reduction<C> red = new ReductionSeq();
    protected SolvableBasicLinAlg<C> sblas;

    public SolvableSyzygyAbstract() {
        this.sred = new SolvableReductionSeq();
        this.sblas = new SolvableBasicLinAlg();
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(List<GenSolvablePolynomial<C>> F2) {
        return this.leftZeroRelations(0, F2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(int modv, List<GenSolvablePolynomial<C>> F2) {
        void var10_9;
        ArrayList<List<GenSolvablePolynomial<C>>> Z = new ArrayList<List<GenSolvablePolynomial<C>>>();
        ArrayList S = new ArrayList(F2.size());
        int i = 0;
        while (i < F2.size()) {
            S.add(null);
            ++i;
        }
        GenPolynomial zero = null;
        boolean bl = false;
        while (var10_9 < F2.size()) {
            GenSolvablePolynomial<C> pi = F2.get((int)var10_9);
            if (pi != null && zero == null) {
                zero = pi.ring.getZERO();
            }
            void j = var10_9 + true;
            while (j < F2.size()) {
                GenSolvablePolynomial<C> pj = F2.get((int)j);
                if (this.red.moduleCriterion(modv, pi, pj)) {
                    ArrayList row = (ArrayList)S.clone();
                    GenSolvablePolynomial<C> s = this.sred.leftSPolynomial(row, (int)var10_9, pi, (int)j, pj);
                    if (s.isZERO()) {
                        Z.add(row);
                    } else {
                        GenSolvablePolynomial<C> h = this.sred.leftNormalform(row, F2, s);
                        if (!h.isZERO()) {
                            throw new ArithmeticException("Syzygy no leftGB");
                        }
                        if (logger.isDebugEnabled()) {
                            logger.info((Object)("row = " + row));
                        }
                        Z.add(row);
                    }
                }
                ++j;
            }
            ++var10_9;
        }
        for (List list : Z) {
            int j = 0;
            while (j < list.size()) {
                if (list.get(j) == null) {
                    list.set(j, zero);
                }
                ++j;
            }
        }
        return Z;
    }

    @Override
    public ModuleList<C> leftZeroRelations(ModuleList<C> M) {
        ModuleList N2 = null;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        GenSolvablePolynomial zero = (GenSolvablePolynomial)M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        logger.info((Object)("modv = " + modv));
        List<List<GenSolvablePolynomial<C>>> G = this.leftZeroRelations(modv, F2.castToSolvableList());
        if (G == null) {
            return N2;
        }
        ArrayList Z = new ArrayList();
        int i = 0;
        while (i < G.size()) {
            List<GenSolvablePolynomial<C>> Gi = G.get(i);
            ArrayList<GenSolvablePolynomial> Zi = new ArrayList<GenSolvablePolynomial>();
            int j = 0;
            while (j < Gi.size()) {
                GenSolvablePolynomial p = Gi.get(j);
                if (p != null) {
                    Map r = p.contract(M.ring);
                    if (r.size() == 0) {
                        Zi.add(zero);
                    } else if (r.size() == 1) {
                        GenSolvablePolynomial vi = (GenSolvablePolynomial)r.values().toArray()[0];
                        Zi.add(vi);
                    } else {
                        throw new RuntimeException("Map.size() > 1 = " + r.size());
                    }
                }
                ++j;
            }
            Z.add(Zi);
            ++i;
        }
        N2 = new ModuleList((GenSolvablePolynomialRing)M.ring, Z);
        return N2;
    }

    @Override
    public boolean isLeftZeroRelation(List<List<GenSolvablePolynomial<C>>> Z, List<GenSolvablePolynomial<C>> F2) {
        for (List<GenSolvablePolynomial<C>> row : Z) {
            GenSolvablePolynomial<C> p = this.sblas.leftScalarProduct(row, F2);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p));
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(List<List<GenSolvablePolynomial<C>>> Z, List<GenSolvablePolynomial<C>> F2) {
        boolean isit = true;
        for (List<GenSolvablePolynomial<C>> row : Z) {
            GenSolvablePolynomial<C> p = this.sblas.leftScalarProduct(F2, row);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p));
            isit = false;
            return false;
        }
        return isit;
    }

    @Override
    public boolean isLeftZeroRelation(ModuleList<C> Z, ModuleList<C> F2) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List<GenSolvablePolynomial<C>> row : Z.castToSolvableList()) {
            List<GenSolvablePolynomial<C>> zr = this.sblas.leftScalarProduct(row, F2);
            if (this.sblas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(ModuleList<C> Z, ModuleList<C> F2) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List<GenSolvablePolynomial<C>> row : Z.castToSolvableList()) {
            List<GenSolvablePolynomial<C>> zr = this.sblas.rightScalarProduct(row, F2);
            if (this.sblas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public List<SolvResPart<C>> resolution(ModuleList<C> M) {
        ArrayList<SolvResPart<C>> R = new ArrayList<SolvResPart<C>>();
        ModuleList<C> MM = M;
        ModSolvableGroebnerBaseAbstract<C> msbb = new ModSolvableGroebnerBaseAbstract<C>();
        while (true) {
            ModuleList<C> GM = msbb.leftGB(MM);
            ModuleList<C> Z = this.leftZeroRelations(GM);
            R.add(new SolvResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolution(PolynomialList<C> F2) {
        SolvableGroebnerBaseSeq<C> sbb = new SolvableGroebnerBaseSeq<C>();
        List<GenSolvablePolynomial<C>> G = sbb.leftGB(F2.castToSolvableList());
        List<List<GenSolvablePolynomial<C>>> Z = this.leftZeroRelations(G);
        PolynomialList<C> Gl = new PolynomialList<C>((GenSolvablePolynomialRing)F2.ring, G);
        ModuleList<C> Zm = new ModuleList<C>((GenSolvablePolynomialRing)F2.ring, Z);
        List<SolvResPart<C>> R = this.resolution(Zm);
        R.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(F2, Gl, Zm)));
        return R;
    }

    @Override
    public List<SolvResPart<C>> resolutionArbitrary(ModuleList<C> M) {
        ArrayList<SolvResPart<C>> R = new ArrayList<SolvResPart<C>>();
        ModuleList<C> MM = M;
        ModuleList GM = null;
        while (true) {
            ModuleList<C> Z = this.leftZeroRelationsArbitrary(MM);
            R.add(new SolvResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> F2) {
        PolynomialList Gl = null;
        List<List<GenSolvablePolynomial<C>>> Z = this.leftZeroRelationsArbitrary(F2.castToSolvableList());
        ModuleList<C> Zm = new ModuleList<C>((GenSolvablePolynomialRing)F2.ring, Z);
        List<SolvResPart<C>> R = this.resolutionArbitrary(Zm);
        R.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(F2, Gl, Zm)));
        return R;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> F2) {
        return this.leftZeroRelationsArbitrary(0, F2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (F2 == null) {
            return null;
        }
        if (F2.size() <= 1) {
            return this.leftZeroRelations(modv, F2);
        }
        int lenf = F2.size();
        SolvableGroebnerBaseSeq<C> sgb = new SolvableGroebnerBaseSeq<C>();
        SolvableExtendedGB<C> exgb = sgb.extLeftGB(F2);
        if (this.debug) {
            logger.info((Object)("exgb = " + exgb));
        }
        if (!sgb.isLeftReductionMatrix(exgb)) {
            logger.error((Object)"is reduction matrix ? false");
        }
        List G = exgb.G;
        List G2F = exgb.G2F;
        List F2G = exgb.F2G;
        List sg = this.leftZeroRelations(modv, G);
        GenSolvablePolynomialRing ring = G.get((int)0).ring;
        ModuleList S = new ModuleList(ring, sg);
        if (this.debug) {
            logger.info((Object)("syz = " + S));
        }
        if (!this.isLeftZeroRelation(sg, G)) {
            logger.error((Object)"is syzygy ? false");
        }
        ArrayList<List<GenSolvablePolynomial<C>>> sf = new ArrayList<List<GenSolvablePolynomial<C>>>(sg.size());
        for (List r : sg) {
            void var17_21;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            ArrayList<GenPolynomial> arrayList = new ArrayList<GenPolynomial>(lenf);
            int m = 0;
            while (m < lenf) {
                arrayList.add(ring.getZERO());
                ++m;
            }
            while (it.hasNext() && jt.hasNext()) {
                GenSolvablePolynomial si = (GenSolvablePolynomial)it.next();
                List ai = jt.next();
                if (si == null || ai == null) continue;
                List<GenSolvablePolynomial<C>> pi = this.sblas.leftScalarProduct(si, ai);
                List<GenSolvablePolynomial<C>> list = this.sblas.vectorAdd((List<GenSolvablePolynomial<C>>)var17_21, pi);
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"leftZeroRelationsArbitrary wrong sizes");
            }
            sf.add((List<GenSolvablePolynomial<C>>)var17_21);
        }
        if (!this.isLeftZeroRelation(sf, F2)) {
            logger.error((Object)"is partial syz sf ? false");
        }
        ArrayList M = new ArrayList(lenf);
        for (List list : F2G) {
            Iterator it = list.iterator();
            Iterator iterator = G2F.iterator();
            List rf = new ArrayList(lenf);
            int m = 0;
            while (m < lenf) {
                rf.add(ring.getZERO());
                ++m;
            }
            while (it.hasNext() && iterator.hasNext()) {
                GenSolvablePolynomial si = (GenSolvablePolynomial)it.next();
                List ai = iterator.next();
                if (si == null || ai == null) continue;
                List<GenSolvablePolynomial<C>> pi = this.sblas.leftScalarProduct(si, ai);
                rf = this.sblas.vectorAdd(rf, pi);
            }
            if (it.hasNext() || iterator.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            M.add(rf);
        }
        int n = sf.size();
        ArrayList M2 = new ArrayList(lenf);
        int i = 0;
        for (List list : M) {
            ArrayList r2i = new ArrayList(list.size());
            int j = 0;
            for (GenSolvablePolynomial rij : list) {
                GenSolvablePolynomial p = null;
                if (i == j) {
                    p = (GenSolvablePolynomial)ring.getONE().subtract(rij);
                } else if (rij != null) {
                    p = (GenSolvablePolynomial)rij.negate();
                }
                r2i.add(p);
                ++j;
            }
            M2.add(r2i);
            if (!this.sblas.isZero(r2i)) {
                sf.add(r2i);
            }
            ++i;
        }
        ModuleList moduleList = new ModuleList(ring, M2);
        if (this.debug) {
            logger.debug((Object)("syz M2L = " + moduleList));
        }
        if (this.debug) {
            ModuleList SF = new ModuleList(ring, sf);
            logger.debug((Object)("syz sf = " + SF));
            logger.debug((Object)("#syz " + n + ", " + sf.size()));
        }
        if (!this.isLeftZeroRelation(sf, F2)) {
            logger.error((Object)"is syz sf ? false");
        }
        return sf;
    }

    @Override
    public ModuleList<C> leftZeroRelationsArbitrary(ModuleList<C> M) {
        ModuleList N2 = null;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        GenSolvablePolynomial zero = (GenSolvablePolynomial)M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        logger.info((Object)("modv = " + modv));
        List<List<GenSolvablePolynomial<C>>> G = this.leftZeroRelationsArbitrary(modv, F2.castToSolvableList());
        if (G == null) {
            return N2;
        }
        ArrayList Z = new ArrayList();
        int i = 0;
        while (i < G.size()) {
            List<GenSolvablePolynomial<C>> Gi = G.get(i);
            ArrayList<GenSolvablePolynomial> Zi = new ArrayList<GenSolvablePolynomial>();
            int j = 0;
            while (j < Gi.size()) {
                GenSolvablePolynomial p = Gi.get(j);
                if (p != null) {
                    Map r = p.contract(M.ring);
                    if (r.size() == 0) {
                        Zi.add(zero);
                    } else if (r.size() == 1) {
                        GenSolvablePolynomial vi = (GenSolvablePolynomial)r.values().toArray()[0];
                        Zi.add(vi);
                    } else {
                        throw new RuntimeException("Map.size() > 1 = " + r.size());
                    }
                }
                ++j;
            }
            Z.add(Zi);
            ++i;
        }
        N2 = new ModuleList((GenSolvablePolynomialRing)M.ring, Z);
        return N2;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> F2) {
        return this.rightZeroRelationsArbitrary(0, F2);
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(int modv, List<GenSolvablePolynomial<C>> F2) {
        GenSolvablePolynomial q;
        ArrayList<List<GenSolvablePolynomial<Object>>> Z;
        GenPolynomialRing ring = null;
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            ring = p.ring;
            break;
        }
        if (ring == null) {
            Z = new ArrayList<List<GenSolvablePolynomial<C>>>(1);
            Z.add(F2);
            return Z;
        }
        GenPolynomialRing rring = ((GenSolvablePolynomialRing)ring).reverse(true);
        ArrayList rF = new ArrayList(F2.size());
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(rring);
            rF.add(q);
        }
        PolynomialList pl = new PolynomialList(rring, rF);
        System.out.println("reversed problem = " + pl);
        List rZ = this.leftZeroRelationsArbitrary(modv, rF);
        if (this.debug) {
            boolean isit = this.isLeftZeroRelation(rZ, rF);
            logger.debug((Object)("isLeftZeroRelation = " + isit));
        }
        GenPolynomialRing oring = ((GenSolvablePolynomialRing)rring).reverse(true);
        if (this.debug) {
            logger.debug((Object)("ring == oring: " + ((GenSolvablePolynomialRing)ring).equals(oring)));
        }
        ring = oring;
        Z = new ArrayList(rZ.size());
        for (List z : rZ) {
            if (z == null) continue;
            ArrayList<GenSolvablePolynomial> s = new ArrayList<GenSolvablePolynomial>(z.size());
            for (GenSolvablePolynomial p : z) {
                if (p == null) continue;
                q = (GenSolvablePolynomial)p.reverse(ring);
                s.add(q);
            }
            Z.add(s);
        }
        return Z;
    }
}

