/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.gbmod.ModSolvableGroebnerBaseAbstract;
import edu.jas.gbmod.SolvableSyzygy;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.vector.ModuleList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableSyzygyTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> fac;
    PolynomialList<BigRational> F;
    List<GenSolvablePolynomial<BigRational>> G;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<BigRational> zero;
    GenSolvablePolynomial<BigRational> one;
    TermOrder tord;
    RelationTable table;
    List<GenSolvablePolynomial<BigRational>> L;
    List<List<GenSolvablePolynomial<BigRational>>> K;
    List<GenSolvablePolynomial<BigRational>> V;
    List<List<GenSolvablePolynomial<BigRational>>> W;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModuleList<BigRational> Z;
    SolvableGroebnerBase<BigRational> sbb;
    ModSolvableGroebnerBase<BigRational> msbb;
    SolvableSyzygy<BigRational> ssz;
    int rl = 4;
    int kl = 5;
    int ll = 7;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableSyzygyTest.suite());
    }

    public SolvableSyzygyTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SolvableSyzygyTest.class);
        return suite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.tord = new TermOrder();
        this.fac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.table = this.fac.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.fac.getONE();
        this.zero = this.fac.getZERO();
        this.sbb = new SolvableGroebnerBaseSeq<BigRational>();
        this.msbb = new ModSolvableGroebnerBaseAbstract<BigRational>();
        this.ssz = new SolvableSyzygyAbstract<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        this.fac = null;
        this.tord = null;
        this.table = null;
        this.sbb = null;
        this.msbb = null;
        this.ssz = null;
    }

    public void testSequentialSolvableSyzygy() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialWeylSolvableSyzygy() {
        int rloc = 4;
        this.fac = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.fac);
        wl.generate();
        this.table = this.fac.table;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialModSolvableSyzygy() {
        this.W = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a,b,c) } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
    }

    public void testSequentialArbitrarySyzygy() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitrarySyzygyCLO() {
        PolynomialList F2 = null;
        String exam = "Rat(x,y) G ( ( x y + x ), ( y^2 + 1 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            F2 = parser.nextSolvablePolynomialSet();
        }
        catch (ClassCastException e) {
            SolvableSyzygyTest.fail((String)("" + e));
        }
        catch (IOException e) {
            SolvableSyzygyTest.fail((String)("" + e));
        }
        this.L = F2.castToSolvableList();
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitrarySyzygyWA32() {
        PolynomialList F2 = null;
        String exam = "Rat(e1,e2,e3) L RelationTable (  ( e3 ), ( e1 ), ( e1 e3 - e1 ),  ( e3 ), ( e2 ), ( e2 e3 - e2 ) )(  ( e1 e3^3 + e2^2 ),  ( e1^3 e2^2 + e3 ),  ( e3^3 + e3^2 ) ) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        try {
            F2 = parser.nextSolvablePolynomialSet();
        }
        catch (ClassCastException e) {
            SolvableSyzygyTest.fail((String)("" + e));
        }
        catch (IOException e) {
            SolvableSyzygyTest.fail((String)("" + e));
        }
        this.L = F2.castToSolvableList();
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitraryModSolvableSyzygy() {
        this.W = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
    }
}

