/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GBFactory;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbmod.ModGroebnerBaseAbstract;
import edu.jas.gbmod.ResPart;
import edu.jas.gbmod.ResPolPart;
import edu.jas.gbmod.Syzygy;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.ModulElem;
import edu.jas.vector.BasicLinAlg;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyzygyAbstract<C extends GcdRingElem<C>>
implements Syzygy<C> {
    private static final Logger logger = Logger.getLogger(SyzygyAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected Reduction<C> red = new ReductionSeq();
    protected BasicLinAlg<C> blas = new BasicLinAlg();

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(List<GenPolynomial<C>> F2) {
        return this.zeroRelations(0, F2);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int modv, List<GenPolynomial<C>> F2) {
        ArrayList<List<GenPolynomial<C>>> Z = new ArrayList<List<GenPolynomial<C>>>();
        if (F2 == null) {
            return Z;
        }
        GenVectorModul mfac = null;
        int i = 0;
        while (mfac == null && i < F2.size()) {
            GenPolynomial<C> p = F2.get(i);
            if (p == null) continue;
            mfac = new GenVectorModul(p.ring, F2.size());
        }
        if (mfac == null) {
            return Z;
        }
        ModulElem v = mfac.fromList(F2);
        return this.zeroRelations(modv, (GenVector<GenPolynomial<C>>)v);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int modv, GenVector<GenPolynomial<C>> v) {
        ArrayList<List<GenPolynomial<C>>> Z = new ArrayList<List<GenPolynomial<C>>>();
        GenVectorModul mfac = v.modul;
        List F2 = v.val;
        AbelianGroupElem S = mfac.getZERO();
        GenPolynomial zero = (GenPolynomial)mfac.coFac.getZERO();
        int i = 0;
        while (i < F2.size()) {
            GenPolynomial pi = (GenPolynomial)F2.get(i);
            int j = i + 1;
            while (j < F2.size()) {
                GenPolynomial pj = (GenPolynomial)F2.get(j);
                if (this.red.moduleCriterion(modv, pi, pj)) {
                    List row = ((GenVector)((GenVector)S).clone()).val;
                    GenPolynomial<C> s = this.red.SPolynomial(row, i, pi, j, pj);
                    if (s.isZERO()) {
                        Z.add(row);
                    } else {
                        GenPolynomial<C> h = this.red.normalform(row, F2, s);
                        if (!h.isZERO()) {
                            throw new RuntimeException("Syzygy no GB");
                        }
                        if (this.debug) {
                            logger.info((Object)("row = " + row.size()));
                        }
                        Z.add(row);
                    }
                }
                ++j;
            }
            ++i;
        }
        return Z;
    }

    @Override
    public ModuleList<C> zeroRelations(ModuleList<C> M) {
        ModuleList<C> N2 = M;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        AbelianGroupElem zero = M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        List G = this.zeroRelations(modv, F2.list);
        if (G == null) {
            return N2;
        }
        ArrayList Z = new ArrayList();
        int i = 0;
        while (i < G.size()) {
            List Gi = G.get(i);
            ArrayList<AbelianGroupElem> Zi = new ArrayList<AbelianGroupElem>();
            int j = 0;
            while (j < Gi.size()) {
                GenPolynomial p = Gi.get(j);
                if (p != null) {
                    Map r = p.contract(M.ring);
                    int s = 0;
                    for (GenPolynomial vi : r.values()) {
                        Zi.add(vi);
                        ++s;
                    }
                    if (s == 0) {
                        Zi.add(zero);
                    } else if (s > 1) {
                        System.out.println("p = " + p);
                        System.out.println("map(" + i + "," + j + ") = " + r + ", size = " + r.size());
                        throw new RuntimeException("Map.size() > 1 = " + r.size());
                    }
                }
                ++j;
            }
            Z.add(Zi);
            ++i;
        }
        N2 = new ModuleList(M.ring, Z);
        return N2;
    }

    @Override
    public boolean isZeroRelation(List<List<GenPolynomial<C>>> Z, List<GenPolynomial<C>> F2) {
        for (List<GenPolynomial<C>> row : Z) {
            GenPolynomial<C> p = this.blas.scalarProduct(row, F2);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p.toString(p.ring.getVars())));
            logger.info((Object)("row = " + row));
            return false;
        }
        return true;
    }

    @Override
    public boolean isZeroRelation(ModuleList<C> Z, ModuleList<C> F2) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List row : Z.list) {
            List<GenPolynomial<C>> zr = this.blas.scalarProduct(row, F2);
            if (this.blas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public List<ResPart<C>> resolution(ModuleList<C> M) {
        ArrayList<ResPart<C>> R = new ArrayList<ResPart<C>>();
        ModuleList<C> MM = M;
        ModGroebnerBaseAbstract<C> mbb = new ModGroebnerBaseAbstract<C>(M.ring.coFac);
        while (true) {
            ModuleList<C> GM = mbb.GB(MM);
            ModuleList<C> Z = this.zeroRelations(GM);
            R.add(new ResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolution(PolynomialList<C> F2) {
        GroebnerBaseAbstract gb = GBFactory.getImplementation(F2.ring.coFac);
        List G = gb.GB(F2.list);
        List Z = this.zeroRelations(G);
        PolynomialList Gl = new PolynomialList(F2.ring, G);
        ModuleList Zm = new ModuleList(F2.ring, Z);
        List R = this.resolution(Zm);
        R.add(0, new ResPolPart<C>(F2, Gl, Zm));
        return R;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> F2) {
        PolynomialList Gl = null;
        List Z = this.zeroRelationsArbitrary(F2.list);
        ModuleList Zm = new ModuleList(F2.ring, Z);
        List R = this.resolutionArbitrary(Zm);
        R.add(0, new ResPolPart<C>(F2, Gl, Zm));
        return R;
    }

    @Override
    public List<ResPart<C>> resolutionArbitrary(ModuleList<C> M) {
        ArrayList<ResPart<C>> R = new ArrayList<ResPart<C>>();
        ModuleList<C> MM = M;
        ModuleList GM = null;
        while (true) {
            ModuleList<C> Z = this.zeroRelationsArbitrary(MM);
            R.add(new ResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(List<GenPolynomial<C>> F2) {
        return this.zeroRelationsArbitrary(0, F2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(int modv, List<GenPolynomial<C>> F2) {
        if (F2 == null) {
            return this.zeroRelations(modv, F2);
        }
        if (F2.size() <= 1) {
            return this.zeroRelations(modv, F2);
        }
        GroebnerBaseAbstract<C> gb = GBFactory.getImplementation(F2.get((int)0).ring.coFac);
        int lenf = F2.size();
        ExtendedGB<C> exgb = gb.extGB(F2);
        if (this.debug) {
            logger.debug((Object)("exgb = " + exgb));
            if (!gb.isReductionMatrix(exgb)) {
                logger.error((Object)"is reduction matrix ? false");
            }
        }
        List G = exgb.G;
        List G2F = exgb.G2F;
        List F2G = exgb.F2G;
        List sg = this.zeroRelations(modv, G);
        GenPolynomialRing ring = G.get((int)0).ring;
        ModuleList S = new ModuleList(ring, sg);
        if (this.debug) {
            logger.debug((Object)("syz = " + S));
            if (!this.isZeroRelation(sg, G)) {
                logger.error((Object)"is syzygy ? false");
            }
        }
        ArrayList<List<GenPolynomial<C>>> sf = new ArrayList<List<GenPolynomial<C>>>(sg.size());
        for (List r : sg) {
            void var17_21;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            ArrayList<AbelianGroupElem> arrayList = new ArrayList<AbelianGroupElem>(lenf);
            int m = 0;
            while (m < lenf) {
                arrayList.add(ring.getZERO());
                ++m;
            }
            while (it.hasNext() && jt.hasNext()) {
                GenPolynomial si = (GenPolynomial)it.next();
                List ai = jt.next();
                if (si == null || ai == null) continue;
                List<GenPolynomial<C>> pi = this.blas.scalarProduct(si, ai);
                List<GenPolynomial<C>> list = this.blas.vectorAdd((List<GenPolynomial<C>>)var17_21, pi);
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            sf.add((List<GenPolynomial<C>>)var17_21);
        }
        ArrayList M = new ArrayList(lenf);
        for (List list : F2G) {
            Iterator it = list.iterator();
            Iterator iterator = G2F.iterator();
            List rf = new ArrayList(lenf);
            int m = 0;
            while (m < lenf) {
                rf.add(ring.getZERO());
                ++m;
            }
            while (it.hasNext() && iterator.hasNext()) {
                GenPolynomial si = (GenPolynomial)it.next();
                List ai = iterator.next();
                if (si == null || ai == null) continue;
                List<GenPolynomial<C>> pi = this.blas.scalarProduct(ai, si);
                rf = this.blas.vectorAdd(rf, pi);
            }
            if (it.hasNext() || iterator.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            M.add(rf);
        }
        int n = sf.size();
        ArrayList M2 = new ArrayList(lenf);
        int i = 0;
        for (List list : M) {
            ArrayList r2i = new ArrayList(list.size());
            int j = 0;
            for (GenPolynomial rij : list) {
                AbelianGroupElem p = null;
                if (i == j) {
                    p = ((GenPolynomial)ring.getONE()).subtract(rij);
                } else if (rij != null) {
                    p = rij.negate();
                }
                r2i.add(p);
                ++j;
            }
            M2.add(r2i);
            if (!this.blas.isZero(r2i)) {
                sf.add(r2i);
            }
            ++i;
        }
        if (this.debug) {
            ModuleList moduleList = new ModuleList(ring, M2);
            logger.debug((Object)("syz M2L = " + moduleList));
            ModuleList SF = new ModuleList(ring, sf);
            logger.debug((Object)("syz sf = " + SF));
            logger.debug((Object)("#syz " + n + ", " + sf.size()));
            if (!this.isZeroRelation(sf, F2)) {
                logger.error((Object)"is syz sf ? false");
            }
        }
        return sf;
    }

    @Override
    public ModuleList<C> zeroRelationsArbitrary(ModuleList<C> M) {
        ModuleList<C> N2 = M;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        AbelianGroupElem zero = M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        List G = this.zeroRelationsArbitrary(modv, F2.list);
        if (G == null) {
            return N2;
        }
        ArrayList Z = new ArrayList();
        int i = 0;
        while (i < G.size()) {
            List Gi = G.get(i);
            ArrayList<AbelianGroupElem> Zi = new ArrayList<AbelianGroupElem>();
            int j = 0;
            while (j < Gi.size()) {
                GenPolynomial p = Gi.get(j);
                if (p != null) {
                    Map r = p.contract(M.ring);
                    int s = 0;
                    for (GenPolynomial vi : r.values()) {
                        Zi.add(vi);
                        ++s;
                    }
                    if (s == 0) {
                        Zi.add(zero);
                    } else if (s > 1) {
                        System.out.println("p = " + p);
                        System.out.println("map(" + i + "," + j + ") = " + r + ", size = " + r.size());
                        throw new RuntimeException("Map.size() > 1 = " + r.size());
                    }
                }
                ++j;
            }
            Z.add(Zi);
            ++i;
        }
        N2 = new ModuleList(M.ring, Z);
        return N2;
    }
}

