/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.hermite;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeFieldChar0;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;

public class HermiteReduce {
    SquarefreeFieldChar0<BigRational> sqf;
    GreatestCommonDivisorAbstract<BigRational> ufd;
    GenPolynomialRing<BigRational> fac;

    public HermiteReduce() {
        BigRational br = new BigRational(0L);
        String[] vars = new String[]{"x"};
        this.fac = new GenPolynomialRing<BigRational>(br, vars.length, new TermOrder(2), vars);
        this.ufd = GCDFactory.getProxy(br);
        this.sqf = new SquarefreeFieldChar0<BigRational>(br);
    }

    public GenPolynomial<BigRational>[] evaluate(GenPolynomial<BigRational> a, GenPolynomial<BigRational> d) {
        SortedMap<GenPolynomial<BigRational>, Long> sfactors = this.sqf.squarefreeFactors((BigRational)((Object)d));
        ArrayList<MonoidElem> Di = new ArrayList<MonoidElem>();
        Di.add(this.fac.getONE());
        for (GenPolynomial<BigRational> f : sfactors.keySet()) {
            Di.add(f);
        }
        System.out.println("D_i: " + ((Object)Di).toString());
        ArrayList DPower = new ArrayList();
        int i = 0;
        while (i < Di.size()) {
            DPower.add(Power.positivePower((GenPolynomial)Di.get(i), i + 1));
            ++i;
        }
        System.out.println(DPower);
        List<GenPolynomial<BigRational>> Ai = this.ufd.basePartialFraction(a, DPower);
        System.out.println("A_i: " + Ai.toString());
        GenPolynomial<RingElem<BigRational>> g = new GenPolynomial<BigRational>(this.fac);
        GenPolynomial<GenPolynomial<BigRational>> h = Ai.get(0).sum((BigRational)((Object)Ai.get(1).divide((GenPolynomial)Di.get(1))));
        int n = Di.size();
        int k = 2;
        while (k <= n) {
            if (((GenPolynomial)Di.get(k - 1)).degree(0) > 0L) {
                GenPolynomial v = (GenPolynomial)Di.get(k - 1);
                int j = k - 1;
                while (j >= 1) {
                    System.out.println("Step(" + k + "," + j + ")");
                    System.out.println("V:" + v.toString());
                    GenPolynomial DV_dx = PolyUtil.baseDeriviative(v);
                    GenPolynomial<BigRational>[] BC = this.ufd.baseGcdDiophant(DV_dx, v, ((GenPolynomial)Ai.get(k).negate()).divide(this.fac.fromInteger(j)));
                    GenPolynomial<BigRational> b = BC[0];
                    GenPolynomial<BigRational> c = BC[1];
                    g = g.sum((BigRational)((Object)b.divide(Power.positivePower(v, j))));
                    Ai.set(k, ((GenPolynomial)((GenPolynomial)this.fac.fromInteger(j)).negate()).multiply(c).subtract(PolyUtil.baseDeriviative(b)));
                    System.out.println("B:" + b.toString());
                    System.out.println("C:" + c.toString());
                    --j;
                }
                h = h.sum(Ai.get(k).divide(v));
            }
            ++k;
        }
        GenPolynomial[] ret = new GenPolynomial[]{g, h};
        return ret;
    }

    public GenPolynomial<BigRational> xPow(long coeff, long exp) {
        if (exp == 0L) {
            return this.fac.fromInteger(coeff);
        }
        ExpVector e = ExpVector.create(1, 0, exp);
        return ((GenPolynomial)this.fac.fromInteger(coeff)).multiply(e);
    }

    public static void main(String[] args) {
        HermiteReduce hr = new HermiteReduce();
        GenPolynomial<GenPolynomial<BigRational>> a = hr.xPow(1L, 7L).sum((BigRational)((Object)hr.xPow(-24L, 4L))).sum(hr.xPow(-4L, 2L)).sum(hr.xPow(8L, 1L)).sum(hr.xPow(-8L, 0L));
        System.out.println("A: " + a.toString());
        GenPolynomial<GenPolynomial<BigRational>> d = hr.xPow(1L, 8L).sum((BigRational)((Object)hr.xPow(6L, 6L))).sum(hr.xPow(12L, 4L)).sum(hr.xPow(8L, 2L));
        System.out.println("D: " + d.toString());
        GenPolynomial<BigRational>[] ret = hr.evaluate(a, d);
        System.out.println("Result: " + ret[0].toString() + "," + ret[1].toString());
        System.out.println("-----");
        System.exit(0);
    }
}

