/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ElementaryIntegrationTest
extends TestCase {
    TermOrder tord;
    QuotientRing<BigRational> qfac;
    GenPolynomialRing<BigRational> mfac;
    ElementaryIntegration<BigRational> integrator;
    QuotIntegral<BigRational> rint;
    Quotient<BigRational> a;
    Quotient<BigRational> b;
    Quotient<BigRational> c;
    Quotient<BigRational> d;
    Quotient<BigRational> e;
    int rl = 1;
    int kl = 5;
    int ll = 3;
    int el = 4;
    float q = 0.4f;

    public static void main(String[] args) {
        TestRunner.run((Test)ElementaryIntegrationTest.suite());
    }

    public ElementaryIntegrationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ElementaryIntegrationTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.tord = new TermOrder(2);
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x"};
        this.mfac = new GenPolynomialRing<BigRational>(br, this.rl, this.tord, vars);
        this.qfac = new QuotientRing<BigRational>(this.mfac);
        this.integrator = new ElementaryIntegration<BigRational>(br);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.qfac = null;
        ComputerThreads.terminate();
    }

    public void testRational() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void testPureLogarithm1() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void testPureLogarithmD() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial pp = PolyUtil.baseDeriviative(this.a.den);
            this.b = new Quotient<BigRational>(this.qfac, pp, this.a.den);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void testRationalWithLogarithmD() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            GenPolynomial pp = PolyUtil.baseDeriviative(this.a.den);
            this.c = new Quotient<BigRational>(this.qfac, pp, this.a.den);
            this.e = this.b.sum(this.c);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void xtestRationalWithLogarithm1() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            this.d = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.e = this.b.sum(this.d);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void testRationalWithLogarithm() {
        int i = 0;
        while (i < 3) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            GenPolynomial pp = PolyUtil.baseDeriviative(this.a.den);
            this.c = new Quotient<BigRational>(this.qfac, pp, this.a.den);
            this.d = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.e = this.b.sum(this.c).sum(this.d);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
            ++i;
        }
    }

    public void testRationalRecursive() {
        String[] vars = new String[]{"y"};
        GenPolynomialRing<BigRational> qmfac = new GenPolynomialRing<BigRational>(this.qfac, 1, this.tord, vars);
        QuotientRing<BigRational> qqfac = new QuotientRing<BigRational>(qmfac);
        ElementaryIntegration<BigRational> qintegrator = new ElementaryIntegration<BigRational>(this.qfac);
        int i = 0;
        while (i < 2) {
            Quotient<BigRational> qa = qqfac.random(2, this.ll, this.el, this.q);
            Quotient<BigRational> qb = qintegrator.deriviative(qa);
            QuotIntegral<BigRational> qrint = qintegrator.integrate(qb);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)qintegrator.isIntegral(qrint));
            ++i;
        }
    }
}

