/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;

public class LogIntegral<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;
    public final List<C> cfactors;
    public final List<GenPolynomial<C>> cdenom;
    public final List<AlgebraicNumber<C>> afactors;
    public final List<GenPolynomial<AlgebraicNumber<C>>> adenom;

    public LogIntegral(GenPolynomial<C> n, GenPolynomial<C> d, List<C> cf, List<GenPolynomial<C>> cd, List<AlgebraicNumber<C>> af, List<GenPolynomial<AlgebraicNumber<C>>> ad) {
        this.num = n;
        this.den = d;
        this.cfactors = cf;
        this.cdenom = cd;
        this.afactors = af;
        this.adenom = ad;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.cfactors.size()) {
            GcdRingElem cp = (GcdRingElem)this.cfactors.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(" + ");
            }
            sb.append("(" + cp.toString() + ")");
            GenPolynomial<C> p = this.cdenom.get(i);
            sb.append(" log( " + p.toString() + ")");
            ++i;
        }
        if (!first && this.afactors.size() > 0) {
            sb.append(" + ");
        }
        first = true;
        i = 0;
        while (i < this.afactors.size()) {
            if (first) {
                first = false;
            } else {
                sb.append(" + ");
            }
            AlgebraicNumber<C> ap = this.afactors.get(i);
            ElemFactory ar = ap.factory();
            GenPolynomial<AlgebraicNumber<C>> p = this.adenom.get(i);
            if (p.degree(0) < ((AlgebraicNumberRing)ar).modul.degree(0) && ((AlgebraicNumberRing)ar).modul.degree(0) > 2L) {
                sb.append("sum_(" + ((AlgebraicNumberRing)ar).getGenerator() + " in ");
                sb.append("rootOf(" + ((AlgebraicNumberRing)ar).modul + ") ) ");
            }
            sb.append("(" + ap.toString() + ")");
            sb.append(" log( " + p.toString() + ")");
            ++i;
        }
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + this.num.toString() + ")");
        sb.append(" / ");
        sb.append("(" + this.den.toString() + ")");
        sb.append(" =\n");
        boolean first = true;
        for (GcdRingElem gcdRingElem : this.cfactors) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(gcdRingElem.toString());
        }
        if (!first) {
            sb.append(" linear denominators: ");
        }
        first = true;
        for (GenPolynomial genPolynomial : this.cdenom) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(genPolynomial.toString());
        }
        if (!first) {
            sb.append("; ");
        }
        first = true;
        for (AlgebraicNumber algebraicNumber : this.afactors) {
            if (first) {
                first = false;
            }
            sb.append(algebraicNumber.toString());
            sb.append(" ## over " + algebraicNumber.factory() + "\n");
        }
        if (!first) {
            sb.append(" denominators: ");
        }
        first = true;
        for (GenPolynomial genPolynomial : this.adenom) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(genPolynomial.toString());
        }
        return sb.toString();
    }

    public String toScript() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.num.toScript());
        sb.append(" / ");
        sb.append(this.den.toScript());
        sb.append(" = ");
        boolean first = true;
        for (GcdRingElem gcdRingElem : this.cfactors) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(gcdRingElem.toScript());
        }
        if (!first) {
            sb.append(" linear denominators: ");
        }
        first = true;
        for (GenPolynomial genPolynomial : this.cdenom) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(genPolynomial.toScript());
        }
        if (!first) {
            sb.append(", ");
        }
        first = true;
        for (AlgebraicNumber algebraicNumber : this.afactors) {
            if (first) {
                first = false;
            }
            sb.append(algebraicNumber.toScript());
            sb.append(" ## over " + algebraicNumber.toScriptFactory() + "\n");
        }
        sb.append(" denominators: ");
        first = true;
        for (GenPolynomial genPolynomial : this.adenom) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(genPolynomial.toScript());
        }
        return sb.toString();
    }

    public int hashCode() {
        int h = this.num.hashCode();
        h = h * 37 + this.den.hashCode();
        h = h * 37 + this.cfactors.hashCode();
        h = h * 37 + this.cdenom.hashCode();
        h = h * 37 + this.afactors.hashCode();
        h = h * 37 + this.adenom.hashCode();
        return h;
    }

    public boolean equals(Object B) {
        boolean t;
        if (!(B instanceof LogIntegral)) {
            return false;
        }
        LogIntegral a = null;
        try {
            a = (LogIntegral)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        boolean bl = t = this.num.equals(a.num) && this.den.equals(a.den);
        if (!t) {
            return t;
        }
        t = this.cfactors.equals(a.cfactors);
        if (!t) {
            return t;
        }
        t = this.cdenom.equals(a.cdenom);
        if (!t) {
            return t;
        }
        t = this.afactors.equals(a.afactors);
        if (!t) {
            return t;
        }
        t = this.adenom.equals(a.adenom);
        return t;
    }
}

