/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.TSCallMock;
import edu.jas.kern.TimeExceededException;
import edu.jas.kern.TimeStatus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class TimeStatusTest
extends TestCase {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)TimeStatusTest.suite());
    }

    public TimeStatusTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TimeStatusTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        TimeStatus.setNotActive();
        TimeStatus.setLimit(Long.MAX_VALUE);
        TimeStatus.setCallBack(null);
    }

    public void testCheckTime() {
        TimeStatus.setActive();
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        TimeStatus.restart();
        try {
            TimeStatus.checkTime("test1");
        }
        catch (TimeExceededException e) {
            TimeStatusTest.fail((String)("test1 " + e));
        }
        TimeStatus.setLimit(0L);
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test2");
            TimeStatusTest.fail((String)"test2 checkTime");
        }
        catch (TimeExceededException e) {
        }
        catch (InterruptedException e) {
            TimeStatusTest.fail((String)"test2 interrupt");
        }
    }

    public void testCallBack() {
        TimeStatus.setActive();
        TimeStatus.restart();
        TimeStatus.setLimit(0L);
        TimeStatus.setCallBack(new TSCallMock(true));
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test3");
        }
        catch (TimeExceededException e) {
            TimeStatusTest.fail((String)"test3 checkTime");
        }
        catch (InterruptedException e) {
            TimeStatusTest.fail((String)"test3 interrupt");
        }
        TimeStatus.setCallBack(new TSCallMock(false));
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test4");
            TimeStatusTest.fail((String)"test4 checkTime");
        }
        catch (TimeExceededException e) {
        }
        catch (InterruptedException e) {
            TimeStatusTest.fail((String)"test4 interrupt");
        }
    }
}

