/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

class AlgebraicNumberIterator<C extends GcdRingElem<C>>
implements Iterator<AlgebraicNumber<C>> {
    final Iterator<List<C>> iter;
    final List<GenPolynomial<C>> powers;
    final AlgebraicNumberRing<C> aring;
    private static final Logger logger = Logger.getLogger(AlgebraicNumberIterator.class);

    public AlgebraicNumberIterator(AlgebraicNumberRing<C> aring) {
        RingFactory cf = aring.ring.coFac;
        this.aring = aring;
        long d = aring.modul.degree(0);
        this.powers = new ArrayList<GenPolynomial<C>>((int)d);
        long j = d - 1L;
        while (j >= 0L) {
            this.powers.add(aring.ring.univariate(0, j));
            --j;
        }
        if (!(cf instanceof Iterable)) {
            throw new IllegalArgumentException("only for iterable coefficients implemented");
        }
        ArrayList<Iterable<Iterable>> comps = new ArrayList<Iterable<Iterable>>((int)d);
        Iterable cfi = (Iterable)((Object)cf);
        long j2 = 0L;
        while (j2 < d) {
            comps.add(cfi);
            ++j2;
        }
        if (cf.isFinite()) {
            CartesianProduct tuples = new CartesianProduct(comps);
            this.iter = tuples.iterator();
        } else {
            CartesianProductInfinite tuples = new CartesianProductInfinite(comps);
            this.iter = tuples.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public AlgebraicNumber<C> next() {
        List<C> coeffs = this.iter.next();
        GenPolynomial<GenPolynomial<GcdRingElem>> pol = this.aring.ring.getZERO();
        int i = 0;
        for (GenPolynomial<GcdRingElem> genPolynomial : this.powers) {
            GcdRingElem c;
            if ((c = (GcdRingElem)coeffs.get(i++)).isZERO()) continue;
            pol = pol.sum(genPolynomial.multiply(c));
        }
        return new AlgebraicNumber<C>(this.aring, pol);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

