/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.NotInvertibleException;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AlgebraicNumberTest
extends TestCase {
    AlgebraicNumberRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    AlgebraicNumber<BigRational> a;
    AlgebraicNumber<BigRational> b;
    AlgebraicNumber<BigRational> c;
    AlgebraicNumber<BigRational> d;
    AlgebraicNumber<BigRational> e;
    int rl = 1;
    int kl = 10;
    int ll;
    int el = this.ll = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)AlgebraicNumberTest.suite());
    }

    public AlgebraicNumberTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AlgebraicNumberTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational bi = new BigRational(1L);
        bi.setNoDuplicatesIterator();
        this.mfac = new GenPolynomialRing<BigRational>(bi, this.rl);
        GenPolynomial<BigRational> mo = this.mfac.random(this.kl, this.ll, 7, this.q);
        while (mo.isConstant()) {
            mo = this.mfac.random(this.kl, this.ll, 5, this.q);
        }
        this.fac = new AlgebraicNumberRing<BigRational>(mo.monic());
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        AlgebraicNumberTest.assertTrue((String)"length( c ) = 1", (this.c.getVal().length() == 1 ? 1 : 0) != 0);
        AlgebraicNumberTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        AlgebraicNumberTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        AlgebraicNumberTest.assertTrue((String)"length( d ) = 0", (this.d.getVal().length() == 0 ? 1 : 0) != 0);
        AlgebraicNumberTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        AlgebraicNumberTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.el);
            if (!this.a.isZERO() && !this.a.isONE()) {
                AlgebraicNumberTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.getVal().length() >= 0 ? 1 : 0) != 0);
                AlgebraicNumberTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                AlgebraicNumberTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.c.subtract(this.b);
        AlgebraicNumberTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.b.sum((BigRational)((Object)this.a));
        AlgebraicNumberTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((BigRational)((Object)this.a.sum((BigRational)((Object)this.b))));
        this.e = this.c.sum((BigRational)((Object)this.a)).sum(this.b);
        AlgebraicNumberTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((BigRational)this.fac.getZERO());
        this.d = this.a.subtract((AlgebraicNumber<BigRational>)this.fac.getZERO());
        AlgebraicNumberTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((AlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((AlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        AlgebraicNumberTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        AlgebraicNumberTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        AlgebraicNumberTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        AlgebraicNumberTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        AlgebraicNumberTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        AlgebraicNumberTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        AlgebraicNumberTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        AlgebraicNumberTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        AlgebraicNumberTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        AlgebraicNumberTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((AlgebraicNumber)this.fac.getONE()).multiply(this.a);
        AlgebraicNumberTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply((BigRational)((Object)this.a));
        AlgebraicNumberTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((AlgebraicNumber)this.fac.getZERO()).inverse();
        }
        catch (NotInvertibleException expected) {
            return;
        }
        AlgebraicNumberTest.fail((String)"0 invertible");
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).sum((AlgebraicNumber<BigRational>)this.a.multiply((BigRational)((Object)this.c)));
        AlgebraicNumberTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testEnumerator() {
        long s = 0L;
        long t = 0L;
        HashSet<AlgebraicNumber<BigRational>> elems = new HashSet<AlgebraicNumber<BigRational>>(49);
        for (AlgebraicNumber<BigRational> algebraicNumber : this.fac) {
            ++t;
            if (elems.contains(algebraicNumber)) {
                ++s;
            } else {
                elems.add(algebraicNumber);
            }
            if (t >= 100L) break;
        }
        AlgebraicNumberTest.assertTrue((String)("#elems " + t + ", t = " + elems.size()), (t == (long)elems.size() ? 1 : 0) != 0);
        AlgebraicNumberTest.assertTrue((String)("#elems " + t + ", t = " + elems.size()), (s == 0L ? 1 : 0) != 0);
    }
}

