/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class ComplToAlgeb<C extends GcdRingElem<C>>
implements UnaryFunctor<Complex<C>, AlgebraicNumber<C>> {
    protected final AlgebraicNumberRing<C> afac;
    protected final AlgebraicNumber<C> I;

    public ComplToAlgeb(AlgebraicNumberRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.afac = fac;
        this.I = this.afac.getGenerator();
    }

    @Override
    public AlgebraicNumber<C> eval(Complex<C> c) {
        if (c == null || c.isZERO()) {
            return this.afac.getZERO();
        }
        if (c.isONE()) {
            return this.afac.getONE();
        }
        if (c.isIMAG()) {
            return this.I;
        }
        return this.I.multiply((GcdRingElem)c.getIm()).sum((GcdRingElem)c.getRe());
    }
}

