/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.ComplexRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.StarRingElem;
import org.apache.log4j.Logger;

public class Complex<C extends RingElem<C>>
implements StarRingElem<Complex<C>>,
GcdRingElem<Complex<C>> {
    private static final Logger logger = Logger.getLogger(Complex.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final ComplexRing<C> ring;
    protected final C re;
    protected final C im;

    public Complex(ComplexRing<C> ring, C r, C i) {
        this.ring = ring;
        this.re = r;
        this.im = i;
    }

    public Complex(ComplexRing<C> ring, C r) {
        this((ComplexRing<RingElem>)ring, (RingElem)r, (RingElem)ring.ring.getZERO());
    }

    public Complex(ComplexRing<C> ring, long r) {
        this(ring, (RingElem)ring.ring.fromInteger(r));
    }

    public Complex(ComplexRing<C> ring) {
        this(ring, (RingElem)ring.ring.getZERO());
    }

    public Complex(ComplexRing<C> ring, String s) throws NumberFormatException {
        this.ring = ring;
        if (s == null || s.length() == 0) {
            this.re = (RingElem)ring.ring.getZERO();
            this.im = (RingElem)ring.ring.getZERO();
            return;
        }
        int i = (s = s.trim()).indexOf("i");
        if (i < 0) {
            this.re = (RingElem)ring.ring.parse(s);
            this.im = (RingElem)ring.ring.getZERO();
            return;
        }
        String sr = "";
        if (i > 0) {
            sr = s.substring(0, i);
        }
        String si = "";
        if (i < s.length()) {
            si = s.substring(i + 1, s.length());
        }
        this.re = (RingElem)ring.ring.parse(sr.trim());
        this.im = (RingElem)ring.ring.parse(si.trim());
    }

    @Override
    public ComplexRing<C> factory() {
        return this.ring;
    }

    public C getRe() {
        return this.re;
    }

    public C getIm() {
        return this.im;
    }

    public Complex<C> clone() {
        return new Complex<C>(this.ring, this.re, this.im);
    }

    public String toString() {
        String s = this.re.toString();
        if (this.im.isZERO()) {
            return s;
        }
        s = String.valueOf(s) + "i" + this.im;
        return s;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        if (this.im.isZERO()) {
            s.append(this.re.toScript());
        } else {
            s.append("");
            if (!this.re.isZERO()) {
                s.append(this.re.toScript());
                s.append(" + ");
            }
            if (this.im.isONE()) {
                s.append("I");
            } else {
                s.append(this.im.toScript()).append(" * I");
            }
            s.append("");
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.ring.toScript();
    }

    @Override
    public boolean isZERO() {
        return this.re.isZERO() && this.im.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.re.isONE() && this.im.isZERO();
    }

    public boolean isIMAG() {
        return this.re.isZERO() && this.im.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        return ((Complex)this.norm()).re.isUnit();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Complex)) {
            return false;
        }
        Complex bc = null;
        try {
            bc = (Complex)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (bc == null) {
            return false;
        }
        if (!this.ring.equals(bc.ring)) {
            return false;
        }
        return this.re.equals(bc.re) && this.im.equals(bc.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(Complex<C> b) {
        int s = this.re.compareTo(b.re);
        if (s != 0) {
            return s;
        }
        return this.im.compareTo(b.im);
    }

    @Override
    public int signum() {
        int s = this.re.signum();
        if (s != 0) {
            return s;
        }
        return this.im.signum();
    }

    @Override
    public Complex<C> sum(Complex<C> B) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.sum(B.re), (RingElem)this.im.sum(B.im));
    }

    @Override
    public Complex<C> subtract(Complex<C> B) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.subtract(B.re), (RingElem)this.im.subtract(B.im));
    }

    @Override
    public Complex<C> negate() {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.negate(), (RingElem)this.im.negate());
    }

    @Override
    public Complex<C> conjugate() {
        return new Complex<RingElem>((ComplexRing<RingElem>)this.ring, (RingElem)this.re, (RingElem)this.im.negate());
    }

    @Override
    public Complex<C> norm() {
        RingElem v = (RingElem)this.re.multiply(this.re);
        v = v.sum((RingElem)this.im.multiply(this.im));
        return new Complex<RingElem>(this.ring, v);
    }

    @Override
    public Complex<C> abs() {
        StarRingElem n = this.norm();
        logger.error((Object)"abs() square root missing");
        return n;
    }

    @Override
    public Complex<C> multiply(Complex<C> B) {
        return new Complex<RingElem>(this.ring, ((RingElem)this.re.multiply(B.re)).subtract((RingElem)this.im.multiply(B.im)), ((RingElem)this.re.multiply(B.im)).sum((RingElem)this.im.multiply(B.re)));
    }

    @Override
    public Complex<C> inverse() {
        RingElem a = (RingElem)((Complex)this.norm()).re.inverse();
        return new Complex<RingElem>(this.ring, this.re.multiply((RingElem)a), this.im.multiply((RingElem)((RingElem)a.negate())));
    }

    @Override
    public Complex<C> remainder(Complex<C> S) {
        if (this.ring.isField()) {
            return this.ring.getZERO();
        }
        return this.quotientRemainder(S)[1];
    }

    @Override
    public Complex<C> divide(Complex<C> B) {
        if (this.ring.isField()) {
            return this.multiply((Complex<C>)B.inverse());
        }
        return this.quotientRemainder(B)[0];
    }

    public Complex<C>[] quotientRemainder(Complex<C> S) {
        Complex[] ret = new Complex[2];
        C n = ((Complex)S.norm()).re;
        Complex<Object> Sp = this.multiply((Complex<C>)S.conjugate());
        RingElem qr = (RingElem)Sp.re.divide(n);
        RingElem rr = (RingElem)Sp.re.remainder(n);
        RingElem qi = (RingElem)Sp.im.divide(n);
        RingElem ri = (RingElem)Sp.im.remainder(n);
        RingElem rr1 = rr;
        RingElem ri1 = ri;
        if (rr.signum() < 0) {
            rr = (RingElem)rr.negate();
        }
        if (ri.signum() < 0) {
            ri = (RingElem)ri.negate();
        }
        RingElem one = (RingElem)n.factory().fromInteger(1L);
        if (rr.sum(rr).compareTo(n) > 0) {
            qr = rr1.signum() < 0 ? qr.subtract(one) : qr.sum(one);
        }
        if (ri.sum(ri).compareTo(n) > 0) {
            qi = ri1.signum() < 0 ? qi.subtract(one) : qi.sum(one);
        }
        Sp = new Complex<RingElem>(this.ring, qr, qi);
        Complex<Object> Rp = this.subtract(Sp.multiply(S));
        if (debug && n.compareTo(((Complex)Rp.norm()).re) < 0) {
            System.out.println("n = " + n);
            System.out.println("qr   = " + qr);
            System.out.println("qi   = " + qi);
            System.out.println("rr   = " + rr);
            System.out.println("ri   = " + ri);
            System.out.println("rr1  = " + rr1);
            System.out.println("ri1  = " + ri1);
            System.out.println("this = " + this);
            System.out.println("S    = " + S);
            System.out.println("Sp   = " + Sp);
            BigInteger tr = (BigInteger)this.re;
            BigInteger ti = (BigInteger)this.im;
            BigInteger sr = (BigInteger)S.re;
            BigInteger si = (BigInteger)S.im;
            BigComplex tc = new BigComplex(new BigRational(tr), new BigRational(ti));
            BigComplex sc = new BigComplex(new BigRational(sr), new BigRational(si));
            BigComplex qc = tc.divide(sc);
            System.out.println("qc   = " + qc);
            BigDecimal qrd = new BigDecimal(qc.getRe());
            BigDecimal qid = new BigDecimal(qc.getIm());
            System.out.println("qrd  = " + qrd);
            System.out.println("qid  = " + qid);
            throw new ArithmeticException("QR norm not decreasing " + Rp + ", " + Rp.norm());
        }
        ret[0] = Sp;
        ret[1] = Rp;
        return ret;
    }

    @Deprecated
    public Complex<C>[] divideAndRemainder(Complex<C> S) {
        return this.quotientRemainder(S);
    }

    @Override
    public Complex<C> gcd(Complex<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.ring.isField()) {
            return this.ring.getONE();
        }
        AbelianGroupElem<Complex<Complex<C>>> a = this;
        AbelianGroupElem<Complex<C>> b = S;
        if (((Complex)a).re.signum() < 0) {
            a = ((Complex)a).negate();
        }
        if (((Complex)b).re.signum() < 0) {
            b = ((Complex)b).negate();
        }
        while (!((Complex)b).isZERO()) {
            Complex<C>[] qr;
            if (debug) {
                logger.info((Object)("norm(b), a, b = " + ((Complex)b).norm() + ", " + a + ", " + b));
            }
            if ((qr = ((Complex)a).quotientRemainder((Complex<Complex<Complex<C>>>)b))[0].isZERO()) {
                System.out.println("a = " + a);
            }
            a = b;
            b = qr[1];
        }
        if (((Complex)a).re.signum() < 0) {
            a = ((Complex)a).negate();
        }
        return a;
    }

    public Complex<C>[] egcd(Complex<C> S) {
        Complex[] ret = new Complex[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.ring.isField()) {
            Complex<RingElem> half = new Complex<RingElem>(this.ring, ((RingElem)this.ring.ring.fromInteger(1L)).divide((RingElem)this.ring.ring.fromInteger(2L)));
            ret[0] = this.ring.getONE();
            ret[1] = ((Complex)this.inverse()).multiply(half);
            ret[2] = ((Complex)S.inverse()).multiply(half);
            return ret;
        }
        Complex<C> q = this;
        Complex<C> r = S;
        Element<C> c1 = this.ring.getONE();
        Complex<C> d1 = this.ring.getZERO();
        AbelianGroupElem c2 = this.ring.getZERO();
        Complex<C> d2 = this.ring.getONE();
        while (!r.isZERO()) {
            if (debug) {
                logger.info((Object)("norm(r), q, r = " + r.norm() + ", " + q + ", " + r));
            }
            Complex<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            Complex<C> x1 = ((Complex)c1).subtract(q.multiply(d1));
            Complex<C> x2 = ((Complex)c2).subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        if (q.re.signum() < 0) {
            q = q.negate();
            c1 = ((Complex)c1).negate();
            c2 = ((Complex)c2).negate();
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }
}

