/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ComplexGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigComplex> fac;
    GenPolynomial<BigComplex> a;
    GenPolynomial<BigComplex> b;
    GenPolynomial<BigComplex> c;
    GenPolynomial<BigComplex> d;
    GenPolynomial<BigComplex> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)ComplexGenPolynomialTest.suite());
    }

    public ComplexGenPolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ComplexGenPolynomialTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigComplex>(new BigComplex(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ComplexGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ComplexGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ComplexGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll);
            ComplexGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ComplexGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ComplexGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigComplex)((Object)this.b));
        this.d = this.c.subtract((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector u = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigComplex x = BigComplex.CRAND(this.kl);
        this.b = new GenPolynomial<BigComplex>(this.fac, x, u);
        this.c = this.a.sum((BigComplex)((Object)this.b));
        this.d = this.a.sum(x, u);
        ComplexGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigComplex)((Object)this.b));
        this.d = this.a.subtract(x, u);
        ComplexGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigComplex>(this.fac);
        this.b = new GenPolynomial<BigComplex>(this.fac, x, u);
        this.c = this.b.sum((BigComplex)((Object)this.a));
        this.d = this.a.sum(x, u);
        ComplexGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigComplex)((Object)this.b));
        this.d = this.a.subtract(x, u);
        ComplexGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigComplex)((Object)this.a));
        this.d = this.a.multiply((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigComplex)((Object)this.c));
        ComplexGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ComplexGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ComplexGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigComplex)((Object)this.b.multiply((BigComplex)((Object)this.c))));
        this.e = this.a.multiply((BigComplex)((Object)this.b)).multiply(this.c);
        ComplexGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ComplexGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigComplex x = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(x);
        ComplexGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigComplex y = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(y);
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigComplex>(this.fac, y);
        this.d = this.b.multiply((BigComplex)((Object)this.e));
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }
}

