/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVectorByte;
import edu.jas.poly.ExpVectorInteger;
import edu.jas.poly.ExpVectorLong;
import edu.jas.poly.ExpVectorShort;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AbelianGroupFactory;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public abstract class ExpVector
implements AbelianGroupElem<ExpVector> {
    protected int hash = 0;
    private static final Random random = new Random();
    public static final StorUnit storunit = StorUnit.LONG;

    public static ExpVector create(int n) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n);
            }
            case LONG: {
                return new ExpVectorLong(n);
            }
            case SHORT: {
                return new ExpVectorShort(n);
            }
            case BYTE: {
                return new ExpVectorByte(n);
            }
        }
        return new ExpVectorInteger(n);
    }

    public static ExpVector create(int n, int i, long e) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n, i, e);
            }
            case LONG: {
                return new ExpVectorLong(n, i, e);
            }
            case SHORT: {
                return new ExpVectorShort(n, i, e);
            }
            case BYTE: {
                return new ExpVectorByte(n, i, e);
            }
        }
        return new ExpVectorInteger(n, i, e);
    }

    public static ExpVector create(long[] v) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(v);
            }
            case LONG: {
                return new ExpVectorLong(v);
            }
            case SHORT: {
                return new ExpVectorShort(v);
            }
            case BYTE: {
                return new ExpVectorByte(v);
            }
        }
        return new ExpVectorInteger(v);
    }

    public static ExpVector create(String s) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(s);
            }
            case LONG: {
                return new ExpVectorLong(s);
            }
            case SHORT: {
                return new ExpVectorShort(s);
            }
            case BYTE: {
                return new ExpVectorByte(s);
            }
        }
        return new ExpVectorInteger(s);
    }

    public static ExpVector create(Collection<Long> v) {
        long[] w = new long[v.size()];
        int i = 0;
        for (Long k : v) {
            w[i++] = k;
        }
        return ExpVector.create(w);
    }

    @Override
    public AbelianGroupFactory<ExpVector> factory() {
        throw new UnsupportedOperationException("no factory implemented for ExpVector");
    }

    public boolean isFinite() {
        return true;
    }

    public abstract ExpVector clone();

    abstract long[] getVal();

    public abstract long getVal(int var1);

    protected abstract long setVal(int var1, long var2);

    public abstract int length();

    public abstract ExpVector extend(int var1, int var2, long var3);

    public abstract ExpVector extendLower(int var1, int var2, long var3);

    public abstract ExpVector contract(int var1, int var2);

    public abstract ExpVector reverse();

    public abstract ExpVector reverse(int var1);

    public abstract ExpVector combine(ExpVector var1);

    public String toString() {
        StringBuffer s = new StringBuffer("(");
        int i = 0;
        while (i < this.length()) {
            s.append(this.getVal(i));
            if (i < this.length() - 1) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    public String toString(String[] vars) {
        long vi;
        String s = "";
        int r = this.length();
        if (r != vars.length) {
            return this.toString();
        }
        if (r == 0) {
            return s;
        }
        int i = r - 1;
        while (i > 0) {
            vi = this.getVal(i);
            if (vi != 0L) {
                s = String.valueOf(s) + vars[r - 1 - i];
                if (vi != 1L) {
                    s = String.valueOf(s) + "^" + vi;
                }
                boolean pit = false;
                int j = i - 1;
                while (j >= 0) {
                    if (this.getVal(j) != 0L) {
                        pit = true;
                    }
                    --j;
                }
                if (pit) {
                    s = String.valueOf(s) + " * ";
                }
            }
            --i;
        }
        vi = this.getVal(0);
        if (vi != 0L) {
            s = String.valueOf(s) + vars[r - 1];
            if (vi != 1L) {
                s = String.valueOf(s) + "^" + vi;
            }
        }
        return s;
    }

    @Override
    public String toScript() {
        return this.toScript(this.stdVars());
    }

    public String toScript(String[] vars) {
        long vi;
        int r = this.length();
        if (r != vars.length) {
            return this.toString();
        }
        StringBuffer s = new StringBuffer();
        int i = r - 1;
        while (i > 0) {
            vi = this.getVal(i);
            if (vi != 0L) {
                s.append(vars[r - 1 - i]);
                if (vi != 1L) {
                    s.append("**" + vi);
                }
                boolean pit = false;
                int j = i - 1;
                while (j >= 0) {
                    if (this.getVal(j) != 0L) {
                        pit = true;
                    }
                    --j;
                }
                if (pit) {
                    s.append(" * ");
                }
            }
            --i;
        }
        vi = this.getVal(0);
        if (vi != 0L) {
            s.append(vars[r - 1]);
            if (vi != 1L) {
                s.append("**" + vi);
            }
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return "ExpVector()";
    }

    public String indexVarName(int idx, String ... vars) {
        return vars[this.length() - idx - 1];
    }

    public int varIndex(int idx) {
        return this.length() - idx - 1;
    }

    public int indexVar(String x, String ... vars) {
        int i = 0;
        while (i < this.length()) {
            if (x.equals(vars[i])) {
                return this.length() - i - 1;
            }
            ++i;
        }
        return -1;
    }

    public <C extends RingElem<C>> C evaluate(RingFactory<C> cf, List<C> a) {
        RingElem c = (RingElem)cf.getONE();
        int i = 0;
        while (i < this.length()) {
            long ei = this.getVal(i);
            if (ei != 0L) {
                RingElem ai = (RingElem)a.get(this.length() - 1 - i);
                if (ai.isZERO()) {
                    return (C)ai;
                }
                RingElem pi = Power.positivePower(ai, ei);
                c = c.multiply(pi);
            }
            ++i;
        }
        return (C)c;
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVector)) {
            return false;
        }
        ExpVector b = (ExpVector)B;
        int t = this.invLexCompareTo(b);
        return t == 0;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            int i = 0;
            while (i < this.length()) {
                this.hash <<= (int)(4L + this.getVal(i));
                ++i;
            }
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    @Override
    public boolean isZERO() {
        return this.signum() == 0;
    }

    public String[] stdVars() {
        return ExpVector.STDVARS("x", this.length());
    }

    public String[] stdVars(String prefix) {
        return ExpVector.STDVARS(prefix, this.length());
    }

    public static String[] STDVARS(int n) {
        return ExpVector.STDVARS("x", n);
    }

    public static String[] STDVARS(String prefix, int n) {
        String[] vars = new String[n];
        if (prefix == null || prefix.length() == 0) {
            prefix = "x";
        }
        int i = 0;
        while (i < n) {
            vars[i] = String.valueOf(prefix) + i;
            ++i;
        }
        return vars;
    }

    public static ExpVector EVABS(ExpVector U) {
        return U.abs();
    }

    @Override
    public abstract ExpVector abs();

    public static ExpVector EVNEG(ExpVector U) {
        return U.negate();
    }

    @Override
    public abstract ExpVector negate();

    public static ExpVector EVSUM(ExpVector U, ExpVector V) {
        return U.sum(V);
    }

    @Override
    public abstract ExpVector sum(ExpVector var1);

    public static ExpVector EVDIF(ExpVector U, ExpVector V) {
        return U.subtract(V);
    }

    @Override
    public abstract ExpVector subtract(ExpVector var1);

    public static ExpVector EVSU(ExpVector U, int i, long d) {
        return U.subst(i, d);
    }

    public ExpVector subst(int i, long d) {
        ExpVector V = this.clone();
        long e = V.setVal(i, d);
        return V;
    }

    public static ExpVector EVRAND(int r, long k, float q) {
        return ExpVector.EVRAND(r, k, q, random);
    }

    public static ExpVector EVRAND(int r, long k, float q, Random rnd) {
        long[] w = new long[r];
        int i = 0;
        while (i < w.length) {
            long e;
            float f = rnd.nextFloat();
            if (f > q) {
                e = 0L;
            } else {
                e = rnd.nextLong() % k;
                if (e < 0L) {
                    e = -e;
                }
            }
            w[i] = e;
            ++i;
        }
        return ExpVector.create(w);
    }

    public static ExpVector random(int r, long k, float q) {
        return ExpVector.EVRAND(r, k, q, random);
    }

    public static ExpVector random(int r, long k, float q, Random rnd) {
        return ExpVector.EVRAND(r, k, q, rnd);
    }

    public static int EVSIGN(ExpVector U) {
        return U.signum();
    }

    @Override
    public abstract int signum();

    public static long EVTDEG(ExpVector U) {
        return U.totalDeg();
    }

    public abstract long totalDeg();

    public static long EVMDEG(ExpVector U) {
        return U.maxDeg();
    }

    public abstract long maxDeg();

    public static long EVWDEG(long[][] w, ExpVector U) {
        return U.weightDeg(w);
    }

    public abstract long weightDeg(long[][] var1);

    public static ExpVector EVLCM(ExpVector U, ExpVector V) {
        return U.lcm(V);
    }

    public abstract ExpVector lcm(ExpVector var1);

    public static ExpVector EVGCD(ExpVector U, ExpVector V) {
        return U.gcd(V);
    }

    public abstract ExpVector gcd(ExpVector var1);

    public static int[] EVDOV(ExpVector U) {
        return U.dependencyOnVariables();
    }

    public abstract int[] dependencyOnVariables();

    public static boolean EVMT(ExpVector U, ExpVector V) {
        return U.multipleOf(V);
    }

    public abstract boolean multipleOf(ExpVector var1);

    public boolean divides(ExpVector V) {
        return V.multipleOf(this);
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVector U, ExpVector V) {
        return U.invLexCompareTo(V);
    }

    public abstract int invLexCompareTo(ExpVector var1);

    public static int EVILCP(ExpVector U, ExpVector V, int begin, int end) {
        return U.invLexCompareTo(V, begin, end);
    }

    public abstract int invLexCompareTo(ExpVector var1, int var2, int var3);

    public static int EVIGLC(ExpVector U, ExpVector V) {
        return U.invGradCompareTo(V);
    }

    public abstract int invGradCompareTo(ExpVector var1);

    public static int EVIGLC(ExpVector U, ExpVector V, int begin, int end) {
        return U.invGradCompareTo(V, begin, end);
    }

    public abstract int invGradCompareTo(ExpVector var1, int var2, int var3);

    public static int EVRILCP(ExpVector U, ExpVector V) {
        return U.revInvLexCompareTo(V);
    }

    public abstract int revInvLexCompareTo(ExpVector var1);

    public static int EVRILCP(ExpVector U, ExpVector V, int begin, int end) {
        return U.revInvLexCompareTo(V, begin, end);
    }

    public abstract int revInvLexCompareTo(ExpVector var1, int var2, int var3);

    public static int EVRIGLC(ExpVector U, ExpVector V) {
        return U.revInvGradCompareTo(V);
    }

    public abstract int revInvGradCompareTo(ExpVector var1);

    public static int EVRIGLC(ExpVector U, ExpVector V, int begin, int end) {
        return U.revInvGradCompareTo(V, begin, end);
    }

    public abstract int revInvGradCompareTo(ExpVector var1, int var2, int var3);

    public static int EVIWLC(long[][] w, ExpVector U, ExpVector V) {
        return U.invWeightCompareTo(w, V);
    }

    public abstract int invWeightCompareTo(long[][] var1, ExpVector var2);

    public static int EVIWLC(long[][] w, ExpVector U, ExpVector V, int begin, int end) {
        return U.invWeightCompareTo(w, V, begin, end);
    }

    public abstract int invWeightCompareTo(long[][] var1, ExpVector var2, int var3, int var4);

    public static enum StorUnit {
        LONG,
        INT,
        SHORT,
        BYTE;

    }
}

