/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.Vector;

public class ExpVectorInteger
extends ExpVector {
    final int[] val;
    public static long maxInt = 0x3FFFFFFFL;
    public static long minInt = -1073741824L;

    public ExpVectorInteger(int n) {
        this(new int[n]);
    }

    public ExpVectorInteger(int n, int i, int e) {
        this(n);
        this.val[i] = e;
    }

    public ExpVectorInteger(int n, int i, long e) {
        this(n);
        if (e >= maxInt || e <= minInt) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (int)e;
    }

    protected ExpVectorInteger(int[] v) {
        this.val = v;
    }

    public ExpVectorInteger(long[] v) {
        this(v.length);
        int i = 0;
        while (i < v.length) {
            if (v[i] >= maxInt || v[i] <= minInt) {
                throw new IllegalArgumentException("exponent to large: " + v[i]);
            }
            this.val[i] = (int)v[i];
            ++i;
        }
    }

    public ExpVectorInteger(String s) throws NumberFormatException {
        Vector<Integer> exps = new Vector<Integer>();
        s = s.trim();
        int b = s.indexOf(40);
        int e = s.indexOf(41, b + 1);
        if (b >= 0 && e >= 0) {
            int a;
            String teil;
            int k;
            ++b;
            while ((k = s.indexOf(44, b)) >= 0) {
                teil = s.substring(b, k);
                a = Integer.parseInt(teil);
                exps.add(new Integer(a));
                b = k + 1;
            }
            if (b <= e) {
                teil = s.substring(b, e);
                a = Integer.parseInt(teil);
                exps.add(new Integer(a));
            }
            int length = exps.size();
            this.val = new int[length];
            int j = 0;
            while (j < length) {
                this.val[j] = (Integer)exps.elementAt(j);
                ++j;
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorInteger clone() {
        int[] w = new int[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorInteger(w);
    }

    @Override
    long[] getVal() {
        long[] v = new long[this.val.length];
        int i = 0;
        while (i < this.val.length) {
            v[i] = this.val[i];
            ++i;
        }
        return v;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        int x = this.val[i];
        if (e >= maxInt || e <= minInt) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (int)e;
        this.hash = 0;
        return x;
    }

    protected int setVal(int i, int e) {
        int x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorInteger extend(int i, int j, long e) {
        int[] w = new int[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        if (e >= maxInt || e <= minInt) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        w[j] = (int)e;
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger extendLower(int i, int j, long e) {
        int[] w = new int[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = (int)e;
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        int[] w = new int[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger reverse() {
        int[] w = new int[this.val.length];
        int i = 0;
        while (i < this.val.length) {
            w[i] = this.val[this.val.length - 1 - i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger reverse(int j) {
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        int[] w = new int[this.val.length];
        int i = 0;
        while (i < j) {
            w[i] = this.val[j - 1 - i];
            ++i;
        }
        i = j;
        while (i < this.val.length) {
            w[i] = this.val[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorInteger Vi = (ExpVectorInteger)V;
        if (this.val.length == 0) {
            return Vi;
        }
        int[] w = new int[this.val.length + Vi.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vi.val, 0, w, this.val.length, Vi.val.length);
        return new ExpVectorInteger(w);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ":int";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorInteger)) {
            return false;
        }
        ExpVectorInteger b = (ExpVectorInteger)B;
        int t = this.invLexCompareTo(b);
        return t == 0;
    }

    @Override
    public ExpVectorInteger abs() {
        int[] u = this.val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = (long)u[i] >= 0L ? u[i] : -u[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger negate() {
        int[] u = this.val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = -u[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger sum(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = u[i] + v[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger subtract(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = u[i] - v[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger subst(int i, long d) {
        ExpVectorInteger V = this.clone();
        long e = V.setVal(i, d);
        return V;
    }

    public ExpVectorInteger subst(int i, int d) {
        ExpVectorInteger V = this.clone();
        long e = V.setVal(i, d);
        return V;
    }

    @Override
    public int signum() {
        int t = 0;
        int[] u = this.val;
        int i = 0;
        while (i < u.length) {
            if (u[i] < 0) {
                return -1;
            }
            if (u[i] > 0) {
                t = 1;
            }
            ++i;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        long t = 0L;
        int[] u = this.val;
        int i = 0;
        while (i < u.length) {
            t += (long)u[i];
            ++i;
        }
        return t;
    }

    @Override
    public long maxDeg() {
        long t = 0L;
        int[] u = this.val;
        int i = 0;
        while (i < u.length) {
            if ((long)u[i] > t) {
                t = u[i];
            }
            ++i;
        }
        return t;
    }

    @Override
    public long weightDeg(long[][] w) {
        if (w == null || w.length == 0) {
            return this.totalDeg();
        }
        long t = 0L;
        int[] u = this.val;
        int j = 0;
        while (j < w.length) {
            long[] wj = w[j];
            int i = 0;
            while (i < u.length) {
                t += wj[i] * (long)u[i];
                ++i;
            }
            ++j;
        }
        return t;
    }

    @Override
    public ExpVectorInteger lcm(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger gcd(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        int i = 0;
        while (i < u.length) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
            ++i;
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        int[] u = this.val;
        int l = 0;
        int i = 0;
        while (i < u.length) {
            if (u[i] > 0) {
                ++l;
            }
            ++i;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < u.length) {
            if (u[i2] > 0) {
                dep[j] = i2;
                ++j;
            }
            ++i2;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        boolean t = true;
        int i = 0;
        while (i < u.length) {
            if (u[i] < v[i]) {
                return false;
            }
            ++i;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = 0;
        while (i < u.length) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] < v[i]) {
                return -1;
            }
            ++i;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = begin;
        while (i < end) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] < v[i]) {
                return -1;
            }
            ++i;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = 0;
        while (i < u.length) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            ++i;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        int j = i;
        while (j < u.length) {
            up += (long)u[j];
            vp += (long)v[j];
            ++j;
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = begin;
        while (i < end) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            ++i;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        int j = i;
        while (j < end) {
            up += (long)u[j];
            vp += (long)v[j];
            ++j;
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = u.length - 1;
        while (i >= 0) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] < v[i]) {
                return -1;
            }
            --i;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = end - 1;
        while (i >= begin) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] < v[i]) {
                return -1;
            }
            --i;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = u.length - 1;
        while (i >= 0) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            --i;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        int j = i;
        while (j >= 0) {
            up += (long)u[j];
            vp += (long)v[j];
            --j;
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = end - 1;
        while (i >= begin) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            --i;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        int j = i;
        while (j >= begin) {
            up += (long)u[j];
            vp += (long)v[j];
            --j;
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = 0;
        while (i < u.length) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            ++i;
        }
        if (t == 0) {
            return t;
        }
        int k = 0;
        while (k < w.length) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            int j = i;
            while (j < u.length) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
                ++j;
            }
            if (up > vp) {
                return 1;
            }
            if (up < vp) {
                return -1;
            }
            ++k;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        int i = begin;
        while (i < end) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] < v[i]) {
                t = -1;
                break;
            }
            ++i;
        }
        if (t == 0) {
            return t;
        }
        int k = 0;
        while (k < w.length) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            int j = i;
            while (j < end) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
                ++j;
            }
            if (up > vp) {
                return 1;
            }
            if (up < vp) {
                return -1;
            }
            ++k;
        }
        return t;
    }
}

