/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExpVectorTest
extends TestCase {
    ExpVector a;
    ExpVector b;
    ExpVector c;
    ExpVector d;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExpVectorTest.suite());
    }

    public ExpVectorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExpVectorTest.class);
        return suite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        this.a = ExpVector.create(0);
        this.b = ExpVector.create(0);
        ExpVectorTest.assertEquals((String)"() = ()", (Object)this.a, (Object)this.b);
        ExpVectorTest.assertEquals((String)"length( () ) = 0", (int)this.a.length(), (int)0);
        ExpVectorTest.assertTrue((String)"isZERO( () )", (boolean)this.a.isZERO());
        this.a = ExpVector.create(10);
        this.b = ExpVector.create(10);
        ExpVectorTest.assertEquals((String)"10e = 10e", (Object)this.a, (Object)this.b);
        ExpVectorTest.assertEquals((String)"length( 10e ) = 10", (int)this.a.length(), (int)10);
        ExpVectorTest.assertTrue((String)"isZERO( ( 10e ) )", (boolean)this.a.isZERO());
        String s = "(0,0,0,0,0,0,0,0,0,0)";
        this.a = ExpVector.create(s);
        String t = this.a.toString().substring(0, s.length());
        ExpVectorTest.assertEquals((String)"stringConstr = toString", (String)s, (String)t);
        ExpVectorTest.assertTrue((String)"isZERO( ( 10e ) )", (boolean)this.a.isZERO());
    }

    public void testRandom() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        String s = this.a.toString();
        if (s.indexOf(":") >= 0) {
            s = s.substring(0, s.indexOf(":"));
        }
        this.b = ExpVector.create(s);
        ExpVectorTest.assertEquals((String)"a == b", (boolean)true, (boolean)this.a.equals(this.b));
        this.c = ExpVector.EVDIF(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a-b = 0", (boolean)this.c.isZERO());
    }

    public void testAddition() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVSUM(this.a, this.a);
        this.c = ExpVector.EVDIF(this.b, this.a);
        ExpVectorTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ExpVectorTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        boolean t = ExpVector.EVMT(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a | a+a", (boolean)t);
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = ExpVector.EVSUM(this.a, this.b);
        this.d = ExpVector.EVSUM(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
    }

    public void testLcm() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = ExpVector.EVLCM(this.a, this.b);
        this.d = ExpVector.EVLCM(this.b, this.a);
        ExpVectorTest.assertTrue((String)"lcm(a,b) = lcm(b,a)", (boolean)this.c.equals(this.d));
        ExpVectorTest.assertTrue((String)"a | lcm(a,b)", (boolean)ExpVector.EVMT(this.c, this.a));
        ExpVectorTest.assertTrue((String)"b | lcm(a,b)", (boolean)ExpVector.EVMT(this.c, this.b));
        this.d = ExpVector.EVDIF(this.c, this.a);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-a) >= 0", (ExpVector.EVSIGN(this.d) >= 0 ? 1 : 0) != 0);
        this.d = ExpVector.EVDIF(this.c, this.b);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-b) >= 0", (ExpVector.EVSIGN(this.d) >= 0 ? 1 : 0) != 0);
    }

    public void testTdeg() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
    }

    public void testWeightdeg() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) = 0", (ExpVector.EVWDEG(null, this.a) == 0L ? 1 : 0) != 0);
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertEquals((String)"tdeg(a) == wdeg(a)", (long)ExpVector.EVTDEG(this.a), (long)ExpVector.EVWDEG(w, this.a));
        ExpVectorTest.assertEquals((String)"tdeg(b) == wdeg(b)", (long)ExpVector.EVTDEG(this.b), (long)ExpVector.EVWDEG(w, this.b));
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        w = new long[][]{{10L, 1L, 3L, 9L, 100L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        w = new long[][]{{10L, 1L, 3L, 9L, 100L}, {1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
    }

    public void testDependency() {
        this.a = ExpVector.create(10, 5, 2L);
        int[] exp = new int[]{5};
        int[] dep = ExpVector.EVDOV(this.a);
        ExpVectorTest.assertTrue((String)"[5] = [5]", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(10, 3, 9L);
        exp = new int[]{3};
        dep = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[3] = [3]", (boolean)Arrays.equals(exp, dep));
        this.c = ExpVector.EVSUM(this.a, this.b);
        exp = new int[]{3, 5};
        dep = ExpVector.EVDOV(this.c);
        ExpVectorTest.assertTrue((String)("[3,5] = [3,5] " + Arrays.toString(exp) + "," + Arrays.toString(dep)), (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(10);
        exp = new int[]{};
        dep = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(0);
        exp = new int[]{};
        dep = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(1, 0, 1L);
        exp = new int[1];
        dep = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[0] = [0]", (boolean)Arrays.equals(exp, dep));
    }

    public void testRandom2() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.create("" + this.a);
        ExpVectorTest.assertEquals((String)"a == b", (boolean)true, (boolean)this.a.equals(this.b));
        this.c = this.b.subtract(this.a);
        ExpVectorTest.assertTrue((String)"a-b = 0", (boolean)this.c.isZERO());
    }

    public void testAddition2() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        ExpVectorTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ExpVectorTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        boolean t = this.b.multipleOf(this.a);
        ExpVectorTest.assertTrue((String)"a | a+a", (boolean)t);
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ExpVectorTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
    }

    public void testLcm2() {
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.lcm(this.b);
        this.d = this.b.lcm(this.a);
        ExpVectorTest.assertTrue((String)"lcm(a,b) = lcm(b,a)", (boolean)this.c.equals(this.d));
        ExpVectorTest.assertTrue((String)"a | lcm(a,b)", (boolean)this.c.multipleOf(this.a));
        ExpVectorTest.assertTrue((String)"b | lcm(a,b)", (boolean)this.c.multipleOf(this.b));
        this.d = this.c.subtract(this.a);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-a) >= 0", (this.d.signum() >= 0 ? 1 : 0) != 0);
        this.d = this.c.subtract(this.b);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-b) >= 0", (this.d.signum() >= 0 ? 1 : 0) != 0);
    }

    public void testTdeg2() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
    }

    public void testWeightdeg2() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) = 0", (ExpVector.EVWDEG(null, this.a) == 0L ? 1 : 0) != 0);
        float q = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertEquals((String)"tdeg(a) == wdeg(a)", (long)ExpVector.EVTDEG(this.a), (long)ExpVector.EVWDEG(w, this.a));
        ExpVectorTest.assertEquals((String)"tdeg(b) == wdeg(b)", (long)ExpVector.EVTDEG(this.b), (long)ExpVector.EVWDEG(w, this.b));
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        w = new long[][]{{10L, 1L, 3L, 9L, 100L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        w = new long[][]{{10L, 1L, 3L, 9L, 100L}, {1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(w, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(w, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(w, this.c) >= ExpVector.EVWDEG(w, this.b) ? 1 : 0) != 0);
    }

    public void testDependency2() {
        this.a = ExpVector.create(10, 5, 2L);
        int[] exp = new int[]{5};
        int[] dep = this.a.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[5] = [5]", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(10, 3, 9L);
        exp = new int[]{3};
        dep = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[3] = [3]", (boolean)Arrays.equals(exp, dep));
        this.c = this.a.sum(this.b);
        exp = new int[]{3, 5};
        dep = this.c.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)("[3,5] = [3,5] " + Arrays.toString(exp) + "," + Arrays.toString(dep)), (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(10);
        exp = new int[]{};
        dep = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(0);
        exp = new int[]{};
        dep = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(exp, dep));
        this.b = ExpVector.create(1, 0, 1L);
        exp = new int[1];
        dep = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[0] = [0]", (boolean)Arrays.equals(exp, dep));
    }

    public void testEvaluation() {
        float q = 0.2f;
        int rl = 5;
        this.a = ExpVector.EVRAND(rl, 10L, q);
        this.b = ExpVector.EVRAND(rl, 10L, q);
        BigInteger fv = new BigInteger(0L);
        ArrayList<BigInteger> v = new ArrayList<BigInteger>(this.a.length());
        int i = 0;
        while (i < this.a.length()) {
            v.add(fv.random(4));
            ++i;
        }
        BigInteger av = this.a.evaluate(fv, v);
        BigInteger bv = this.b.evaluate(fv, v);
        this.c = this.a.sum(this.b);
        BigInteger cv = this.c.evaluate(fv, v);
        BigInteger dv = av.multiply(bv);
        ExpVectorTest.assertEquals((String)"a(v)*b(v) = (a+b)(v) ", (Object)cv, (Object)dv);
        this.c = ExpVector.create(rl);
        cv = this.c.evaluate(fv, v);
        dv = fv.getONE();
        ExpVectorTest.assertEquals((String)"0(v) = 1 ", (Object)cv, (Object)dv);
        v.clear();
        int i2 = 0;
        while (i2 < this.a.length()) {
            v.add(fv.getZERO());
            ++i2;
        }
        cv = this.c.evaluate(fv, v);
        dv = fv.getONE();
        ExpVectorTest.assertEquals((String)"0(0) = 1 ", (Object)cv, (Object)dv);
        av = this.a.evaluate(fv, v);
        if (this.a.isZERO()) {
            dv = fv.getONE();
            ExpVectorTest.assertEquals((String)"0(0) = 1 ", (Object)av, (Object)dv);
        } else {
            dv = fv.getZERO();
            ExpVectorTest.assertEquals((String)"a(0) = 0 ", (Object)av, (Object)dv);
        }
    }
}

