/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GFGenPolynomialTest
extends TestCase {
    GenPolynomialRing<AlgebraicNumber<ModInteger>> fac;
    AlgebraicNumberRing<ModInteger> cfac;
    GenPolynomial<AlgebraicNumber<ModInteger>> a;
    GenPolynomial<AlgebraicNumber<ModInteger>> b;
    GenPolynomial<AlgebraicNumber<ModInteger>> c;
    GenPolynomial<AlgebraicNumber<ModInteger>> d;
    GenPolynomial<AlgebraicNumber<ModInteger>> e;
    int rl = 7;
    int kl = 10;
    int ll = 8;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)GFGenPolynomialTest.suite());
    }

    public GFGenPolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GFGenPolynomialTest.class);
        return suite;
    }

    protected long getPrime() {
        long prime = 2L;
        int i = 1;
        while (i < 60) {
            prime *= 2L;
            ++i;
        }
        return prime -= 93L;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        long prime = this.getPrime();
        ModIntegerRing r = new ModIntegerRing(prime);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(r, 1);
        Element modul = mfac.random(5);
        while (((GenPolynomial)modul).isZERO() || ((GenPolynomial)modul).isUnit() || ((GenPolynomial)modul).isConstant()) {
            modul = mfac.random(5);
        }
        this.cfac = new AlgebraicNumberRing(((GenPolynomial)modul).monic());
        this.fac = new GenPolynomialRing<ModInteger>(this.cfac, this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        GFGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        GFGenPolynomialTest.assertTrue((String)("isZERO( c )c" + this.c), (!this.c.isZERO() ? 1 : 0) != 0);
        GFGenPolynomialTest.assertTrue((String)("isONE( c ) " + this.c), (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        GFGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        GFGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        GFGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll + i);
            GFGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            GFGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            GFGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((AlgebraicNumber<ModInteger>)((Object)this.b));
        this.d = this.c.subtract((AlgebraicNumber<ModInteger>)((Object)this.b));
        GFGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector u = ExpVector.EVRAND(this.rl, this.el, this.q);
        Element x = this.cfac.random(this.kl);
        this.b = new GenPolynomial<Element>(this.fac, x, u);
        this.c = this.a.sum((AlgebraicNumber<ModInteger>)((Object)this.b));
        this.d = this.a.sum((AlgebraicNumber<ModInteger>)x, u);
        GFGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((AlgebraicNumber<ModInteger>)((Object)this.b));
        this.d = this.a.subtract((AlgebraicNumber<ModInteger>)x, u);
        GFGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<AlgebraicNumber<ModInteger>>(this.fac);
        this.b = new GenPolynomial<Element>(this.fac, x, u);
        this.c = this.b.sum((AlgebraicNumber<ModInteger>)((Object)this.a));
        this.d = this.a.sum((AlgebraicNumber<ModInteger>)x, u);
        GFGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((AlgebraicNumber<ModInteger>)((Object)this.b));
        this.d = this.a.subtract((AlgebraicNumber<ModInteger>)x, u);
        GFGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((AlgebraicNumber<ModInteger>)((Object)this.a.sum((AlgebraicNumber<ModInteger>)((Object)this.b))));
        this.e = this.c.sum((AlgebraicNumber<ModInteger>)((Object)this.a)).sum(this.b);
        GFGenPolynomialTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((AlgebraicNumber<ModInteger>)this.fac.getZERO());
        this.d = this.a.subtract((AlgebraicNumber<ModInteger>)this.fac.getZERO());
        GFGenPolynomialTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((GenPolynomial)this.fac.getZERO()).sum(this.a);
        this.d = ((GenPolynomial)this.fac.getZERO()).subtract(this.a.negate());
        GFGenPolynomialTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        MonoidElem y;
        this.a = this.fac.random(this.ll);
        GFGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        GFGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((AlgebraicNumber<ModInteger>)((Object)this.a));
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b));
        GFGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        GFGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((AlgebraicNumber<ModInteger>)((Object)this.c));
        GFGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        GFGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        GFGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b.multiply((AlgebraicNumber<ModInteger>)((Object)this.c))));
        this.e = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).multiply(this.c);
        GFGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        GFGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        AlgebraicNumber<ModInteger> z = this.a.leadingBaseCoefficient();
        if (z.isUnit()) {
            MonoidElem x = z.inverse();
            this.c = this.a.monic();
            this.d = this.a.multiply((AlgebraicNumber<ModInteger>)x);
            GFGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        }
        if ((y = this.b.leadingBaseCoefficient()).isUnit()) {
            y = y.inverse();
            this.c = this.b.monic();
            this.d = this.b.multiply((AlgebraicNumber<ModInteger>)y);
            GFGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
            this.e = new GenPolynomial<AlgebraicNumber<ModInteger>>(this.fac, (AlgebraicNumber<ModInteger>)y);
            this.d = this.b.multiply((AlgebraicNumber<ModInteger>)((Object)this.e));
            GFGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
            this.d = this.e.multiply((AlgebraicNumber<ModInteger>)((Object)this.b));
            GFGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b))*b", this.c, this.d);
        }
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b.sum((AlgebraicNumber<ModInteger>)((Object)this.c))));
        this.e = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).sum((GenPolynomial<AlgebraicNumber<ModInteger>>)this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.c)));
        GFGenPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testQuotRem1() {
        this.fac = new GenPolynomialRing<ModInteger>(this.cfac, 1);
        this.a = ((GenPolynomial)this.fac.random(this.ll)).monic();
        GFGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = ((GenPolynomial)this.fac.random(this.ll)).monic();
        GFGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        GenPolynomial<AlgebraicNumber<ModInteger>> h = this.a;
        MonoidElem g = ((GenPolynomial)this.fac.random(this.ll)).monic();
        GFGenPolynomialTest.assertTrue((String)"not isZERO( g )", (!g.isZERO() ? 1 : 0) != 0);
        g = this.fac.getONE();
        this.a = this.a.multiply((AlgebraicNumber<ModInteger>)g);
        this.b = this.b.multiply((AlgebraicNumber<ModInteger>)g);
        GenPolynomial<AlgebraicNumber<ModInteger>>[] qr = this.b.divideAndRemainder(this.a);
        this.c = qr[0];
        this.d = qr[1];
        this.e = this.c.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).sum(this.d);
        GFGenPolynomialTest.assertEquals((String)"b = q a + r", this.b, this.e);
        qr = this.a.divideAndRemainder(this.b);
        this.c = qr[0];
        this.d = qr[1];
        this.e = this.c.multiply((AlgebraicNumber<ModInteger>)((Object)this.b)).sum(this.d);
        GFGenPolynomialTest.assertEquals((String)"a = q b + r", this.a, this.e);
        this.c = this.a.gcd(this.b);
        GFGenPolynomialTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        GFGenPolynomialTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
        GFGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, g);
        GenPolynomial<AlgebraicNumber<ModInteger>>[] gst = this.a.egcd(this.b);
        this.c = gst[0];
        this.d = gst[1];
        this.e = gst[2];
        GFGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, g);
        GenPolynomial<RingElem<GenPolynomial<AlgebraicNumber<ModInteger>>>> x = this.a.multiply((AlgebraicNumber<ModInteger>)((Object)this.d)).sum((GenPolynomial<AlgebraicNumber<ModInteger>>)this.b.multiply((AlgebraicNumber<ModInteger>)((Object)this.e))).monic();
        GFGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s + b t", this.c, x);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        try {
            this.c = this.a.modInverse(this.b);
            x = this.c.multiply((AlgebraicNumber<ModInteger>)((Object)this.a)).remainder((GenPolynomial<GenPolynomial<AlgebraicNumber<ModInteger>>>)this.b).monic();
            GFGenPolynomialTest.assertTrue((String)"a invertible mod b", (boolean)x.isUnit());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

