/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenGcdPolynomialRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GenGcdPolynomial<C extends GcdRingElem<C>>
extends GenPolynomial<C> {
    public final GenGcdPolynomialRing<C> gring;
    private static final Logger logger = Logger.getLogger(GenGcdPolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    private GenGcdPolynomial(GenGcdPolynomialRing<C> r, TreeMap<ExpVector, C> t) {
        super(r, t);
        this.gring = r;
    }

    public GenGcdPolynomial(GenGcdPolynomialRing<C> r) {
        this(r, new TreeMap(r.tord.getDescendComparator()));
    }

    public GenGcdPolynomial(GenGcdPolynomialRing<C> r, C c, ExpVector e) {
        this(r);
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    protected GenGcdPolynomial(GenGcdPolynomialRing<C> r, SortedMap<ExpVector, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public GenGcdPolynomial<C> clone() {
        return new GenGcdPolynomial<C>(this.gring, this.val);
    }

    @Override
    public GenGcdPolynomial<C> sum(GenGcdPolynomial<C> S) {
        return new GenGcdPolynomial<C>(this.gring, super.sum(S).val);
    }

    @Override
    public GenGcdPolynomial<C> sum(C a, ExpVector e) {
        return new GenGcdPolynomial<C>(this.gring, super.sum(a, (ExpVector)e).val);
    }

    @Override
    public GenGcdPolynomial<C> subtract(GenGcdPolynomial<C> S) {
        return new GenGcdPolynomial<C>(this.gring, super.subtract(S).val);
    }

    @Override
    public GenGcdPolynomial<C> subtract(C a, ExpVector e) {
        return new GenGcdPolynomial<C>(this.gring, super.subtract(a, (ExpVector)e).val);
    }

    @Override
    public GenGcdPolynomial<C> negate() {
        return new GenGcdPolynomial<C>(this.gring, ((GenPolynomial)super.negate()).val);
    }

    @Override
    public GenGcdPolynomial<C> abs() {
        return new GenGcdPolynomial<C>(this.gring, ((GenPolynomial)super.abs()).val);
    }

    @Override
    public GenGcdPolynomial<C> multiply(GenGcdPolynomial<C> S) {
        return new GenGcdPolynomial<C>(this.gring, super.multiply(S).val);
    }

    @Override
    public GenGcdPolynomial<C> multiply(C s) {
        return new GenGcdPolynomial<C>(this.gring, super.multiply(s).val);
    }

    @Override
    public GenGcdPolynomial<C> monic() {
        return new GenGcdPolynomial<C>(this.gring, super.monic().val);
    }

    @Override
    public GenGcdPolynomial<C> multiply(C s, ExpVector e) {
        return new GenGcdPolynomial<C>(this.gring, super.multiply(s, (ExpVector)e).val);
    }

    @Override
    public GenGcdPolynomial<C> multiply(ExpVector e) {
        return new GenGcdPolynomial<C>(this.gring, super.multiply((ExpVector)e).val);
    }

    @Override
    public GenGcdPolynomial<C> multiply(Map.Entry<ExpVector, C> m) {
        return new GenGcdPolynomial<C>(this.gring, super.multiply(m).val);
    }

    @Override
    public GenPolynomial<C> divide(C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Object p = ((GenPolynomial)this.ring.getZERO()).clone();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry m : this.val.entrySet()) {
            ExpVector e = (ExpVector)m.getKey();
            GcdRingElem c1 = (GcdRingElem)m.getValue();
            GcdRingElem c = (GcdRingElem)c1.divide(s);
            GcdRingElem x = (GcdRingElem)c1.remainder(s);
            if (!x.isZERO()) {
                System.out.println("divide x = " + x);
                throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) {
                throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " no exact division: " + c1 + "/" + s);
            }
            pv.put(e, c);
        }
        return p;
    }

    @Override
    public GenPolynomial<C>[] quotientRemainder(GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        GcdRingElem c = (GcdRingElem)S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " lbcf not invertible " + c);
        }
        GcdRingElem ci = (GcdRingElem)c.inverse();
        assert (this.ring.nvar == S.ring.nvar);
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GcdRingElem> q = ((GenPolynomial)this.ring.getZERO()).clone();
        GenPolynomial<GenPolynomial<GcdRingElem>> r = this.clone();
        while (!r.isZERO()) {
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiply(ci);
            q = q.sum(a, f);
            GenPolynomial<GcdRingElem> h = S.multiply(a, f);
            r = r.subtract(h);
        }
        GenPolynomial[] ret = new GenPolynomial[]{q, r};
        return ret;
    }

    @Override
    @Deprecated
    public GenPolynomial<C>[] divideAndRemainder(GenPolynomial<C> S) {
        return this.quotientRemainder(S);
    }

    @Override
    public GenPolynomial<C> divide(GenPolynomial<C> S) {
        return this.quotientRemainder(S)[0];
    }

    @Override
    public GenPolynomial<C> remainder(GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        GcdRingElem c = (GcdRingElem)S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(String.valueOf(this.getClass().getName()) + " lbc not invertible " + c);
        }
        GcdRingElem ci = (GcdRingElem)c.inverse();
        assert (this.ring.nvar == S.ring.nvar);
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GcdRingElem>> r = this.clone();
        while (!r.isZERO()) {
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiply(ci);
            GenPolynomial<GcdRingElem> h = S.multiply(a, f);
            r = r.subtract(h);
        }
        return r;
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.ring.nvar != 1) {
            return this.gring.engine.gcd(this, S);
        }
        GenPolynomial q = this;
        GenPolynomial<C> r = S;
        while (!r.isZERO()) {
            GenPolynomial<C> x = ((GenPolynomial)q).remainder(r);
            q = r;
            r = x;
        }
        return ((GenPolynomial)q).monic();
    }

    @Override
    public GenPolynomial<C>[] egcd(GenPolynomial<C> S) {
        GenPolynomial[] ret = new GenPolynomial[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + " not univariate polynomials" + this.ring);
        }
        GenPolynomial q = this;
        GenPolynomial<C> r = S;
        Object c1 = ((GenPolynomial)this.ring.getONE()).clone();
        GenPolynomial<GenPolynomial<Object>> d1 = ((GenPolynomial)this.ring.getZERO()).clone();
        Object c2 = ((GenPolynomial)this.ring.getZERO()).clone();
        GenPolynomial<GenPolynomial<Object>> d2 = ((GenPolynomial)this.ring.getONE()).clone();
        while (!r.isZERO()) {
            GenPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenPolynomial<GenPolynomial<Object>> x1 = ((GenPolynomial)c1).subtract(q.multiply(d1));
            GenPolynomial<GenPolynomial<Object>> x2 = ((GenPolynomial)c2).subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        GcdRingElem g = (GcdRingElem)q.leadingBaseCoefficient();
        if (g.isUnit()) {
            GcdRingElem h = (GcdRingElem)g.inverse();
            q = q.multiply(h);
            c1 = ((GenPolynomial)c1).multiply(h);
            c2 = ((GenPolynomial)c2).multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    @Override
    public GenGcdPolynomial<C> inverse() {
        return new GenGcdPolynomial<C>(this.gring, ((GenPolynomial)super.inverse()).val);
    }

    @Override
    public GenGcdPolynomial<C> modInverse(GenGcdPolynomial<C> m) {
        return new GenGcdPolynomial<C>(this.gring, super.modInverse(m).val);
    }

    @Override
    public GenGcdPolynomial<C> extend(GenGcdPolynomialRing<C> pfac, int j, long k) {
        return new GenGcdPolynomial<C>(this.gring, super.extend(pfac, (int)j, (long)k).val);
    }

    @Override
    public Map<ExpVector, GenGcdPolynomial<C>> contract(GenGcdPolynomialRing<C> pfac) {
        GenGcdPolynomial<GcdRingElem> zero = new GenGcdPolynomial<GcdRingElem>(this.gring, ((GenPolynomial)pfac.getZERO()).val);
        TermOrder t = new TermOrder(2);
        TreeMap<ExpVector, GenGcdPolynomial<C>> B = new TreeMap<ExpVector, GenGcdPolynomial<C>>(t.getAscendComparator());
        if (this.isZERO()) {
            return B;
        }
        int i = this.ring.nvar - pfac.nvar;
        SortedMap A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            ExpVector f = e.contract(0, i);
            ExpVector g = e.contract(i, e.length() - i);
            GenGcdPolynomial<GcdRingElem> p = (GenGcdPolynomial<GcdRingElem>)B.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            B.put(f, p);
        }
        return B;
    }

    @Override
    public GenGcdPolynomial<C> reverse(GenGcdPolynomialRing<C> oring) {
        return new GenGcdPolynomial<C>(this.gring, super.reverse(oring).val);
    }
}

