/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import org.apache.log4j.Logger;

public class GenGcdPolynomialRing<C extends GcdRingElem<C>>
extends GenPolynomialRing<C> {
    private static final Logger logger = Logger.getLogger(GenGcdPolynomialRing.class);
    public final GreatestCommonDivisor<C> engine = new GreatestCommonDivisorSubres();

    public GenGcdPolynomialRing(RingFactory<C> cf, int n) {
        this(cf, n, new TermOrder(), null);
    }

    public GenGcdPolynomialRing(RingFactory<C> cf, int n, TermOrder t) {
        this(cf, n, t, null);
    }

    public GenGcdPolynomialRing(RingFactory<C> cf, int n, String[] v) {
        this(cf, n, new TermOrder(), v);
    }

    public GenGcdPolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        super(cf, n, t, v);
    }

    public GenGcdPolynomialRing(RingFactory<C> cf, GenPolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars());
    }

    @Override
    public GenGcdPolynomialRing<C> extend(int i) {
        String[] v = null;
        if (this.vars != null) {
            v = new String[this.vars.length + i];
            int k = 0;
            while (k < this.vars.length) {
                v[k] = this.vars[k];
                ++k;
            }
            k = 0;
            while (k < i) {
                v[this.vars.length + k] = "e" + (k + 1);
                ++k;
            }
        }
        TermOrder to = this.tord.extend(this.nvar, i);
        GenGcdPolynomialRing<C> pfac = new GenGcdPolynomialRing<C>(this.coFac, this.nvar + i, to, v);
        return pfac;
    }

    @Override
    public GenGcdPolynomialRing<C> contract(int i) {
        String[] v = null;
        if (this.vars != null) {
            v = new String[this.vars.length - i];
            int j = 0;
            while (j < this.vars.length - i) {
                v[j] = this.vars[j];
                ++j;
            }
        }
        TermOrder to = this.tord.contract(i, this.nvar - i);
        GenGcdPolynomialRing<C> pfac = new GenGcdPolynomialRing<C>(this.coFac, this.nvar - i, to, v);
        return pfac;
    }

    @Override
    public GenGcdPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public GenGcdPolynomialRing<C> reverse(boolean partial) {
        String[] v = null;
        if (this.vars != null) {
            int j;
            v = new String[this.vars.length];
            int k = this.tord.getSplit();
            if (partial && k < this.vars.length) {
                j = 0;
                while (j < k) {
                    v[this.vars.length - k + j] = this.vars[this.vars.length - 1 - j];
                    ++j;
                }
                j = 0;
                while (j < this.vars.length - k) {
                    v[j] = this.vars[j];
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.vars.length) {
                    v[j] = this.vars[this.vars.length - 1 - j];
                    ++j;
                }
            }
        }
        TermOrder to = this.tord.reverse(partial);
        GenGcdPolynomialRing<C> pfac = new GenGcdPolynomialRing<C>(this.coFac, this.nvar, to, v);
        pfac.partial = partial;
        return pfac;
    }
}

