/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class GenPolynomialIterator<C extends RingElem<C>>
implements Iterator<GenPolynomial<C>> {
    final GenPolynomialRing<C> ring;
    final Iterator<List<Long>> eviter;
    final List<ExpVector> powers;
    final List<Iterable<C>> coeffiter;
    Iterator<List<C>> itercoeff;
    GenPolynomial<C> current;

    public GenPolynomialIterator(GenPolynomialRing<C> fac) {
        this.ring = fac;
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        ArrayList<Iterable<LongIterable>> tlist = new ArrayList<Iterable<LongIterable>>(this.ring.nvar);
        int i = 0;
        while (i < this.ring.nvar) {
            tlist.add(li);
            ++i;
        }
        CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
        this.eviter = ei.iterator();
        RingFactory cf = this.ring.coFac;
        this.coeffiter = new ArrayList<Iterable<C>>();
        if (!(cf instanceof Iterable) || !cf.isFinite()) {
            throw new IllegalArgumentException("only for finite iterable coefficients implemented");
        }
        Iterable cfi = (Iterable)((Object)cf);
        this.coeffiter.add(cfi);
        CartesianProduct tuples = new CartesianProduct(this.coeffiter);
        this.itercoeff = tuples.iterator();
        this.powers = new ArrayList<ExpVector>();
        ExpVector e = ExpVector.create((Collection<Long>)this.eviter.next());
        this.powers.add(e);
        List<C> c = this.itercoeff.next();
        this.current = new GenPolynomial<RingElem>(this.ring, (RingElem)c.get(0), e);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public synchronized GenPolynomial<C> next() {
        GenPolynomial<C> res = this.current;
        if (!this.itercoeff.hasNext()) {
            ExpVector e = ExpVector.create((Collection<Long>)this.eviter.next());
            this.powers.add(0, e);
            if (this.coeffiter.size() == 1) {
                this.coeffiter.add(this.coeffiter.get(0));
                Iterable<C> it = this.coeffiter.get(0);
                ArrayList<RingElem> elms = new ArrayList<RingElem>();
                for (RingElem elm : it) {
                    elms.add(elm);
                }
                elms.remove(0);
                this.coeffiter.set(0, elms);
            } else {
                this.coeffiter.add(this.coeffiter.get(1));
            }
            CartesianProduct tuples = new CartesianProduct(this.coeffiter);
            this.itercoeff = tuples.iterator();
        }
        List<C> coeffs = this.itercoeff.next();
        Object pol = ((GenPolynomial)this.ring.getZERO()).clone();
        int i = 0;
        for (ExpVector f : this.powers) {
            RingElem c;
            if ((c = (RingElem)coeffs.get(i++)).isZERO()) continue;
            if (((GenPolynomial)pol).val.get(f) != null) {
                System.out.println("error f in pol = " + f + ", " + ((GenPolynomial)pol).getMap().get(f));
                throw new RuntimeException("error in iterator");
            }
            ((GenPolynomial)pol).doPutToMap(f, c);
        }
        this.current = pol;
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove elements");
    }
}

