/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class GenPolynomialMonomialIterator<C extends RingElem<C>>
implements Iterator<GenPolynomial<C>> {
    final GenPolynomialRing<C> ring;
    final Iterator<List> iter;
    GenPolynomial<C> current;

    public GenPolynomialMonomialIterator(GenPolynomialRing<C> fac) {
        Iterable cfi;
        this.ring = fac;
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        ArrayList<Iterable<LongIterable>> tlist = new ArrayList<Iterable<LongIterable>>(this.ring.nvar);
        int i = 0;
        while (i < this.ring.nvar) {
            tlist.add(li);
            ++i;
        }
        CartesianProductInfinite ei = new CartesianProductInfinite(tlist);
        Iterator eviter = ei.iterator();
        RingFactory cf = this.ring.coFac;
        if (!(cf instanceof Iterable) || cf.isFinite()) {
            throw new IllegalArgumentException("only for infinite iterable coefficients implemented");
        }
        Iterable coeffiter = cfi = (Iterable)((Object)cf);
        ArrayList<Iterable<Iterable>> eci = new ArrayList<Iterable<Iterable>>(2);
        eci.add(ei);
        eci.add(coeffiter);
        CartesianProductInfinite ecp = new CartesianProductInfinite(eci);
        this.iter = ecp.iterator();
        List ec = this.iter.next();
        List ecl = (List)ec.get(0);
        RingElem c = (RingElem)ec.get(1);
        ExpVector e = ExpVector.create(ecl);
        this.current = new GenPolynomial<RingElem>(this.ring, c, e);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public synchronized GenPolynomial<C> next() {
        GenPolynomial<C> res = this.current;
        List ec = this.iter.next();
        RingElem c = (RingElem)ec.get(1);
        while (c.isZERO()) {
            ec = this.iter.next();
            c = (RingElem)ec.get(1);
        }
        List ecl = (List)ec.get(0);
        ExpVector e = ExpVector.create(ecl);
        this.current = new GenPolynomial<RingElem>(this.ring, c, e);
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove elements");
    }
}

