/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.Multiply;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GenPolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 10;
    int ll = 7;
    int el = 4;
    float q = 0.5f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GenPolynomialTest.suite());
    }

    public GenPolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GenPolynomialTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigRational rf = new BigRational();
        BigRational r = rf.fromInteger(99L);
        r = rf.random(9);
        BigRational re = new BigRational(3L);
        GenPolynomialRing<BigRational> pf = new GenPolynomialRing<BigRational>(rf, 2);
        Element p = pf.getONE();
        p = pf.random(9);
        p = pf.getZERO();
        RingElem pe = new GenPolynomial<BigRational>(pf);
        GenPolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenPolynomial)p).equals(pe));
        GenPolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenPolynomial)p).equals(p));
        pe = (RingElem)pe.sum((BigRational)p);
        p = pf.random(9);
        p = ((GenPolynomial)p).subtract(p);
        GenPolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)((GenPolynomial)p).isZERO());
        GenPolynomialRing<BigRational> ppf = new GenPolynomialRing<BigRational>(pf, 3);
        Element pp = ppf.getONE();
        pp = ppf.random(2);
        pp = ppf.getZERO();
        RingElem ppe = new GenPolynomial<BigRational>(ppf);
        GenPolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)((GenPolynomial)pp).equals(ppe));
        GenPolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)((GenPolynomial)pp).equals(pp));
        ppe = (RingElem)ppe.sum((BigRational)pp);
        pp = ppf.random(2);
        pp = ((GenPolynomial)pp).subtract(pp);
        GenPolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)((GenPolynomial)pp).isZERO());
        GenPolynomialRing<BigRational> pppf = new GenPolynomialRing<BigRational>(ppf, 4);
        Element ppp = pppf.getONE();
        ppp = pppf.random(2);
        ppp = pppf.getZERO();
        RingElem pppe = new GenPolynomial<BigRational>(pppf);
        GenPolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)((GenPolynomial)ppp).equals(pppe));
        GenPolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)((GenPolynomial)ppp).equals(ppp));
        pppe = (RingElem)pppe.sum((BigRational)ppp);
        ppp = pppf.random(2);
        ppp = ((GenPolynomial)ppp).subtract(ppp);
        GenPolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)((GenPolynomial)ppp).isZERO());
    }

    public void testExtendContract() {
        BigRational cf = new BigRational(99L);
        GenPolynomialRing<BigRational> pf = new GenPolynomialRing<BigRational>(cf, this.rl);
        GenPolynomial<BigRational> a = pf.random(this.kl, this.ll, this.el, this.q);
        int k = this.rl;
        GenPolynomialRing<BigRational> pfe = pf.extend(k);
        GenPolynomialRing<BigRational> pfec = pfe.contract(k);
        GenPolynomialTest.assertEquals((String)"pf == pfec", pf, pfec);
        GenPolynomial<BigRational> ae = a.extend(pfe, 0, 0L);
        Map<ExpVector, GenPolynomial<BigRational>> m = ae.contract(pfec);
        ArrayList<GenPolynomial<BigRational>> ml = new ArrayList<GenPolynomial<BigRational>>(m.values());
        GenPolynomial aec = (GenPolynomial)ml.get(0);
        GenPolynomialTest.assertEquals((String)"a == aec", a, (Object)aec);
    }

    public void testReverse() {
        BigRational cf = new BigRational(99L);
        GenPolynomialRing<BigRational> pf = new GenPolynomialRing<BigRational>(cf, this.rl);
        GenPolynomial<BigRational> a = pf.random(this.kl, this.ll, this.el, this.q);
        int k = this.rl;
        GenPolynomialRing<BigRational> pfr = pf.reverse();
        GenPolynomialRing<BigRational> pfrr = pfr.reverse();
        GenPolynomialTest.assertEquals((String)"pf == pfrr", pf, pfrr);
        GenPolynomial<BigRational> ar = a.reverse(pfr);
        GenPolynomial<BigRational> arr = ar.reverse(pfrr);
        GenPolynomialTest.assertEquals((String)"a == arr", a, arr);
    }

    public void testAccessors() {
        BigRational rf = new BigRational();
        GenPolynomialRing<BigRational> pf = new GenPolynomialRing<BigRational>(rf, this.rl);
        Element p = pf.getONE();
        ExpVector e = ((GenPolynomial)p).leadingExpVector();
        BigRational c = (BigRational)((GenPolynomial)p).leadingBaseCoefficient();
        AbelianGroupElem<GenPolynomial<Object>> f = new GenPolynomial<BigRational>(pf, c, e);
        GenPolynomialTest.assertEquals((String)"1 == 1 ", (Object)p, f);
        GenPolynomial<GenPolynomial<BigRational>> r = ((GenPolynomial)p).reductum();
        GenPolynomialTest.assertTrue((String)"red(1) == 0 ", (boolean)r.isZERO());
        p = pf.getZERO();
        e = ((GenPolynomial)p).leadingExpVector();
        c = (BigRational)((GenPolynomial)p).leadingBaseCoefficient();
        f = new GenPolynomial<BigRational>(pf, c, e);
        GenPolynomialTest.assertEquals((String)"0 == 0 ", p, f);
        r = ((GenPolynomial)p).reductum();
        GenPolynomialTest.assertTrue((String)"red(0) == 0 ", (boolean)r.isZERO());
        p = pf.random(this.kl, 2 * this.ll, this.el, this.q);
        e = ((GenPolynomial)p).leadingExpVector();
        c = (BigRational)((GenPolynomial)p).leadingBaseCoefficient();
        r = ((GenPolynomial)p).reductum();
        f = new GenPolynomial<BigRational>(pf, c, e);
        f = r.sum((GenPolynomial<BigRational>)f);
        GenPolynomialTest.assertEquals((String)"p == lm(f)+red(f) ", p, f);
        Element g = p;
        f = pf.getZERO();
        while (!((GenPolynomial)g).isZERO()) {
            e = ((GenPolynomial)g).leadingExpVector();
            c = (BigRational)((GenPolynomial)g).leadingBaseCoefficient();
            r = ((GenPolynomial)g).reductum();
            f = ((GenPolynomial)f).sum((GenPolynomial<Object>)((Object)c), e);
            g = r;
        }
        GenPolynomialTest.assertEquals((String)"p == lm(f)+lm(red(f))+... ", p, f);
    }

    public void testIterators() {
        BigInteger rf = new BigInteger();
        GenPolynomialRing<BigInteger> pf = new GenPolynomialRing<BigInteger>(rf, this.rl);
        GenPolynomial<BigInteger> p = pf.random(this.kl, 2 * this.ll, this.el, this.q);
        for (Monomial<BigInteger> monomial : p) {
            GenPolynomialTest.assertFalse((String)"m.c == 0 ", (boolean)monomial.coefficient().isZERO());
            GenPolynomialTest.assertFalse((String)"m.e < (0) ", (monomial.exponent().signum() < 0 ? 1 : 0) != 0);
        }
        Iterator<ExpVector> iterator = p.exponentIterator();
        while (iterator.hasNext()) {
            ExpVector e = iterator.next();
            GenPolynomialTest.assertFalse((String)"e < (0) ", (e.signum() < 0 ? 1 : 0) != 0);
        }
        Iterator<BigInteger> ct = p.coefficientIterator();
        while (ct.hasNext()) {
            BigInteger i = ct.next();
            GenPolynomialTest.assertFalse((String)"i == 0 ", (boolean)i.isZERO());
        }
    }

    public void testMap() {
        BigInteger rf = new BigInteger();
        GenPolynomialRing<BigInteger> pf = new GenPolynomialRing<BigInteger>(rf, this.rl);
        GenPolynomial<BigInteger> p = pf.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigInteger> q = p.map(new Multiply<BigInteger>(rf.getONE()));
        GenPolynomialTest.assertEquals((String)"p == q ", p, q);
        q = p.map(new Multiply<BigInteger>(rf.getZERO()));
        GenPolynomialTest.assertTrue((String)"q == 0 ", (boolean)q.isZERO());
        q = p.map(new Multiply<BigInteger>(rf.getONE().negate()));
        GenPolynomialTest.assertEquals((String)"p == q ", (Object)p.negate(), q);
    }
}

