/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import edu.jas.vector.ModuleList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenPolynomialTokenizerTest
extends TestCase {
    RingFactory fac;
    GenPolynomialRing pfac;
    GenSolvablePolynomialRing spfac;
    GenPolynomialTokenizer parser;
    Reader source;

    public static void main(String[] args) {
        TestRunner.run((Test)GenPolynomialTokenizerTest.suite());
    }

    public GenPolynomialTokenizerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GenPolynomialTokenizerTest.class);
        return suite;
    }

    protected void setUp() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    protected void tearDown() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    public void testBigRational() {
        String exam = "Rat(x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigRational fac = new BigRational(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigRational>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testBigInteger() {
        String exam = "Int(x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigInteger fac = new BigInteger(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigInteger>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testModInteger() {
        String exam = "Mod 19 (x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        ModIntegerRing fac = new ModIntegerRing(19L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<ModInteger>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testBigComplex() {
        String exam = "Complex(x,y,z) L ( ( 1i0 ), ( 0i0 ), ( 3/4i2 - 6/8i2 ), ( 1i0 x + x^3 + 1i3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigComplex fac = new BigComplex(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigComplex>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testBigDecimal() {
        String exam = "D(x,y,z) L ( ( 1 ), ( 0 ), ( 0.25 * 0.25 - 0.25^2 ), ( 1 x + x^3 + 0.3333333333333333333333 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigDecimal fac = new BigDecimal(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigDecimal>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testBigQuaternion() {
        String exam = "Quat(x,y,z) L ( ( 1i0j0k0 ), ( 0i0j0k0 ), ( 3/4i2j1k3 - 6/8i2j1k3 ), ( 1 x + x^3 + 1i2j3k4 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigQuaternion fac = new BigQuaternion(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigQuaternion>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testSolvableBigRational() {
        String exam = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z -1 ) ) (  ( 1 ),  ( 0 ),  ( 3/4 - 6/8 ),  ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextSolvablePolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        BigRational fac = new BigRational(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == f.ring", (Object)this.spfac, f.ring);
        GenSolvablePolynomial a = f.castToSolvableList().get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(0) )", (boolean)a.isONE());
        GenSolvablePolynomial b = f.castToSolvableList().get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenSolvablePolynomial c = f.castToSolvableList().get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(2) )", (boolean)c.isZERO());
        GenSolvablePolynomial d = f.castToSolvableList().get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testSolvableModInteger() {
        String exam = "Mod 19 (x,y,z) L RelationTable (  ( z ), ( y ), ( y z -1 ) ) ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextSolvablePolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.list.size() == 4 ? 1 : 0) != 0);
        ModIntegerRing fac = new ModIntegerRing(19L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.spfac = new GenSolvablePolynomialRing<ModInteger>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == f.ring", (Object)this.spfac, f.ring);
        GenSolvablePolynomial a = f.castToSolvableList().get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(0) )", (boolean)a.isONE());
        GenSolvablePolynomial b = f.castToSolvableList().get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenSolvablePolynomial c = f.castToSolvableList().get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(2) )", (boolean)c.isZERO());
        GenSolvablePolynomial d = f.castToSolvableList().get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
    }

    public void testBigIntegerModule() {
        String exam = "Int(x,y,z) L (  (   ( 1 ),   ( 0 ),   ( 3 2 - 6 ),   ( 1 x + x^3 + 3 y z - x^3 )  ),  ( ( 1 ), ( 0 ) ) )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        ModuleList m = null;
        try {
            m = this.parser.nextSubModuleSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"m != null", (m.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m ) = 2", (m.list.size() == 2 ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m[0] ) = 4", (m.list.get(0).size() == 4 ? 1 : 0) != 0);
        BigInteger fac = new BigInteger(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigInteger>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == m.ring", (Object)this.pfac, m.ring);
        List rows = m.list;
        List f = rows.get(0);
        GenPolynomial a = f.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
        f = rows.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.size() == 4 ? 1 : 0) != 0);
        a = f.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        b = f.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        c = f.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        d = f.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(3) )", (boolean)d.isZERO());
    }

    public void testBigRationalSolvableModule() {
        String exam = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z -1 ) ) (  (   ( 1 ),   ( 0 ),   ( 3/4 - 6/8 ),   ( 1 x + x^3 + 1/3 y z - x^3 )  ),  ( ( x ), ( 1 ), ( 0 ) )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        ModuleList m = null;
        try {
            m = this.parser.nextSolvableSubModuleSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"m != null", (m.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m ) = 2", (m.list.size() == 2 ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m[0] ) = 4", (m.list.get(0).size() == 4 ? 1 : 0) != 0);
        BigRational fac = new BigRational(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == m.ring", (Object)this.spfac, m.ring);
        List rows = m.castToSolvableList();
        List f = rows.get(0);
        GenSolvablePolynomial a = f.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenSolvablePolynomial b = f.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenSolvablePolynomial c = f.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenSolvablePolynomial d = f.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
        f = rows.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (f.size() == 4 ? 1 : 0) != 0);
        a = f.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"!isONE( f.get(0) )", (!a.isONE() ? 1 : 0) != 0);
        b = f.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(1) )", (boolean)b.isONE());
        c = f.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        d = f.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(3) )", (boolean)d.isZERO());
    }

    public void removedTestAlgebraicNumber() {
        String exam = "AN[ (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 1 ), ( _i_ ), ( 0 ), ( _i^2_ + 1 ), ( 1 x + x^3 + _3 i_ y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        AlgebraicNumberRing fac = null;
        try {
            f = this.parser.nextPolynomialSet();
            fac = (AlgebraicNumberRing)f.ring.coFac;
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (f.list.size() == 5 ? 1 : 0) != 0);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isUnit());
        b = b.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isONE());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)d.isZERO());
        GenPolynomial e = f.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)e.length());
    }

    public void removedTestGaloisField() {
        String exam = "AN[ 19 (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 20 ), ( _i_ ), ( 0 ), ( _i^2_ + 20 ), ( 1 x + x^3 + _3 i_ y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        AlgebraicNumberRing fac = null;
        try {
            f = this.parser.nextPolynomialSet();
            fac = (AlgebraicNumberRing)f.ring.coFac;
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (f.list.size() == 5 ? 1 : 0) != 0);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isUnit());
        b = b.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isONE());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)d.isZERO());
        GenPolynomial e = f.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)e.length());
    }

    public void testAlgebraicNumberBrace() {
        String exam = "AN[ (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 1 ), ( { i } ), ( 0 ), ( { i^2 } + 1 ), ( 1 x + x^3 + { 3 i }^2  y z - x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        AlgebraicNumberRing fac = null;
        try {
            f = this.parser.nextPolynomialSet();
            fac = (AlgebraicNumberRing)f.ring.coFac;
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (f.list.size() == 5 ? 1 : 0) != 0);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isUnit());
        b = b.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isONE());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)d.isZERO());
        GenPolynomial e = f.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)e.length());
    }

    public void testGaloisFieldBrace() {
        String exam = "AN[ 19 (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 20 ), ( { i } ), ( 0 ), ( { i^2 } + 20 ), ( 1 x + x^3 + { 3 i }^3 y z + { -1 }^3 x^3 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        AlgebraicNumberRing fac = null;
        try {
            f = this.parser.nextPolynomialSet();
            fac = (AlgebraicNumberRing)f.ring.coFac;
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (f.list.size() == 5 ? 1 : 0) != 0);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isUnit());
        b = b.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)b.isONE());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)d.isZERO());
        GenPolynomial e = f.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)e.length());
    }

    public void testBigRationalGeneric() {
        String exam = "Rat(x,y,z) L ( ( 1^3 ), ( 0^3 ), ( { 3/4 }^2 - 6/8^2 ), ( { 1 }^2 x + x^3 + 1/3 y z - x^3 ), ( 1.0001 - 0.0001 + { 0.25 }**2 - 1/4^2 )  )";
        this.source = new StringReader(exam);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList f = null;
        try {
            f = this.parser.nextPolynomialSet();
        }
        catch (IOException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        catch (ClassCastException e) {
            GenPolynomialTokenizerTest.fail((String)("" + e));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (f.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (f.list.size() == 5 ? 1 : 0) != 0);
        BigRational fac = new BigRational(0L);
        TermOrder tord = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        int nvar = vars.length;
        this.pfac = new GenPolynomialRing<BigRational>(fac, nvar, tord, vars);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, f.ring);
        GenPolynomial a = f.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)a.isONE());
        GenPolynomial b = f.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)b.isZERO());
        GenPolynomial c = f.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)c.isZERO());
        GenPolynomial d = f.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)d.length());
        GenPolynomial e = f.list.get(4);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(4) )", (boolean)e.isONE());
    }
}

