/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class GenSolvablePolynomial<C extends RingElem<C>>
extends GenPolynomial<C> {
    public final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(GenSolvablePolynomial.class);
    private final boolean debug = false;

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> r, C c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    protected GenSolvablePolynomial(GenSolvablePolynomialRing<C> r, SortedMap<ExpVector, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public GenSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> clone() {
        return new GenSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(GenSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        ExpVector Z = this.ring.evzero;
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        GenPolynomial zero = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        Object one = this.ring.getONECoefficient();
        GenSolvablePolynomial C1 = null;
        GenSolvablePolynomial C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            RingElem a = (RingElem)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            int el1s = this.ring.nvar + 1 - el1;
            for (Map.Entry x : Bk) {
                RingElem b = (RingElem)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                GenSolvablePolynomial<GenSolvablePolynomial<C>> Cs = null;
                if (el1s <= fl1s) {
                    ExpVector g = e.sum(f);
                    Cs = (GenSolvablePolynomial)zero.sum(one, g);
                } else {
                    ExpVector e1 = e.subst(el1, 0L);
                    ExpVector e2 = Z.subst(el1, e.getVal(el1));
                    ExpVector f1 = f.subst(fl1, 0L);
                    ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                    TableRelation rel = this.ring.table.lookup(e2, f2);
                    Cs = rel.p;
                    if (rel.f != null) {
                        C2 = (GenSolvablePolynomial)zero.sum(one, rel.f);
                        Cs = Cs.multiply((GenSolvablePolynomial<C>)C2);
                        ExpVector e4 = rel.e == null ? e2 : e2.subtract(rel.e);
                        this.ring.table.update(e4, f2, Cs);
                    }
                    if (rel.e != null) {
                        C1 = (GenSolvablePolynomial)zero.sum(one, rel.e);
                        Cs = C1.multiply((C)Cs);
                        this.ring.table.update(e2, f2, Cs);
                    }
                    if (!f1.isZERO()) {
                        C2 = (GenSolvablePolynomial)zero.sum(one, f1);
                        Cs = Cs.multiply((GenSolvablePolynomial<C>)C2);
                    }
                    if (!e1.isZERO()) {
                        C1 = (GenSolvablePolynomial)zero.sum(one, e1);
                        Cs = C1.multiply((C)Cs);
                    }
                }
                RingElem c = a.multiply(b);
                Cs = Cs.multiply(c);
                Cp = (GenSolvablePolynomial)Cp.sum(Cs);
            }
        }
        return Cp;
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C b) {
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((GenSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            RingElem c = (RingElem)a.multiply(b);
            Cm.put(e, c);
        }
        return Cp;
    }

    @Override
    public GenSolvablePolynomial<C> multiply(ExpVector e) {
        GenSolvablePolynomial<C> Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (e == null || e.isZERO()) {
            return this;
        }
        Object b = this.ring.getONECoefficient();
        Cp = new GenSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply((C)Cp);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C b, ExpVector e) {
        GenSolvablePolynomial<C> Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        Cp = new GenSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply((C)Cp);
    }

    public GenSolvablePolynomial<C> multiplyLeft(C b, ExpVector e) {
        GenSolvablePolynomial<GenSolvablePolynomial> Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        Cp = new GenSolvablePolynomial<GenSolvablePolynomial>((GenSolvablePolynomialRing<GenSolvablePolynomial>)this.ring, (GenSolvablePolynomial)b, e);
        Cp = Cp.multiply(this);
        return Cp;
    }

    public GenSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        GenSolvablePolynomial<GenSolvablePolynomial> Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (e == null || e.isZERO()) {
            return this;
        }
        Object b = this.ring.getONECoefficient();
        Cp = new GenSolvablePolynomial<GenSolvablePolynomial>((GenSolvablePolynomialRing<GenSolvablePolynomial>)this.ring, (GenSolvablePolynomial)b, e);
        return Cp.multiply(this);
    }

    public GenSolvablePolynomial<C> multiplyLeft(C b) {
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((GenSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            RingElem c = b.multiply((RingElem)a);
            Cm.put(e, c);
        }
        return Cp;
    }

    public GenSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft((RingElem)m.getValue(), m.getKey());
    }
}

