/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenSolvablePolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 10;
    int ll = 7;
    int el = 4;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)GenSolvablePolynomialTest.suite());
    }

    public GenSolvablePolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GenSolvablePolynomialTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigRational rf = new BigRational();
        BigRational r = rf.fromInteger(99L);
        r = rf.random(9);
        BigRational re = new BigRational(3L);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(rf, 2);
        GenPolynomial p = pf.getONE();
        p = pf.random(9);
        p = pf.getZERO();
        RingElem pe = new GenSolvablePolynomial<BigRational>(pf);
        GenSolvablePolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)p.equals(pe));
        GenSolvablePolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)p.equals(p));
        pe = pe.sum((BigRational)((Object)p));
        p = pf.random(9);
        p = (GenSolvablePolynomial)p.subtract(p);
        GenSolvablePolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)p.isZERO());
        GenSolvablePolynomialRing<BigRational> ppf = new GenSolvablePolynomialRing<BigRational>(pf, 3);
        GenPolynomial pp = ppf.getONE();
        pp = ppf.random(2);
        pp = ppf.getZERO();
        RingElem ppe = new GenSolvablePolynomial<BigRational>(ppf);
        GenSolvablePolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)pp.equals(ppe));
        GenSolvablePolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)pp.equals(pp));
        ppe = ppe.sum((BigRational)((Object)pp));
        pp = ppf.random(2);
        pp = (GenSolvablePolynomial)pp.subtract(pp);
        GenSolvablePolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)pp.isZERO());
        GenSolvablePolynomialRing<BigRational> pppf = new GenSolvablePolynomialRing<BigRational>(ppf, 4);
        GenPolynomial ppp = pppf.getONE();
        ppp = pppf.random(2);
        ppp = pppf.getZERO();
        RingElem pppe = new GenSolvablePolynomial<BigRational>(pppf);
        GenSolvablePolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)ppp.equals(pppe));
        GenSolvablePolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)ppp.equals(ppp));
        pppe = pppe.sum((BigRational)((Object)ppp));
        ppp = pppf.random(2);
        ppp = (GenSolvablePolynomial)ppp.subtract(ppp);
        GenSolvablePolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)ppp.isZERO());
    }

    public void testExtendContract() {
        BigRational cf = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(cf, this.rl);
        GenPolynomial a = pf.random(this.kl, this.ll, this.el, this.q);
        int k = this.rl;
        GenPolynomialRing pfe = pf.extend(k);
        GenPolynomialRing pfec = ((GenSolvablePolynomialRing)pfe).contract(k);
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfec", pf, (Object)pfec);
        GenSolvablePolynomial ae = (GenSolvablePolynomial)a.extend(pfe, 0, 0L);
        Map m = ae.contract(pfec);
        ArrayList ml = new ArrayList(m.values());
        GenSolvablePolynomial aec = (GenSolvablePolynomial)ml.get(0);
        GenSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)a, (Object)aec);
    }

    public void testExtendContractWeyl() {
        BigRational cf = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(cf, this.rl);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(pf);
        wl.generate();
        GenPolynomial a = pf.random(this.kl, this.ll, this.el, this.q);
        int k = this.rl;
        GenPolynomialRing pfe = pf.extend(k);
        GenPolynomialRing pfec = ((GenSolvablePolynomialRing)pfe).contract(k);
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfec", pf, (Object)pfec);
        GenSolvablePolynomial ae = (GenSolvablePolynomial)a.extend(pfe, 0, 0L);
        Map m = ae.contract(pfec);
        ArrayList ml = new ArrayList(m.values());
        GenSolvablePolynomial aec = (GenSolvablePolynomial)ml.get(0);
        GenSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)a, (Object)aec);
    }

    public void testReverse() {
        BigRational cf = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(cf, this.rl);
        GenPolynomial a = pf.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialRing pfr = pf.reverse();
        GenPolynomialRing pfrr = ((GenSolvablePolynomialRing)pfr).reverse();
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfrr", pf, (Object)pfrr);
        GenSolvablePolynomial ar = (GenSolvablePolynomial)a.reverse(pfr);
        GenSolvablePolynomial arr = (GenSolvablePolynomial)ar.reverse(pfrr);
        GenSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)a, (Object)arr);
    }

    public void testReverseWeyl() {
        BigRational cf = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(cf, this.rl);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(pf);
        wl.generate();
        GenPolynomial a = pf.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialRing pfr = pf.reverse();
        GenPolynomialRing pfrr = ((GenSolvablePolynomialRing)pfr).reverse();
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfrr", pf, (Object)pfrr);
        GenSolvablePolynomial ar = (GenSolvablePolynomial)a.reverse(pfr);
        GenSolvablePolynomial arr = (GenSolvablePolynomial)ar.reverse(pfrr);
        GenSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)a, (Object)arr);
    }

    public void testRecursion() {
        BigRational rf = new BigRational();
        String[] vars = new String[]{"a", "b", "c", "d"};
        TermOrder to = new TermOrder(2);
        GenSolvablePolynomialRing<BigRational> pf = new GenSolvablePolynomialRing<BigRational>(rf, 4, to, vars);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(pf);
        wl.generate();
        GenPolynomial sp = pf.random(5);
        GenSolvablePolynomialRing<BigRational> rpf = new GenSolvablePolynomialRing<BigRational>(pf, 2);
        WeylRelations<BigRational> rwl = new WeylRelations<BigRational>(rpf);
        rwl.generate();
        GenPolynomial rsp = rpf.random(5);
    }
}

