/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Local;
import edu.jas.poly.LocalRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class LocalTest
extends TestCase {
    LocalRing<BigInteger> fac;
    GenPolynomialRing<BigRational> pfac;
    LocalRing<GenPolynomial<BigRational>> mfac;
    Local<BigInteger> a;
    Local<BigInteger> b;
    Local<BigInteger> c;
    Local<BigInteger> d;
    Local<BigInteger> e;
    Local<GenPolynomial<BigRational>> ap;
    Local<GenPolynomial<BigRational>> bp;
    Local<GenPolynomial<BigRational>> cp;
    Local<GenPolynomial<BigRational>> dp;
    Local<GenPolynomial<BigRational>> ep;
    int rl = 1;
    int kl = 13;
    int ll = 5;
    int el = 2;
    float q = 0.3f;
    int il = 2;
    long p = 0xFFFFFFFFFFFFFA3L;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)LocalTest.suite());
    }

    public LocalTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LocalTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        BigInteger cfac = new BigInteger(1L);
        this.fac = new LocalRing<BigInteger>(cfac, new BigInteger(this.p));
        this.pfac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        GenPolynomial<BigRational> mo = this.pfac.random(this.kl, this.ll, this.el, this.q);
        while (mo.isConstant()) {
            mo = this.pfac.random(this.kl, this.ll, this.el, this.q);
        }
        this.mfac = new LocalRing<GenPolynomial<BigRational>>(this.pfac, mo);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.fac = null;
        this.pfac = null;
        this.mfac = null;
    }

    public void testIntConstruction() {
        this.c = this.fac.getONE();
        LocalTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        LocalTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        LocalTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testPolyConstruction() {
        this.cp = this.mfac.getONE();
        LocalTest.assertTrue((String)"isZERO( cp )", (!this.cp.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"isONE( cp )", (boolean)this.cp.isONE());
        this.dp = this.mfac.getZERO();
        LocalTest.assertTrue((String)"isZERO( dp )", (boolean)this.dp.isZERO());
        LocalTest.assertTrue((String)"isONE( dp )", (!this.dp.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 4) {
            this.a = this.fac.random(this.kl * (i + 1));
            LocalTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            LocalTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testPolyRandom() {
        int i = 0;
        while (i < 7) {
            this.ap = this.mfac.random(this.kl + i);
            LocalTest.assertTrue((String)(" not isZERO( ap" + i + " )"), (!this.ap.isZERO() ? 1 : 0) != 0);
            LocalTest.assertTrue((String)(" not isONE( ap" + i + " )"), (!this.ap.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testIntAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        LocalTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        LocalTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        LocalTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Local<BigInteger>)this.fac.getZERO());
        this.d = this.a.subtract((Local<BigInteger>)this.fac.getZERO());
        LocalTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Local)this.fac.getZERO()).sum(this.a);
        this.d = ((Local)this.fac.getZERO()).subtract(this.a.negate());
        LocalTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testPolyAddition() {
        this.ap = this.mfac.random(this.kl);
        this.bp = this.mfac.random(this.kl);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.cp.subtract(this.bp);
        LocalTest.assertEquals((String)"a+b-b = a", this.ap, this.dp);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.bp.sum(this.ap);
        LocalTest.assertEquals((String)"a+b = b+a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.cp.sum(this.ap.sum(this.bp));
        this.ep = this.cp.sum(this.ap).sum(this.bp);
        LocalTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dp, this.ep);
        this.cp = this.ap.sum((Local<GenPolynomial<BigRational>>)this.mfac.getZERO());
        this.dp = this.ap.subtract((Local<GenPolynomial<BigRational>>)this.mfac.getZERO());
        LocalTest.assertEquals((String)"a+0 = a-0", this.cp, this.dp);
        this.cp = ((Local)this.mfac.getZERO()).sum(this.ap);
        this.dp = ((Local)this.mfac.getZERO()).subtract(this.ap.negate());
        LocalTest.assertEquals((String)"0+a = 0+(-a)", this.cp, this.dp);
    }

    public void testIntMultiplication() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        LocalTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        LocalTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        LocalTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        LocalTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        LocalTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        LocalTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        LocalTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Local<BigInteger>)this.fac.getONE());
        this.d = ((Local)this.fac.getONE()).multiply(this.a);
        LocalTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            LocalTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testPolyMultiplication() {
        this.ap = this.mfac.random(this.kl);
        this.bp = this.mfac.random(this.kl);
        if (this.ap.isZERO() || this.bp.isZERO()) {
            return;
        }
        LocalTest.assertTrue((String)"not isZERO( a )", (!this.ap.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( b )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.bp.multiply(this.ap);
        this.dp = this.ap.multiply(this.bp);
        LocalTest.assertTrue((String)"not isZERO( c )", (!this.cp.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( d )", (!this.dp.isZERO() ? 1 : 0) != 0);
        this.ep = this.dp.subtract(this.cp);
        LocalTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ep), (boolean)this.ep.isZERO());
        LocalTest.assertTrue((String)"a*b = b*a", (boolean)this.cp.equals(this.dp));
        LocalTest.assertEquals((String)"a*b = b*a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.ap.multiply(this.bp.multiply(this.cp));
        this.ep = this.ap.multiply(this.bp).multiply(this.cp);
        LocalTest.assertEquals((String)"a(bc) = (ab)c", this.dp, this.ep);
        LocalTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.dp.equals(this.ep));
        this.cp = this.ap.multiply((Local<GenPolynomial<BigRational>>)this.mfac.getONE());
        this.dp = ((Local)this.mfac.getONE()).multiply(this.ap);
        LocalTest.assertEquals((String)"a*1 = 1*a", this.cp, this.dp);
        if (this.ap.isUnit()) {
            this.cp = this.ap.inverse();
            this.dp = this.cp.multiply(this.ap);
            LocalTest.assertTrue((String)"a*1/a = 1", (boolean)this.dp.isONE());
        }
    }
}

