/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OrderedPolynomialList<C extends RingElem<C>>
extends PolynomialList<C> {
    public OrderedPolynomialList(GenPolynomialRing<C> r, List<GenPolynomial<C>> l) {
        super(r, OrderedPolynomialList.sort(r, l));
    }

    @Override
    public boolean equals(Object p) {
        if (!super.equals(p)) {
            return false;
        }
        OrderedPolynomialList pl = null;
        try {
            pl = (OrderedPolynomialList)p;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return pl != null;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> sort(GenPolynomialRing<C> r, List<GenPolynomial<C>> l) {
        if (l == null) {
            return l;
        }
        if (l.size() <= 1) {
            return l;
        }
        final Comparator<ExpVector> evc = r.tord.getAscendComparator();
        Comparator cmp = new Comparator<GenPolynomial<C>>(){

            @Override
            public int compare(GenPolynomial<C> p1, GenPolynomial<C> p2) {
                ExpVector e1 = p1.leadingExpVector();
                ExpVector e2 = p2.leadingExpVector();
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                if (e1.length() != e2.length()) {
                    if (e1.length() > e2.length()) {
                        return 1;
                    }
                    return -1;
                }
                return evc.compare(e1, e2);
            }
        };
        GenPolynomial[] s = null;
        try {
            s = new GenPolynomial[l.size()];
            int i = 0;
            for (GenPolynomial<C> p : l) {
                s[i++] = p;
            }
            Arrays.sort(s, cmp);
            return new ArrayList<GenPolynomial<C>>(Arrays.asList(s));
        }
        catch (ClassCastException ok) {
            System.out.println("Warning: polynomials not sorted");
            return l;
        }
    }
}

