/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgToPoly;
import edu.jas.poly.AlgebToCompl;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.CoeffToAlg;
import edu.jas.poly.CoeffToRecAlg;
import edu.jas.poly.CompRatToDec;
import edu.jas.poly.ComplToAlgeb;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.DistToRec;
import edu.jas.poly.EvalMain;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.FromIntegerPoly;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ImagPart;
import edu.jas.poly.ImagPartComplex;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyToAlg;
import edu.jas.poly.RatToCompl;
import edu.jas.poly.RatToDec;
import edu.jas.poly.RatToInt;
import edu.jas.poly.RatToIntFactor;
import edu.jas.poly.RatToIntPoly;
import edu.jas.poly.RealPart;
import edu.jas.poly.RealPartComplex;
import edu.jas.poly.RecToDist;
import edu.jas.poly.ToComplex;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ListUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PolyUtil {
    private static final Logger logger = Logger.getLogger(PolyUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        Object B = ((GenPolynomial)rfac.getZERO()).clone();
        if (A.isZERO()) {
            return B;
        }
        int i = rfac.nvar;
        GenPolynomial<RingElem> zero = rfac.getZEROCoefficient();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.contract(0, i);
            ExpVector g = e.contract(i, e.length() - i);
            GenPolynomial<RingElem> p = (GenPolynomial<RingElem>)Bv.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            Bv.put(f, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> distribute(GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> B) {
        Object C = ((GenPolynomial)dfac.getZERO()).clone();
        if (B.isZERO()) {
            return C;
        }
        SortedMap Cm = ((GenPolynomial)C).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : B.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> A = y.getValue();
            for (Map.Entry x : A.val.entrySet()) {
                ExpVector f = x.getKey();
                RingElem b = (RingElem)x.getValue();
                ExpVector g = e.combine(f);
                assert (Cm.get(g) != null);
                Cm.put(g, b);
            }
        }
        return C;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new DistToRec<C>(rfac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> distribute(GenPolynomialRing<C> dfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        return ListUtil.map(L, new RecToDist<C>(dfac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ModSymToInt());
    }

    public static <C extends RingElem<C> & Modular> List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromModularCoefficients(final GenPolynomialRing<edu.jas.arith.BigInteger> fac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<edu.jas.arith.BigInteger>>(){

            @Override
            public GenPolynomial<edu.jas.arith.BigInteger> eval(GenPolynomial<C> c) {
                return PolyUtil.integerFromModularCoefficients((GenPolynomialRing<edu.jas.arith.BigInteger>)fac, c);
            }
        });
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficientsPositive(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ModToInt());
    }

    public static GenPolynomial<edu.jas.arith.BigInteger> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<BigRational> A) {
        if (A == null || A.isZERO()) {
            return fac.getZERO();
        }
        BigInteger c = null;
        int s = 0;
        for (BigRational y : A.val.values()) {
            BigInteger x = y.denominator();
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            BigInteger d = c.gcd(x);
            c = c.multiply(x.divide(d));
        }
        if (s < 0) {
            c = c.negate();
        }
        return PolyUtil.map(fac, A, new RatToInt(c));
    }

    public static Object[] integerFromRationalCoefficientsFactor(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<BigRational> A) {
        Object[] result = new Object[3];
        if (A == null || A.isZERO()) {
            result[0] = BigInteger.ONE;
            result[1] = BigInteger.ZERO;
            result[2] = fac.getZERO();
            return result;
        }
        BigInteger gcd = null;
        BigInteger lcm = null;
        int sLCM = 0;
        int sGCD = 0;
        for (BigRational y : A.val.values()) {
            BigInteger numerator = y.numerator();
            BigInteger denominator = y.denominator();
            if (lcm == null) {
                lcm = denominator;
                sLCM = denominator.signum();
            } else {
                BigInteger d = lcm.gcd(denominator);
                lcm = lcm.multiply(denominator.divide(d));
            }
            if (gcd == null) {
                gcd = numerator;
                sGCD = numerator.signum();
                continue;
            }
            gcd = gcd.gcd(numerator);
        }
        if (sLCM < 0) {
            lcm = lcm.negate();
        }
        if (sGCD < 0) {
            gcd = gcd.negate();
        }
        result[0] = gcd;
        result[1] = lcm;
        result[2] = PolyUtil.map(fac, A, new RatToIntFactor(gcd, lcm));
        return result;
    }

    public static List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, List<GenPolynomial<BigRational>> L) {
        return ListUtil.map(L, new RatToIntPoly(fac));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> fromIntegerCoefficients(GenPolynomialRing<C> fac, GenPolynomial<edu.jas.arith.BigInteger> A) {
        return PolyUtil.map(fac, A, new FromInteger(fac.coFac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<C> fac, List<GenPolynomial<edu.jas.arith.BigInteger>> L) {
        return ListUtil.map(L, new FromIntegerPoly<C>(fac));
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<BigDecimal> decimalFromRational(GenPolynomialRing<BigDecimal> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new RatToDec());
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<Complex<BigDecimal>> complexDecimalFromRational(GenPolynomialRing<Complex<BigDecimal>> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new CompRatToDec(fac.coFac));
    }

    public static GenPolynomial<BigRational> realPart(GenPolynomialRing<BigRational> fac, GenPolynomial<BigComplex> A) {
        return PolyUtil.map(fac, A, new RealPart());
    }

    public static GenPolynomial<BigRational> imaginaryPart(GenPolynomialRing<BigRational> fac, GenPolynomial<BigComplex> A) {
        return PolyUtil.map(fac, A, new ImagPart());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> realPartFromComplex(GenPolynomialRing<C> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new RealPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> imaginaryPartFromComplex(GenPolynomialRing<C> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new ImagPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<Complex<C>> toComplex(GenPolynomialRing<Complex<C>> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ToComplex(fac.coFac));
    }

    public static GenPolynomial<BigComplex> complexFromRational(GenPolynomialRing<BigComplex> fac, GenPolynomial<BigRational> A) {
        return PolyUtil.map(fac, A, new RatToCompl());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<AlgebraicNumber<C>> A) {
        return PolyUtil.map(rfac, A, new AlgToPoly());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToAlg(afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int depth, GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToRecAlg(depth, afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new PolyToAlg(afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAlgebraic(GenPolynomialRing<Complex<C>> fac, GenPolynomial<AlgebraicNumber<C>> A) {
        ComplexRing cfac = (ComplexRing)fac.coFac;
        return PolyUtil.map(fac, A, new AlgebToCompl(cfac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> algebraicFromComplex(GenPolynomialRing<AlgebraicNumber<C>> fac, GenPolynomial<Complex<C>> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)fac.coFac;
        return PolyUtil.map(fac, A, new ComplToAlgeb(afac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<C> chineseRemainder(GenPolynomialRing<C> fac, GenPolynomial<C> A, C mi, GenPolynomial<C> B) {
        RingElem x;
        ModularRingFactory cfac = (ModularRingFactory)fac.coFac;
        Object S = ((GenPolynomial)fac.getZERO()).clone();
        Object Ap = A.clone();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        RingElem c = null;
        for (ExpVector e : bv.keySet()) {
            x = (RingElem)av.get(e);
            RingElem y = (RingElem)bv.get(e);
            if (x != null) {
                av.remove(e);
                c = cfac.chineseRemainder(x, mi, y);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = cfac.chineseRemainder((RingElem)A.ring.coFac.getZERO(), mi, y);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (ExpVector e : av.keySet()) {
            x = (RingElem)av.get(e);
            c = cfac.chineseRemainder(x, mi, (RingElem)B.ring.coFac.getZERO());
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> monic(GenPolynomial<GenPolynomial<C>> p) {
        if (p == null || p.isZERO()) {
            return p;
        }
        C lc = p.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return p;
        }
        RingElem lm = (RingElem)lc.inverse();
        GenPolynomial<RingElem> L = (GenPolynomial<RingElem>)p.ring.coFac.getONE();
        L = L.multiply(lm);
        return p.multiply((GenPolynomial<GenPolynomial<RingElem>>)L);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> monic(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.monic();
            }
        });
    }

    public static <C extends RingElem<C>> List<ExpVector> leadingExpVector(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, ExpVector>(){

            @Override
            public ExpVector eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.leadingExpVector();
            }
        });
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> extendCoefficients(GenPolynomialRing<GenPolynomial<C>> pfac, GenPolynomial<GenPolynomial<C>> A, int j, long k) {
        Object Cp = ((GenPolynomial)pfac.getZERO()).clone();
        if (A.isZERO()) {
            return Cp;
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        GenPolynomialRing acfac = (GenPolynomialRing)A.ring.coFac;
        int i = cfac.nvar - acfac.nvar;
        SortedMap CC = ((GenPolynomial)Cp).val;
        for (Map.Entry y : A.val.entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            GenPolynomial f = a.extend(cfac, j, k);
            CC.put(e, f);
        }
        return Cp;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> toRecursive(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        Object B = ((GenPolynomial)rfac.getZERO()).clone();
        if (A.isZERO()) {
            return B;
        }
        int i = rfac.nvar;
        GenPolynomial<C> zero = rfac.getZEROCoefficient();
        GenPolynomial one = rfac.getONECoefficient();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Monomial<C> m : A) {
            ExpVector e = m.e;
            Object a = m.c;
            GenPolynomial<C> p = one.multiply(a);
            Bv.put(e, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseRemainderPoly(GenPolynomial<C> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        Object h = ((GenPolynomial)P.ring.getZERO()).clone();
        SortedMap hm = ((GenPolynomial)h).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            RingElem a = (RingElem)m.getValue();
            C x = a.remainder(s);
            hm.put(f, x);
        }
        return h;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P.ring.getZERO();
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        while (!r.isZERO()) {
            GenPolynomial<Object> h;
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoDivide(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        int cfr_ignored_0 = S.ring.nvar;
        if (P.isZERO() || S.isONE()) {
            return P;
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        GenPolynomial q = ((GenPolynomial)S.ring.getZERO()).clone();
        while (!r.isZERO()) {
            GenPolynomial h;
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.sum(a, f);
                q = q.multiply(c);
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<C>[] basePseudoQuotientRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        int cfr_ignored_0 = S.ring.nvar;
        GenPolynomial[] ret = new GenPolynomial[]{null, null};
        if (P.isZERO() || S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        GenPolynomial q = ((GenPolynomial)S.ring.getZERO()).clone();
        while (!r.isZERO()) {
            GenPolynomial h;
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.sum(a, f);
                q = q.multiply(c);
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Object p = ((GenPolynomial)P.ring.getZERO()).clone();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            System.out.println("pu, c1 = " + c1);
            System.out.println("pu, s  = " + s);
            System.out.println("pu, c  = " + c);
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> baseRecursiveDivide(GenPolynomial<GenPolynomial<C>> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Object p = ((GenPolynomial)P.ring.getZERO()).clone();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.coefficientBasePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            System.out.println("pu, c1 = " + c1);
            System.out.println("pu, s  = " + s);
            System.out.println("pu, c  = " + c);
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P.ring.getZERO();
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        while (!r.isZERO()) {
            GenPolynomial<GenPolynomial<C>> h;
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = c;
            if (x.isZERO()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(String.valueOf(P.getClass().getName()) + " division by zero");
        }
        int cfr_ignored_0 = S.ring.nvar;
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P;
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> q = ((GenPolynomial)S.ring.getZERO()).clone();
        while (!r.isZERO()) {
            GenPolynomial<GenPolynomial<C>> h;
            ExpVector f = r.leadingExpVector();
            if (!f.multipleOf(e)) break;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = PolyUtil.basePseudoRemainder(a, c);
            if (x.isZERO()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.sum(a, f);
                q = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)c);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(" division by zero");
        }
        if (P.isZERO()) {
            return P;
        }
        Object p = ((GenPolynomial)P.ring.getZERO()).clone();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            ExpVector e = m.getKey();
            GenPolynomial<C> c1 = m.getValue();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (c.isZERO()) {
                System.out.println(" no exact division: " + c1 + "/" + s);
                continue;
            }
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> coefficientBasePseudoDivide(GenPolynomial<C> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(" division by zero");
        }
        if (P.isZERO()) {
            return P;
        }
        Object p = ((GenPolynomial)P.ring.getZERO()).clone();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector e = m.getKey();
            RingElem c1 = (RingElem)m.getValue();
            C c = c1.divide(s);
            if (c.isZERO()) {
                System.out.println(" no exact division: " + c1 + "/" + s);
                continue;
            }
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(P.getClass().getName()) + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        Object d = ((GenPolynomial)pfac.getZERO()).clone();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> P, int r) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (r < 0 || pfac.nvar <= r) {
            throw new IllegalArgumentException(String.valueOf(P.getClass().getName()) + " deriviative variable out of bound " + r);
        }
        int rp = pfac.nvar - 1 - r;
        RingFactory rf = pfac.coFac;
        Object d = ((GenPolynomial)pfac.getZERO()).clone();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(rp);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = f.subst(rp, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseIntegral(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(P.getClass().getName()) + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        Object d = ((GenPolynomial)pfac.getZERO()).clone();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            RingElem cf = (RingElem)rf.fromInteger(++fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.divide(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDeriviative(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(String.valueOf(P.getClass().getName()) + " only for univariate polynomials");
        }
        GenPolynomialRing pr = (GenPolynomialRing)pfac.coFac;
        RingFactory rf = pr.coFac;
        Object d = ((GenPolynomial)pfac.getZERO()).clone();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            GenPolynomial<RingElem> a = m.getValue();
            GenPolynomial<RingElem> x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static edu.jas.arith.BigInteger factorBound(ExpVector e) {
        BigInteger v;
        int n = 0;
        BigInteger p = BigInteger.ONE;
        if (e == null || e.isZERO()) {
            return edu.jas.arith.BigInteger.ONE;
        }
        int i = 0;
        while (i < e.length()) {
            if (e.getVal(i) > 0L) {
                n = (int)((long)n + (2L * e.getVal(i) - 1L));
                v = new BigInteger("" + (e.getVal(i) - 1L));
                p = p.multiply(v);
            }
            ++i;
        }
        n += p.bitCount() + 1;
        v = new BigInteger("2");
        v = v.shiftLeft(n /= 2);
        edu.jas.arith.BigInteger N2 = new edu.jas.arith.BigInteger(v);
        return N2;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMain(GenPolynomialRing<C> cfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, GenPolynomial<C>> val = A.getMap();
        GenPolynomial<Object> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (ExpVector e : val.keySet()) {
            el2 = e.getVal(0);
            if (B == null) {
                B = (GenPolynomial<C>)val.get(e);
            } else {
                long i = el2;
                while (i < el1) {
                    B = B.multiply((Object)a);
                    ++i;
                }
                B = B.sum((Object)((GenPolynomial)val.get(e)));
            }
            el1 = el2;
        }
        long i = 0L;
        while (i < el2) {
            B = B.multiply((Object)a);
            ++i;
        }
        return B;
    }

    public static <C extends RingElem<C>> C evaluateMain(RingFactory<C> cfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return (C)((RingElem)cfac.getZERO());
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, C> val = A.getMap();
        MonoidElem<RingElem> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (ExpVector e : val.keySet()) {
            el2 = e.getVal(0);
            if (B == null) {
                B = (RingElem)val.get(e);
            } else {
                long i = el2;
                while (i < el1) {
                    B = (RingElem)B.multiply(a);
                    ++i;
                }
                B = B.sum((RingElem)val.get(e));
            }
            el1 = el2;
        }
        long i = 0L;
        while (i < el2) {
            B = B.multiply(a);
            ++i;
        }
        return (C)B;
    }

    public static <C extends RingElem<C>> List<C> evaluateMain(RingFactory<C> cfac, List<GenPolynomial<C>> L, C a) {
        return ListUtil.map(L, new EvalMain<C>(cfac, a));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluate(GenPolynomialRing<C> cfac, GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomialRing<GenPolynomial<C>> nfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, C a) {
        if (rfac.nvar != 1) {
            throw new IllegalArgumentException("evaluate coefficient ring not univariate");
        }
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> Ap = A.contract(cfac);
        GenPolynomialRing rcf = (GenPolynomialRing)rfac.coFac;
        Object Ev = ((GenPolynomial)nfac.getZERO()).clone();
        SortedMap Evm = ((GenPolynomial)Ev).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : Ap.entrySet()) {
            ExpVector e = m.getKey();
            GenPolynomial<C> b = m.getValue();
            GenPolynomial<GenPolynomial<C>> c = PolyUtil.recursive(rfac, b);
            GenPolynomial<C> d = PolyUtil.evaluateMain(rcf, c, a);
            if (d == null || d.isZERO()) continue;
            Evm.put(e, d);
        }
        GenPolynomial<C> B = PolyUtil.distribute(dfac, Ev);
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirst(GenPolynomialRing<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return dfac.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> Ap = A.contract(cfac);
        Object B = ((GenPolynomial)dfac.getZERO()).clone();
        SortedMap Bm = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : Ap.entrySet()) {
            ExpVector e = m.getKey();
            GenPolynomial<C> b = m.getValue();
            Object d = PolyUtil.evaluateMain(cfac.coFac, b, a);
            if (d == null || d.isZERO()) continue;
            Bm.put(e, d);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirstRec(GenPolynomialRing<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return dfac.getZERO();
        }
        SortedMap<ExpVector, GenPolynomial<C>> Ap = A.getMap();
        Object B = ((GenPolynomial)dfac.getZERO()).clone();
        SortedMap Bm = ((GenPolynomial)B).val;
        for (Map.Entry m : Ap.entrySet()) {
            ExpVector e = (ExpVector)m.getKey();
            GenPolynomial b = (GenPolynomial)m.getValue();
            Object d = PolyUtil.evaluateMain(cfac.coFac, b, a);
            if (d == null || d.isZERO()) continue;
            Bm.put(e, d);
        }
        return B;
    }

    public static <C extends RingElem<C>> C evaluateAll(RingFactory<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, List<C> a) {
        if (A == null || A.isZERO()) {
            return (C)((RingElem)cfac.getZERO());
        }
        if (a == null || a.size() != dfac.nvar) {
            throw new IllegalArgumentException("evaluate tuple size not equal to number of variables");
        }
        if (dfac.nvar == 0) {
            return A.trailingBaseCoefficient();
        }
        if (dfac.nvar == 1) {
            return (C)PolyUtil.evaluateMain(cfac, A, (RingElem)a.get(0));
        }
        RingElem b = (RingElem)cfac.getZERO();
        GenPolynomial<Object> Ap = A;
        int k = 0;
        while (k < dfac.nvar - 1) {
            GenPolynomialRing<C> c1fac = new GenPolynomialRing<C>(cfac, 1);
            GenPolynomialRing<C> cnfac = new GenPolynomialRing<C>(cfac, dfac.nvar - 1 - k);
            RingElem ap = (RingElem)a.get(k);
            GenPolynomial<RingElem> Bp = PolyUtil.evaluateFirst(c1fac, cnfac, Ap, ap);
            if (Bp.isZERO()) {
                return (C)b;
            }
            Ap = Bp;
            ++k;
        }
        RingElem ap = (RingElem)a.get(dfac.nvar - 1);
        b = PolyUtil.evaluateMain(cfac, Ap, ap);
        return (C)b;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteMain(GenPolynomial<C> A, GenPolynomial<C> s) {
        return PolyUtil.substituteUnivariate(A, s);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteUnivariate(GenPolynomial<C> f, GenPolynomial<C> t) {
        if (f == null || t == null) {
            return null;
        }
        GenPolynomialRing fac = f.ring;
        if (fac.nvar > 1 || t.ring.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (f.isZERO() || f.isConstant()) {
            return f;
        }
        SortedMap<ExpVector, C> val = f.getMap();
        GenPolynomial<RingElem<GenPolynomial<RingElem>>> s = null;
        long el1 = -1L;
        long el2 = -1L;
        for (ExpVector e : val.keySet()) {
            el2 = e.getVal(0);
            if (s == null) {
                s = ((GenPolynomial)fac.getZERO()).sum((RingElem)val.get(e));
            } else {
                long i = el2;
                while (i < el1) {
                    s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
                    ++i;
                }
                s = s.sum((RingElem)val.get(e));
            }
            el1 = el2;
        }
        long i = 0L;
        while (i < el2) {
            s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
            ++i;
        }
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> seriesOfTaylor(GenPolynomial<C> f, C a) {
        if (f == null) {
            return null;
        }
        GenPolynomialRing fac = f.ring;
        if (fac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (f.isZERO() || f.isConstant()) {
            return f;
        }
        GenPolynomial s = fac.getZERO();
        Object fa = PolyUtil.evaluateMain(fac.coFac, f, a);
        s = s.sum(fa);
        long n = 1L;
        long i = 0L;
        GenPolynomial<C> g = PolyUtil.baseDeriviative(f);
        MonoidElem p = fac.getONE();
        while (!g.isZERO()) {
            fa = PolyUtil.evaluateMain(fac.coFac, g, a);
            GenPolynomial q = fac.univariate(0, i);
            q = q.multiply(fa);
            q = q.divide(fac.fromInteger(n *= ++i));
            s = s.sum(q);
            g = PolyUtil.baseDeriviative(g);
        }
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> interpolate(GenPolynomialRing<GenPolynomial<C>> fac, GenPolynomial<GenPolynomial<C>> A, GenPolynomial<C> M, C mi, GenPolynomial<C> B, C am) {
        GenPolynomial x;
        Object S = ((GenPolynomial)fac.getZERO()).clone();
        Object Ap = A.clone();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        GenPolynomialRing cfac = (GenPolynomialRing)fac.coFac;
        RingFactory bfac = cfac.coFac;
        GenPolynomial<RingElem> c = null;
        for (ExpVector e : bv.keySet()) {
            x = (GenPolynomial)av.get(e);
            RingElem y = (RingElem)bv.get(e);
            if (x != null) {
                av.remove(e);
                c = PolyUtil.interpolate(cfac, x, M, mi, y, am);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = PolyUtil.interpolate(cfac, cfac.getZERO(), M, mi, y, am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (ExpVector e : av.keySet()) {
            x = (GenPolynomial)av.get(e);
            c = PolyUtil.interpolate(cfac, x, M, mi, (RingElem)bfac.getZERO(), am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> interpolate(GenPolynomialRing<C> fac, GenPolynomial<C> A, GenPolynomial<C> M, C mi, C a, C am) {
        Object b = PolyUtil.evaluateMain(fac.coFac, A, am);
        RingElem d = (RingElem)a.subtract(b);
        if (d.isZERO()) {
            return A;
        }
        b = d.multiply(mi);
        GenPolynomial<GenPolynomial<C>> s = M.multiply(b);
        s = s.sum(A);
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> switchVariables(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenPolynomialRing rfac1 = P.ring;
        GenPolynomialRing cfac1 = (GenPolynomialRing)rfac1.coFac;
        GenPolynomialRing cfac2 = new GenPolynomialRing(cfac1.coFac, rfac1);
        AbelianGroupElem zero = cfac2.getZERO();
        GenPolynomialRing rfac2 = new GenPolynomialRing(cfac2, cfac1);
        GenPolynomial B = ((GenPolynomial)rfac2.getZERO()).clone();
        if (P.isZERO()) {
            return B;
        }
        for (Monomial<GenPolynomial<C>> monomial : P) {
            GenPolynomial cr = (GenPolynomial)monomial.c;
            for (Monomial mc : cr) {
                GenPolynomial c = ((GenPolynomial)zero).sum(mc.c, monomial.e);
                B = B.sum(c, mc.e);
            }
        }
        return B;
    }

    public static <C extends RingElem<C>> long coeffMaxDegree(GenPolynomial<GenPolynomial<C>> A) {
        if (A.isZERO()) {
            return 0L;
        }
        long deg = 0L;
        for (GenPolynomial<C> a : A.getMap().values()) {
            long d = a.degree();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public static <C extends RingElem<C>, D extends RingElem<D>> GenPolynomial<D> map(GenPolynomialRing<D> ring, GenPolynomial<C> p, UnaryFunctor<C, D> f) {
        Object n = ((GenPolynomial)ring.getZERO()).clone();
        SortedMap nv = ((GenPolynomial)n).val;
        for (Monomial<C> m : p) {
            RingElem c = (RingElem)f.eval(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<C>>> toProductGen(GenPolynomialRing<Product<C>> pfac, List<GenPolynomial<C>> L) {
        ArrayList<GenPolynomial<Product<C>>> list = new ArrayList<GenPolynomial<Product<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<C> a : L) {
            GenPolynomial<Product<C>> b = PolyUtil.toProductGen(pfac, a);
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<C>> toProductGen(GenPolynomialRing<Product<C>> pfac, GenPolynomial<C> A) {
        Object P = ((GenPolynomial)pfac.getZERO()).clone();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing rfac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            Product<GcdRingElem> p = PolyUtil.toProductGen(rfac, a);
            if (p == null || p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Product<C> toProductGen(ProductRing<C> pfac, C c) {
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>();
        int i = 0;
        while (i < pfac.length()) {
            RingFactory<C> rfac = pfac.getFactory(i);
            C u = rfac.copy(c);
            if (u != null && !u.isZERO()) {
                elem.put(i, u);
            }
            ++i;
        }
        return new Product<C>(pfac, elem);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> pfac, C c, ExpVector e) {
        TreeMap<Integer, GenPolynomial<C>> elem = new TreeMap<Integer, GenPolynomial<C>>();
        int i = 0;
        while (i < e.length()) {
            RingFactory<GenPolynomial<C>> rfac = pfac.getFactory(i);
            GenPolynomialRing fac = (GenPolynomialRing)rfac;
            long a = e.getVal(i);
            GenPolynomial<C> u = a == 0L ? fac.getONE() : fac.univariate(0, a);
            u = u.multiply(c);
            elem.put(i, u);
            ++i;
        }
        return new Product<GenPolynomial<C>>(pfac, elem);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> pfac, GenPolynomial<C> A) {
        Product<GenPolynomial<RingElem>> P = pfac.getZERO();
        if (A == null || A.isZERO()) {
            return P;
        }
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            Product<GenPolynomial<RingElem>> p = PolyUtil.toProduct(pfac, a, e);
            P = P.sum(p);
        }
        return P;
    }

    public static Product<ModInteger> toProduct(ProductRing<ModInteger> pfac, edu.jas.arith.BigInteger c) {
        TreeMap<Integer, ModInteger> elem = new TreeMap<Integer, ModInteger>();
        int i = 0;
        while (i < pfac.length()) {
            RingFactory<ModInteger> rfac = pfac.getFactory(i);
            ModIntegerRing fac = (ModIntegerRing)rfac;
            ModInteger u = fac.fromInteger(c.getVal());
            if (u != null && !u.isZERO()) {
                elem.put(i, u);
            }
            ++i;
        }
        return new Product<ModInteger>(pfac, elem);
    }

    public static GenPolynomial<Product<ModInteger>> toProduct(GenPolynomialRing<Product<ModInteger>> pfac, GenPolynomial<edu.jas.arith.BigInteger> A) {
        Object P = ((GenPolynomial)pfac.getZERO()).clone();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing fac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, edu.jas.arith.BigInteger> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            edu.jas.arith.BigInteger a = y.getValue();
            Product<ModInteger> p = PolyUtil.toProduct(fac, a);
            if (p == null || p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static List<GenPolynomial<Product<ModInteger>>> toProduct(GenPolynomialRing<Product<ModInteger>> pfac, List<GenPolynomial<edu.jas.arith.BigInteger>> L) {
        ArrayList<GenPolynomial<Product<ModInteger>>> list = new ArrayList<GenPolynomial<Product<ModInteger>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<edu.jas.arith.BigInteger> a : L) {
            GenPolynomial<Product<ModInteger>> b = PolyUtil.toProduct(pfac, a);
            list.add(b);
        }
        return list;
    }
}

