/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RatNumer;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)PolyUtilTest.suite());
    }

    public PolyUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PolyUtilTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    protected static java.math.BigInteger getPrime1() {
        long prime = 2L;
        int i = 1;
        while (i < 60) {
            prime *= 2L;
            ++i;
        }
        return new java.math.BigInteger("" + (prime -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long prime = 2L;
        int i = 1;
        while (i < 30) {
            prime *= 2L;
            ++i;
        }
        return new java.math.BigInteger("" + (prime -= 35L));
    }

    public void testConversion() {
        this.c = this.dfac.getONE();
        PolyUtilTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.cr = PolyUtil.recursive(this.rfac, this.c);
        this.a = PolyUtil.distribute(this.dfac, this.cr);
        PolyUtilTest.assertEquals((String)"c == dist(rec(c))", this.c, this.a);
        this.d = this.dfac.getZERO();
        PolyUtilTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        PolyUtilTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        this.dr = PolyUtil.recursive(this.rfac, this.d);
        this.b = PolyUtil.distribute(this.dfac, this.dr);
        PolyUtilTest.assertEquals((String)"d == dist(rec(d))", this.d, this.b);
    }

    public void testRandomConversion() {
        int i = 0;
        while (i < 7) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            this.cr = PolyUtil.recursive(this.rfac, this.c);
            this.a = PolyUtil.distribute(this.dfac, this.cr);
            PolyUtilTest.assertEquals((String)"c == dist(rec(c))", this.c, this.a);
            ++i;
        }
    }

    public void testRationalConversion() {
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        int i = 0;
        while (i < 3) {
            this.c = this.dfac.random(this.kl * (i + 9), this.ll * (i + 3), this.el + i, this.q).abs();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> ar = PolyUtil.fromIntegerCoefficients(rfac, this.c);
            GenPolynomial<BigRational> br = ar.monic();
            this.a = PolyUtil.integerFromRationalCoefficients(this.dfac, br);
            PolyUtilTest.assertEquals((String)"c == integer(rational(c))", this.c, this.a);
            ++i;
        }
    }

    public void testModularConversion() {
        ModIntegerRing pm = new ModIntegerRing(PolyUtilTest.getPrime1());
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, this.rl, this.to);
        int i = 0;
        while (i < 3) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll * (i + 1), this.el + i, this.q).abs();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<ModInteger> ar = PolyUtil.fromIntegerCoefficients(mfac, this.c);
            this.a = PolyUtil.integerFromModularCoefficients(this.dfac, ar);
            PolyUtilTest.assertEquals((String)"c == integer(modular(c))", this.c, this.a);
            ++i;
        }
    }

    public void testChineseRemainder() {
        java.math.BigInteger p1 = PolyUtilTest.getPrime1();
        java.math.BigInteger p2 = PolyUtilTest.getPrime2();
        java.math.BigInteger p12 = p1.multiply(p2);
        ModIntegerRing pm1 = new ModIntegerRing(p1);
        GenPolynomialRing<ModInteger> mfac1 = new GenPolynomialRing<ModInteger>(pm1, this.rl, this.to);
        ModIntegerRing pm2 = new ModIntegerRing(p2);
        GenPolynomialRing<ModInteger> mfac2 = new GenPolynomialRing<ModInteger>(pm2, this.rl, this.to);
        ModIntegerRing pm12 = new ModIntegerRing(p12);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm12, this.rl, this.to);
        ModInteger di = pm2.create(p1);
        di = di.inverse();
        int i = 0;
        while (i < 3) {
            GenPolynomial<ModInteger> bm;
            this.c = this.dfac.random(44, this.ll * (i + 1), this.el + i, this.q);
            ExpVector degv = this.c.degreeVector();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<ModInteger> am = PolyUtil.fromIntegerCoefficients(mfac1, this.c);
            ExpVector qdegv = am.degreeVector();
            if (degv.equals(qdegv) && degv.equals(qdegv = (bm = PolyUtil.fromIntegerCoefficients(mfac2, this.c)).degreeVector())) {
                GenPolynomial<ModInteger> cm = PolyUtil.chineseRemainder(mfac, am, di, bm);
                this.a = PolyUtil.integerFromModularCoefficients(this.dfac, cm);
                PolyUtilTest.assertEquals((String)"cra(c mod p1,c mod p2) = c", this.c, this.a);
            }
            ++i;
        }
    }

    public void testComplexConversion() {
        BigRational rf = new BigRational(1L);
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(rf, this.rl, this.to);
        BigComplex cf = new BigComplex(1L);
        GenPolynomialRing<BigComplex> cfac = new GenPolynomialRing<BigComplex>(cf, this.rl, this.to);
        BigComplex imag = BigComplex.I;
        int i = 0;
        while (i < 3) {
            GenPolynomial<BigComplex> cp = cfac.random(this.kl + 2 * i, this.ll * (i + 1), this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (cp.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!cp.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!cp.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> rp = PolyUtil.realPart(rfac, cp);
            GenPolynomial<BigRational> ip = PolyUtil.imaginaryPart(rfac, cp);
            GenPolynomial<BigComplex> crp = PolyUtil.complexFromRational(cfac, rp);
            GenPolynomial<BigComplex> cip = PolyUtil.complexFromRational(cfac, ip);
            GenPolynomial<GenPolynomial<BigComplex>> ap = crp.sum((BigComplex)((Object)cip.multiply(imag)));
            PolyUtilTest.assertEquals((String)"re(c)+i*im(c) = c", cp, ap);
            ++i;
        }
    }

    public void testEvalMainRecursive() {
        this.ai = new BigInteger().random(this.kl);
        this.ar = this.rfac.getZERO();
        this.a = PolyUtil.evaluateMain(this.cfac, this.ar, this.ai);
        PolyUtilTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        this.ar = this.rfac.getONE();
        this.a = PolyUtil.evaluateMain(this.cfac, this.ar, this.ai);
        PolyUtilTest.assertTrue((String)"isONE( a )", (boolean)this.a.isONE());
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.br.sum((GenPolynomial<BigInteger>)this.ar);
        this.a = PolyUtil.evaluateMain(this.cfac, this.ar, this.ai);
        this.b = PolyUtil.evaluateMain(this.cfac, this.br, this.ai);
        this.c = PolyUtil.evaluateMain(this.cfac, this.cr, this.ai);
        this.d = this.a.sum((BigInteger)((Object)this.b));
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", this.c, this.d);
        this.cr = this.br.multiply((GenPolynomial<BigInteger>)this.ar);
        this.a = PolyUtil.evaluateMain(this.cfac, this.ar, this.ai);
        this.b = PolyUtil.evaluateMain(this.cfac, this.br, this.ai);
        this.c = PolyUtil.evaluateMain(this.cfac, this.cr, this.ai);
        this.d = this.a.multiply((BigInteger)((Object)this.b));
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", this.c, this.d);
    }

    public void testEvalMain() {
        this.ei = new BigInteger().random(this.kl);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.a = this.cfac.getZERO();
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isZERO( ai )", (boolean)this.ai.isZERO());
        this.a = this.cfac.getONE();
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isONE( ai )", (boolean)this.ai.isONE());
        this.a = this.cfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.cfac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        this.bi = PolyUtil.evaluateMain(this.ei, this.b, this.ei);
        this.ci = PolyUtil.evaluateMain(this.ei, this.c, this.ei);
        this.di = this.bi.sum(this.ai);
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", (Object)this.ci, (Object)this.di);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        this.bi = PolyUtil.evaluateMain(this.ei, this.b, this.ei);
        this.ci = PolyUtil.evaluateMain(this.ei, this.c, this.ei);
        this.di = this.bi.multiply(this.ai);
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", (Object)this.ci, (Object)this.di);
    }

    public void testEvalFirst() {
        this.ei = new BigInteger().random(this.kl);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.a = fac.getZERO();
        GenPolynomial<BigInteger> ae = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isZERO( ae )", (boolean)ae.isZERO());
        this.a = fac.getONE();
        ae = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isONE( ae )", (boolean)ae.isONE());
        this.a = fac.random(this.kl, this.ll, this.el, this.q);
        this.b = fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        ae = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        GenPolynomial<BigInteger> be = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.b, this.ei);
        GenPolynomial<BigInteger> ce = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.c, this.ei);
        GenPolynomial<GenPolynomial<BigInteger>> de = be.sum((BigInteger)((Object)ae));
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", ce, de);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        ae = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        be = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.b, this.ei);
        ce = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.c, this.ei);
        de = be.multiply((BigInteger)((Object)ae));
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", ce, de);
    }

    public void testEvalAll() {
        BigInteger cfac = new BigInteger();
        ArrayList<BigInteger> Ev = new ArrayList<BigInteger>();
        int i = 0;
        while (i < this.rl) {
            this.ei = cfac.random(this.kl);
            Ev.add(this.ei);
            ++i;
        }
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(cfac, this.rl, this.to);
        this.a = fac.getZERO();
        BigInteger ae = PolyUtil.evaluateAll(cfac, this.dfac, this.a, Ev);
        PolyUtilTest.assertTrue((String)"isZERO( ae )", (boolean)ae.isZERO());
        this.a = fac.getONE();
        ae = PolyUtil.evaluateAll(cfac, this.dfac, this.a, Ev);
        PolyUtilTest.assertTrue((String)"isONE( ae )", (boolean)ae.isONE());
        this.a = fac.random(this.kl, this.ll, this.el, this.q);
        this.b = fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        ae = PolyUtil.evaluateAll(cfac, this.dfac, this.a, Ev);
        BigInteger be = PolyUtil.evaluateAll(cfac, this.dfac, this.b, Ev);
        BigInteger ce = PolyUtil.evaluateAll(cfac, this.dfac, this.c, Ev);
        BigInteger de = be.sum(ae);
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", (Object)ce, (Object)de);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        ce = PolyUtil.evaluateAll(cfac, this.dfac, this.c, Ev);
        de = be.multiply(ae);
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", (Object)ce, (Object)de);
    }

    public void testInterpolateUnivariateOne() {
        ModIntegerRing fac = new ModIntegerRing(19L);
        GenPolynomialRing<ModInteger> cfac = new GenPolynomialRing<ModInteger>(fac, 1, this.to);
        MonoidElem a = cfac.getONE();
        ModInteger ei = fac.fromInteger(11L);
        ModInteger ai = PolyUtil.evaluateMain(fac, a, ei);
        PolyUtilTest.assertTrue((String)"isONE( ai )", (boolean)ai.isONE());
        ModInteger di = fac.fromInteger(13L);
        ModInteger bi = PolyUtil.evaluateMain(fac, a, di);
        PolyUtilTest.assertTrue((String)"isONE( bi )", (boolean)bi.isONE());
        GenPolynomial<ModInteger> r = cfac.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> Q = cfac.getONE();
        ModInteger ci = PolyUtil.evaluateMain(fac, Q, ei);
        ModInteger fi = ci.inverse();
        r = PolyUtil.interpolate(cfac, r, Q, fi, ai, ei);
        GenPolynomial<RingElem<ModInteger>> Qp = cfac.univariate(0);
        Qp = Qp.subtract((ModInteger)((Object)((GenPolynomial)cfac.getONE()).multiply(ei)));
        Q = Q.multiply((GenPolynomial<ModInteger>)Qp);
        ci = PolyUtil.evaluateMain(fac, Q, di);
        fi = ci.inverse();
        r = PolyUtil.interpolate(cfac, r, Q, fi, bi, di);
        ModInteger gi = PolyUtil.evaluateMain(fac, r, ei);
        ModInteger hi = PolyUtil.evaluateMain(fac, r, di);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-ei),a mod (x-di)) = a (mod 19)", (Object)a, r);
    }

    public void testInterpolateUnivariate() {
        long qdeg;
        GenPolynomial<ModInteger> a;
        long prime = PolyUtilTest.getPrime1().longValue();
        ModIntegerRing fac = new ModIntegerRing(prime);
        GenPolynomialRing<ModInteger> cfac = new GenPolynomialRing<ModInteger>(fac, 1, this.to);
        int maxdeg = 19;
        long deg = 0L;
        do {
            if ((a = cfac.random(this.kl, this.ll, maxdeg, this.q)).isZERO()) continue;
            deg = a.degree(0);
        } while (deg <= 0L);
        GenPolynomial<ModInteger> r = cfac.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> Q = cfac.getONE();
        long i = -1L;
        do {
            if (++i >= prime) {
                PolyUtilTest.assertTrue((String)"elements of Z_prime exhausted", (i < prime ? 1 : 0) != 0);
            }
            qdeg = Q.degree(0);
            ModInteger ei = fac.fromInteger(i);
            ModInteger ai = PolyUtil.evaluateMain(fac, a, ei);
            ModInteger ci = PolyUtil.evaluateMain(fac, Q, ei);
            ModInteger fi = ci.inverse();
            r = PolyUtil.interpolate(cfac, r, Q, fi, ai, ei);
            GenPolynomial<RingElem<ModInteger>> Qp = cfac.univariate(0);
            Qp = Qp.subtract((ModInteger)((Object)((GenPolynomial)cfac.getONE()).multiply(ei)));
            Q = Q.multiply((GenPolynomial<ModInteger>)Qp);
        } while (qdeg < deg);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", a, r);
    }

    public void testInterpolateMultivariate() {
        long qdeg;
        GenPolynomial<ModInteger> a;
        long prime = PolyUtilTest.getPrime1().longValue();
        ModIntegerRing fac = new ModIntegerRing(prime);
        GenPolynomialRing<ModInteger> ufac = new GenPolynomialRing<ModInteger>(fac, 1, this.to);
        GenPolynomialRing<ModInteger> cfac = new GenPolynomialRing<ModInteger>(ufac, this.rl, this.to);
        GenPolynomialRing<ModInteger> dfac = new GenPolynomialRing<ModInteger>(fac, this.rl, this.to);
        int maxdeg = 19;
        long deg = 0L;
        do {
            if ((a = cfac.random(this.kl, this.ll + 9, maxdeg, this.q)).isZERO()) continue;
            deg = PolyUtil.coeffMaxDegree(a);
        } while (deg <= 0L);
        ExpVector degv = a.degreeVector();
        GenPolynomial<ModInteger> r = cfac.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> Q = ufac.getONE();
        long i = -1L;
        do {
            if (++i >= prime) {
                PolyUtilTest.assertTrue((String)"elements of Z_prime exhausted", (i < prime ? 1 : 0) != 0);
            }
            qdeg = Q.degree(0);
            ModInteger ei = fac.fromInteger(i);
            GenPolynomial<ModInteger> ap = PolyUtil.evaluateFirstRec(ufac, dfac, a, ei);
            ExpVector qdegv = ap.degreeVector();
            if (!degv.equals(qdegv)) continue;
            ModInteger ci = PolyUtil.evaluateMain(fac, Q, ei);
            ModInteger fi = ci.inverse();
            r = PolyUtil.interpolate(cfac, r, Q, fi, ap, ei);
            GenPolynomial<ModInteger> bp = PolyUtil.evaluateFirstRec(ufac, dfac, r, ei);
            PolyUtilTest.assertEquals((String)"interpolate(a)(ei) == a ", bp, ap);
            GenPolynomial<RingElem<ModInteger>> Qp = ufac.univariate(0);
            Qp = Qp.subtract((ModInteger)((Object)((GenPolynomial)ufac.getONE()).multiply(ei)));
            Q = Q.multiply((GenPolynomial<ModInteger>)Qp);
        } while (qdeg <= deg);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", a, (Object)r);
    }

    public void testInterpolateRationalMultivariate() {
        long qdeg;
        GenPolynomial<BigRational> a;
        BigRational fac = new BigRational();
        GenPolynomialRing<BigRational> ufac = new GenPolynomialRing<BigRational>(fac, 1, this.to);
        GenPolynomialRing<BigRational> cfac = new GenPolynomialRing<BigRational>(ufac, this.rl, this.to);
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(fac, this.rl, this.to);
        int maxdeg = 19;
        long deg = 0L;
        do {
            if ((a = cfac.random(this.kl, this.ll + 9, maxdeg, this.q)).isZERO()) continue;
            deg = PolyUtil.coeffMaxDegree(a);
        } while (deg <= 0L);
        ExpVector degv = a.degreeVector();
        GenPolynomial<BigRational> r = cfac.getZERO();
        GenPolynomial<GenPolynomial<BigRational>> Q = ufac.getONE();
        long i = -1L;
        do {
            BigRational ei;
            GenPolynomial<BigRational> ap;
            ExpVector qdegv;
            qdeg = Q.degree(0);
            if (!degv.equals(qdegv = (ap = PolyUtil.evaluateFirstRec(ufac, dfac, a, ei = fac.fromInteger(++i))).degreeVector())) continue;
            BigRational ci = PolyUtil.evaluateMain(fac, Q, ei);
            BigRational fi = ci.inverse();
            r = PolyUtil.interpolate(cfac, r, Q, fi, ap, ei);
            GenPolynomial<BigRational> bp = PolyUtil.evaluateFirstRec(ufac, dfac, r, ei);
            PolyUtilTest.assertEquals((String)"interpolate(a)(ei) == a ", bp, ap);
            GenPolynomial<RingElem<BigRational>> Qp = ufac.univariate(0);
            Qp = Qp.subtract((BigRational)((Object)((GenPolynomial)ufac.getONE()).multiply(ei)));
            Q = Q.multiply((GenPolynomial<BigRational>)Qp);
        } while (qdeg <= deg);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", a, (Object)r);
    }

    public void testMap() {
        BigInteger fi = new BigInteger();
        BigRational fr = new BigRational();
        ModIntegerRing fm = new ModIntegerRing(17L);
        GenPolynomialRing<BigInteger> pfi = new GenPolynomialRing<BigInteger>(fi, this.rl);
        GenPolynomialRing<BigRational> pfr = new GenPolynomialRing<BigRational>(fr, this.rl);
        GenPolynomialRing<ModInteger> pfm = new GenPolynomialRing<ModInteger>(fm, this.rl);
        GenPolynomial<BigInteger> pi = pfi.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigRational> pr = pfr.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<ModInteger> pm = pfm.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigRational> qr = PolyUtil.map(pfr, pi, new FromInteger<BigRational>(fr));
        GenPolynomial<BigInteger> qi = PolyUtil.map(pfi, qr, new RatNumer());
        PolyUtilTest.assertEquals((String)"pi == qi ", pi, qi);
        qi = PolyUtil.map(pfi, pm, new ModSymToInt());
        GenPolynomial<ModInteger> qm = PolyUtil.map(pfm, qi, new FromInteger<ModInteger>(fm));
        PolyUtilTest.assertEquals((String)"pm == qm ", pm, qm);
        qi = PolyUtil.map(pfi, pm, new ModToInt());
        qm = PolyUtil.map(pfm, qi, new FromInteger<ModInteger>(fm));
        PolyUtilTest.assertEquals((String)"pm == qm ", pm, qm);
        qi = PolyUtil.map(pfi, pm, new ModSymToInt());
        qr = PolyUtil.map(pfr, qi, new FromInteger<BigRational>(fr));
        qi = PolyUtil.map(pfi, qr, new RatNumer());
        qm = PolyUtil.map(pfm, qi, new FromInteger<ModInteger>(fm));
        PolyUtilTest.assertEquals((String)"pm == qm ", pm, qm);
    }

    public void testSubstitution() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        GenPolynomial<BigInteger> s = this.dfac.univariate(0).subtract((BigInteger)this.dfac.fromInteger(7L));
        GenPolynomial<BigInteger> s1 = this.dfac.univariate(0).sum((BigInteger)this.dfac.fromInteger(7L));
        int i = 0;
        while (i < 5) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = PolyUtil.substituteMain(this.a, s);
            this.c = PolyUtil.substituteMain(this.b, s1);
            PolyUtilTest.assertEquals((String)"a == c ", this.a, this.c);
            ++i;
        }
    }

    public void testAlgebraicSubstitution() {
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, this.to, alpha);
        GenPolynomial<BigRational> agen = pfac.univariate(0, 2L);
        agen = agen.sum((BigRational)pfac.getONE());
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(agen, true);
        GenPolynomialRing<BigRational> apfac = new GenPolynomialRing<BigRational>(afac, 1, this.to, vars);
        GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> s = apfac.univariate(0).subtract((BigRational)((Object)((GenPolynomial)apfac.fromInteger(7L)).multiply(afac.getGenerator())));
        GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> s1 = apfac.univariate(0).sum((BigRational)((Object)((GenPolynomial)apfac.fromInteger(7L)).multiply(afac.getGenerator())));
        int i = 0;
        while (i < 5) {
            GenPolynomial<BigRational> a = apfac.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> b = PolyUtil.substituteMain(a, s);
            GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> c = PolyUtil.substituteMain(b, s1);
            PolyUtilTest.assertEquals((String)"a == c ", a, c);
            ++i;
        }
    }

    public void testSwitchVariables() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl, this.to);
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(pfac, this.rl, this.to);
        int i = 0;
        while (i < 5) {
            GenPolynomial<BigRational> a = rfac.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial b = PolyUtil.switchVariables(a);
            GenPolynomial c = PolyUtil.switchVariables(b);
            PolyUtilTest.assertEquals((String)"a == c ", a, c);
            ++i;
        }
    }

    public void testAlgebraicConversions() {
        BigRational cfac = new BigRational(1L);
        String[] alpha = new String[]{"alpha"};
        String[] vars = new String[]{"z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, this.to, alpha);
        GenPolynomial<BigRational> agen = pfac.univariate(0, 2L);
        agen = agen.sum((BigRational)pfac.getONE());
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(agen, true);
        GenPolynomialRing<BigRational> apfac = new GenPolynomialRing<BigRational>(afac, this.rl, this.to);
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(pfac, this.rl, this.to);
        int i = 0;
        while (i < 5) {
            GenPolynomial<BigRational> a = apfac.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial b = PolyUtil.fromAlgebraicCoefficients(rfac, a);
            GenPolynomial c = PolyUtil.convertRecursiveToAlgebraicCoefficients(apfac, b);
            PolyUtilTest.assertEquals((String)"a == c ", a, c);
            ++i;
        }
    }

    public void testTaylorSeries() {
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(cfac, 1, this.to, vars);
        GenPolynomial<BigRational> a = dfac.random(this.kl, this.ll, this.el, this.q);
        BigRational v = cfac.getZERO();
        GenPolynomial<BigRational> b = PolyUtil.seriesOfTaylor(a, v);
        PolyUtilTest.assertTrue((String)"taylor(a,0) == a ", (boolean)a.equals(b));
        v = cfac.random(this.kl);
        b = PolyUtil.seriesOfTaylor(a, v);
        GenPolynomial<BigRational> c = PolyUtil.seriesOfTaylor(b, v.negate());
        PolyUtilTest.assertTrue((String)"tailor(taylor(a,v),-v) == a ", (boolean)a.equals(c));
    }

    public void testComplexParts() {
        BigRational rf = new BigRational(1L);
        GenPolynomialRing<BigRational> rfac = new GenPolynomialRing<BigRational>(rf, this.rl, this.to);
        ComplexRing<BigRational> cf = new ComplexRing<BigRational>(new BigRational(1L));
        GenPolynomialRing<BigRational> cfac = new GenPolynomialRing<BigRational>(cf, this.rl, this.to);
        Complex<BigRational> imag = cf.getIMAG();
        int i = 0;
        while (i < 3) {
            GenPolynomial<BigRational> cp = cfac.random(this.kl + 2 * i, this.ll * (i + 1), this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (cp.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!cp.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!cp.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> rp = PolyUtil.realPartFromComplex(rfac, cp);
            GenPolynomial<BigRational> ip = PolyUtil.imaginaryPartFromComplex(rfac, cp);
            GenPolynomial<Complex<BigRational>> crp = PolyUtil.toComplex(cfac, rp);
            GenPolynomial<Complex<BigRational>> cip = PolyUtil.toComplex(cfac, ip);
            GenPolynomial<GenPolynomial<Complex<BigRational>>> ap = crp.sum((Complex<BigRational>)((Object)cip.multiply(imag)));
            PolyUtilTest.assertEquals((String)"re(c)+i*im(c) = c", cp, ap);
            ++i;
        }
    }

    public void testProductConversionRN() {
        GenPolynomialRing<BigRational> ufac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        ProductRing<BigRational> pfac = new ProductRing<BigRational>(ufac, this.rl);
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        GenPolynomial<BigRational> c = dfac.getONE();
        Product<GenPolynomial<Object>> cp = PolyUtil.toProduct(pfac, c);
        PolyUtilTest.assertTrue((String)"isONE( cp )", (boolean)cp.isONE());
        c = dfac.random(this.kl, this.ll, this.el, this.q);
        cp = PolyUtil.toProduct(pfac, c);
        PolyUtilTest.assertTrue((String)"!isONE( cp )", (!cp.isONE() ? 1 : 0) != 0);
    }

    public void testPolyProductConversionAN() {
        GenPolynomialRing<BigRational> ufac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        GenPolynomial<RingElem<BigRational>> m = ufac.univariate(0, 2L);
        m = m.subtract((BigRational)((Object)ufac.univariate(0, 1L)));
        AlgebraicNumberRing<BigRational> afac = new AlgebraicNumberRing<BigRational>(m);
        ProductRing<BigRational> pfac = new ProductRing<BigRational>(afac, this.rl);
        GenPolynomialRing<BigRational> dpfac = new GenPolynomialRing<BigRational>(pfac, 2);
        GenPolynomialRing<BigRational> dfac = new GenPolynomialRing<BigRational>(afac, 2, this.to);
        GenPolynomial<BigRational> c = dfac.getONE();
        GenPolynomial<Product<Object>> cp = PolyUtil.toProductGen(dpfac, c);
        PolyUtilTest.assertTrue((String)"isZERO( cp )", (boolean)cp.isONE());
        c = dfac.random(this.kl, this.ll, this.el, this.q);
        cp = PolyUtil.toProductGen(dpfac, c);
        PolyUtilTest.assertTrue((String)"!isONE( cp )", (!cp.isONE() ? 1 : 0) != 0);
    }
}

