/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.ModuleList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PolynomialList<C extends RingElem<C>>
implements Comparable<PolynomialList<C>>,
Serializable,
Cloneable {
    public final GenPolynomialRing<C> ring;
    public final List<GenPolynomial<C>> list;
    private static final Logger logger = Logger.getLogger(PolynomialList.class);

    public PolynomialList(GenPolynomialRing<C> r, List<GenPolynomial<C>> l) {
        this.ring = r;
        this.list = l;
    }

    public PolynomialList(GenSolvablePolynomialRing<C> r, List<GenSolvablePolynomial<C>> l) {
        this((GenPolynomialRing<C>)r, PolynomialList.castToList(l));
    }

    public PolynomialList<C> clone() {
        return new PolynomialList<C>(this.ring, new ArrayList<GenPolynomial<C>>(this.list));
    }

    public boolean equals(Object p) {
        if (!(p instanceof PolynomialList)) {
            System.out.println("no PolynomialList");
            return false;
        }
        PolynomialList pl = null;
        try {
            pl = (PolynomialList)p;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (pl == null) {
            return false;
        }
        if (!this.ring.equals(pl.ring)) {
            System.out.println("not same Ring " + this.ring.toScript() + ", " + pl.ring.toScript());
            return false;
        }
        return this.compareTo(pl) == 0;
    }

    @Override
    public int compareTo(PolynomialList<C> L) {
        int si = L.list.size();
        if (this.list.size() < si) {
            si = this.list.size();
        }
        int s = 0;
        List<GenPolynomial<C>> l1 = OrderedPolynomialList.sort(this.ring, this.list);
        List<GenPolynomial<C>> l2 = OrderedPolynomialList.sort(this.ring, L.list);
        int i = 0;
        while (i < si) {
            GenPolynomial<C> b;
            GenPolynomial<C> a = l1.get(i);
            s = a.compareTo(b = l2.get(i));
            if (s != 0) {
                return s;
            }
            ++i;
        }
        if (this.list.size() > si) {
            return 1;
        }
        if (L.list.size() > si) {
            return -1;
        }
        return s;
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + (this.list == null ? 0 : this.list.hashCode());
        return h;
    }

    public String toString() {
        StringBuffer erg = new StringBuffer();
        String[] vars = null;
        if (this.ring != null) {
            erg.append(this.ring.toString());
            vars = this.ring.getVars();
        }
        boolean first = true;
        erg.append("\n(\n");
        String sa = null;
        for (GenPolynomial<C> oa : this.list) {
            sa = vars != null ? oa.toString(vars) : oa.toString();
            if (first) {
                first = false;
            } else {
                erg.append(", ");
                if (sa.length() > 10) {
                    erg.append("\n");
                }
            }
            erg.append("( " + sa + " )");
        }
        erg.append("\n)");
        return erg.toString();
    }

    public String toScript() {
        StringBuffer erg = new StringBuffer();
        erg.append("Ideal(");
        if (this.ring != null) {
            erg.append(this.ring.toScript());
        }
        if (this.list == null) {
            erg.append(")");
            return erg.toString();
        }
        erg.append(",list=[");
        boolean first = true;
        String sa = null;
        for (GenPolynomial<C> oa : this.list) {
            sa = oa.toScript();
            if (first) {
                first = false;
            } else {
                erg.append(", ");
            }
            erg.append("( " + sa + " )");
        }
        erg.append("])");
        return erg.toString();
    }

    public ModuleList<C> getModuleList(int i) {
        GenPolynomialRing<C> pfac = this.ring.contract(i);
        logger.debug((Object)("contracted ring = " + pfac));
        ArrayList vecs = null;
        if (this.list == null) {
            return new ModuleList<C>(pfac, vecs);
        }
        int rows = this.list.size();
        vecs = new ArrayList(rows);
        if (rows == 0) {
            return new ModuleList<C>(pfac, vecs);
        }
        ArrayList<AbelianGroupElem> zr = new ArrayList<AbelianGroupElem>(i - 1);
        AbelianGroupElem zero = pfac.getZERO();
        int j = 0;
        while (j < i) {
            zr.add(j, zero);
            ++j;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null) continue;
            Map<ExpVector, GenPolynomial<C>> r = null;
            r = p.contract(pfac);
            ArrayList row = (ArrayList)zr.clone();
            for (ExpVector e : r.keySet()) {
                int[] dov = e.dependencyOnVariables();
                int ix = 0;
                if (dov.length > 1) {
                    throw new IllegalArgumentException("wrong dependencyOnVariables " + e);
                }
                if (dov.length == 1) {
                    ix = dov[0];
                }
                GenPolynomial<C> vi = r.get(e);
                row.set(ix, vi);
            }
            vecs.add(row);
        }
        return new ModuleList<C>(pfac, vecs);
    }

    public List<GenSolvablePolynomial<C>> castToSolvableList() {
        ArrayList<GenSolvablePolynomial<C>> slist = null;
        if (this.list == null) {
            return slist;
        }
        slist = new ArrayList<GenSolvablePolynomial<C>>(this.list.size());
        for (GenPolynomial<C> p : this.list) {
            if (!(p instanceof GenSolvablePolynomial)) {
                throw new IllegalArgumentException("no solvable polynomial " + p);
            }
            GenSolvablePolynomial s = (GenSolvablePolynomial)p;
            slist.add(s);
        }
        return slist;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> castToList(List<? extends GenPolynomial<C>> slist) {
        ArrayList<GenPolynomial<C>> list = null;
        if (slist == null) {
            return list;
        }
        list = new ArrayList<GenPolynomial<C>>(slist.size());
        for (GenPolynomial<C> p : slist) {
            list.add(p);
        }
        return list;
    }

    public boolean isZERO() {
        if (this.list == null) {
            return true;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null || p.isZERO()) continue;
            return false;
        }
        return true;
    }

    public boolean isONE() {
        if (this.list == null) {
            return false;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null || !p.isONE()) continue;
            return true;
        }
        return false;
    }
}

