/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolynomialList;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolynomialListTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    PolynomialList<BigRational> m;
    PolynomialList<BigRational> p;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 4;
    int ll = 4;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)PolynomialListTest.suite());
    }

    public PolynomialListTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PolynomialListTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.m = null;
        this.p = null;
        BigRational coeff = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.m = null;
        this.p = null;
    }

    public void testConstructor() {
        this.p = new PolynomialList<BigRational>(this.fac, null);
        PolynomialListTest.assertTrue((String)"p = 0", (this.p.list == null ? 1 : 0) != 0);
        this.m = new PolynomialList<BigRational>(this.fac, new ArrayList());
        PolynomialListTest.assertTrue((String)"m = 0", (this.m.list != null ? 1 : 0) != 0);
        PolynomialListTest.assertTrue((String)"m.size() == 0", (this.m.list.size() == 0 ? 1 : 0) != 0);
    }

    public void testPolynomialList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll + i);
            PolynomialListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            PolynomialListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            PolynomialListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            l.add(this.a);
            ++i;
        }
        this.p = new PolynomialList<BigRational>(this.fac, l);
        PolynomialListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        PolynomialListTest.assertEquals((String)"p.length", (int)7, (int)this.p.list.size());
    }

    public void testOrderedPolynomialList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll + i);
            PolynomialListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            PolynomialListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            PolynomialListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            l.add(this.a);
            ++i;
        }
        this.p = new PolynomialList<BigRational>(this.fac, l);
        this.m = new OrderedPolynomialList<BigRational>(this.fac, this.p.list);
        PolynomialListTest.assertTrue((String)"p == m", (boolean)this.p.equals(this.m));
        PolynomialListTest.assertTrue((String)"m != p", (!this.m.equals(this.p) ? 1 : 0) != 0);
        PolynomialListTest.assertEquals((String)"p.length", (int)7, (int)this.p.list.size());
        PolynomialListTest.assertEquals((String)"m.length", (int)7, (int)this.m.list.size());
    }
}

