/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigQuaternion;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuatGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigQuaternion> fac;
    GenPolynomial<BigQuaternion> a;
    GenPolynomial<BigQuaternion> b;
    GenPolynomial<BigQuaternion> c;
    GenPolynomial<BigQuaternion> d;
    GenPolynomial<BigQuaternion> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)QuatGenPolynomialTest.suite());
    }

    public QuatGenPolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QuatGenPolynomialTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigQuaternion>(new BigQuaternion(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        QuatGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        QuatGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuatGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll);
            QuatGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuatGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuatGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigQuaternion)((Object)this.b));
        this.d = this.c.subtract((BigQuaternion)((Object)this.b));
        QuatGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector u = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigQuaternion x = BigQuaternion.QRAND(this.kl);
        this.b = new GenPolynomial<BigQuaternion>(this.fac, x, u);
        this.c = this.a.sum((BigQuaternion)((Object)this.b));
        this.d = this.a.sum(x, u);
        QuatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigQuaternion)((Object)this.b));
        this.d = this.a.subtract(x, u);
        QuatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigQuaternion>(this.fac);
        this.b = new GenPolynomial<BigQuaternion>(this.fac, x, u);
        this.c = this.b.sum((BigQuaternion)((Object)this.a));
        this.d = this.a.sum(x, u);
        QuatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigQuaternion)((Object)this.b));
        this.d = this.a.subtract(x, u);
        QuatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigQuaternion)((Object)this.a));
        this.d = this.a.multiply((BigQuaternion)((Object)this.b));
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigQuaternion)((Object)this.c));
        QuatGenPolynomialTest.assertTrue((String)("!isZERO( a*b-b*a ) " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"a*b = b*a", (!this.c.equals(this.d) ? 1 : 0) != 0);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigQuaternion)((Object)this.b.multiply((BigQuaternion)((Object)this.c))));
        this.e = this.a.multiply((BigQuaternion)((Object)this.b)).multiply(this.c);
        QuatGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuatGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigQuaternion x = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(x);
        QuatGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigQuaternion y = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(y);
        QuatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigQuaternion>(this.fac, y);
        this.d = this.b.multiply((BigQuaternion)((Object)this.e));
        QuatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
    }
}

