/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RatGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)RatGenPolynomialTest.suite());
    }

    public RatGenPolynomialTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RatGenPolynomialTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RatGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RatGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RatGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 7) {
            this.a = this.fac.random(this.ll);
            RatGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RatGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RatGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.c.subtract((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector u = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigRational x = BigRational.RNRAND(this.kl);
        this.b = new GenPolynomial<BigRational>(this.fac, x, u);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.a.sum(x, u);
        RatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigRational)((Object)this.b));
        this.d = this.a.subtract(x, u);
        RatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigRational>(this.fac);
        this.b = new GenPolynomial<BigRational>(this.fac, x, u);
        this.c = this.b.sum((BigRational)((Object)this.a));
        this.d = this.a.sum(x, u);
        RatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigRational)((Object)this.b));
        this.d = this.a.subtract(x, u);
        RatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigRational)((Object)this.c));
        RatGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RatGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RatGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RatGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RatGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigRational x = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(x);
        RatGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigRational y = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(y);
        RatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigRational>(this.fac, y);
        this.d = this.b.multiply((BigRational)((Object)this.e));
        RatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).sum((GenPolynomial<BigRational>)this.a.multiply((BigRational)((Object)this.c)));
        RatGenPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testQuotRem() {
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        this.a = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        GenPolynomial<BigRational> h = this.a;
        GenPolynomial g = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( g )", (!g.isZERO() ? 1 : 0) != 0);
        this.a = this.a.multiply((BigRational)((Object)g));
        this.b = this.b.multiply((BigRational)((Object)g));
        GenPolynomial<BigRational>[] qr = this.b.divideAndRemainder(this.a);
        this.c = qr[0];
        this.d = qr[1];
        this.e = this.c.multiply((BigRational)((Object)this.a)).sum(this.d);
        RatGenPolynomialTest.assertEquals((String)"b = q a + r", this.b, this.e);
        qr = this.a.divideAndRemainder(this.b);
        this.c = qr[0];
        this.d = qr[1];
        this.e = this.c.multiply((BigRational)((Object)this.b)).sum(this.d);
        RatGenPolynomialTest.assertEquals((String)"a = q b + r", this.a, this.e);
        this.c = this.a.gcd(this.b);
        RatGenPolynomialTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        RatGenPolynomialTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, g);
        GenPolynomial<BigRational>[] gst = this.a.egcd(this.b);
        this.c = gst[0];
        this.d = gst[1];
        this.e = gst[2];
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, g);
        GenPolynomial<RingElem<GenPolynomial<BigRational>>> x = this.a.multiply((BigRational)((Object)this.d)).sum((GenPolynomial<BigRational>)this.b.multiply((BigRational)((Object)this.e))).monic();
        RatGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s + b t", this.c, x);
        gst = this.a.hegcd(this.b);
        this.c = gst[0];
        this.d = gst[1];
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, g);
        x = this.a.multiply((BigRational)((Object)this.d)).remainder((GenPolynomial<GenPolynomial<BigRational>>)this.b).monic();
        RatGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s mod b", this.c, x);
        this.c = h.modInverse(g);
        x = this.c.multiply((BigRational)((Object)h)).remainder(g).monic();
        RatGenPolynomialTest.assertTrue((String)"h invertible mod g", (boolean)x.isONE());
    }
}

