/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.UnaryFunctor;

class RatToIntPoly
implements UnaryFunctor<GenPolynomial<BigRational>, GenPolynomial<BigInteger>> {
    GenPolynomialRing<BigInteger> ring;

    public RatToIntPoly(GenPolynomialRing<BigInteger> ring) {
        if (ring == null) {
            throw new IllegalArgumentException("ring must not be null");
        }
        this.ring = ring;
    }

    @Override
    public GenPolynomial<BigInteger> eval(GenPolynomial<BigRational> c) {
        if (c == null) {
            return this.ring.getZERO();
        }
        return PolyUtil.integerFromRationalCoefficients(this.ring, c);
    }
}

