/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorPair;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RelationTable<C extends RingElem<C>>
implements Serializable {
    public final Map<List<Integer>, List> table = new HashMap<List<Integer>, List>();
    public final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(RelationTable.class);
    private final boolean debug = true;

    protected RelationTable(GenSolvablePolynomialRing<C> r) {
        this.ring = r;
        if (this.ring == null) {
            throw new IllegalArgumentException("RelationTable no ring");
        }
    }

    public boolean equals(Object p) {
        List b;
        List a;
        if (!(p instanceof RelationTable)) {
            System.out.println("no RelationTable");
            return false;
        }
        RelationTable tab = null;
        try {
            tab = (RelationTable)p;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (tab == null) {
            return false;
        }
        if (!this.ring.equals(tab.ring)) {
            System.out.println("not same Ring " + this.ring.toScript() + ", " + tab.ring.toScript());
            return false;
        }
        for (List<Integer> k : this.table.keySet()) {
            a = this.table.get(k);
            b = tab.table.get(k);
            if (b == null) {
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        for (List<Integer> k : tab.table.keySet()) {
            a = this.table.get(k);
            b = tab.table.get(k);
            if (a == null) {
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 31 * h + this.table.hashCode();
        return h;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RelationTable[");
        boolean first = true;
        for (List<Integer> k : this.table.keySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(k.toString());
            List v = this.table.get(k);
            s.append("=");
            s.append(v.toString());
        }
        s.append("]");
        return s.toString();
    }

    public String toString(String[] vars) {
        if (vars == null) {
            return this.toString();
        }
        StringBuffer s = new StringBuffer("RelationTable\n(");
        if (PrettyPrint.isTrue()) {
            boolean first = true;
            for (List<Integer> k : this.table.keySet()) {
                if (first) {
                    first = false;
                    s.append("\n");
                } else {
                    s.append(",\n");
                }
                List v = this.table.get(k);
                Iterator jt = v.iterator();
                while (jt.hasNext()) {
                    ExpVectorPair ep = (ExpVectorPair)jt.next();
                    s.append("( " + ep.getFirst().toString(vars) + " ), ");
                    s.append("( " + ep.getSecond().toString(vars) + " ), ");
                    GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                    s.append("( " + p.toString(vars) + " )");
                    if (!jt.hasNext()) continue;
                    s.append(",\n");
                }
            }
        } else {
            boolean first = true;
            for (List<Integer> k : this.table.keySet()) {
                if (first) {
                    first = false;
                } else {
                    s.append(",\n");
                }
                List v = this.table.get(k);
                Iterator jt = v.iterator();
                while (jt.hasNext()) {
                    ExpVectorPair ep = (ExpVectorPair)jt.next();
                    s.append("( " + ep.getFirst().toString(vars) + " ), ");
                    s.append("( " + ep.getSecond().toString(vars) + " ), ");
                    GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                    s.append("( " + p.toString(vars) + " )");
                    if (!jt.hasNext()) continue;
                    s.append(",\n");
                }
            }
        }
        s.append("\n)\n");
        return s.toString();
    }

    public String toScript() {
        String[] vars = this.ring.vars;
        StringBuffer s = new StringBuffer("[");
        boolean first = true;
        for (List<Integer> k : this.table.keySet()) {
            if (first) {
                first = false;
                s.append("");
            } else {
                s.append(", ");
            }
            List v = this.table.get(k);
            Iterator jt = v.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                s.append(ep.getFirst().toScript(vars) + ", ");
                s.append(ep.getSecond().toScript(vars) + ", ");
                GenPolynomial p = (GenPolynomial)jt.next();
                s.append("( " + p.toScript() + " )");
                if (!jt.hasNext()) continue;
                s.append(", ");
            }
        }
        s.append("]");
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ExpVector e, ExpVector f, GenSolvablePolynomial<C> p) {
        LinkedList<Serializable> part;
        ExpVector lp;
        ExpVector ef;
        if (p != null && p.ring.vars != null) {
            logger.info((Object)("new relation = " + e.toString(p.ring.vars) + " .*. " + f.toString(p.ring.vars) + " = " + p));
        } else {
            logger.info((Object)("new relation = " + e + " .*. " + f + " = " + p));
        }
        if (p == null || e == null || f == null) {
            throw new IllegalArgumentException("RelationTable update e|f|p == null");
        }
        if (e.totalDeg() == 1L && f.totalDeg() == 1L) {
            int[] de = e.dependencyOnVariables();
            int[] df = f.dependencyOnVariables();
            logger.debug((Object)("update e ? f " + de[0] + " " + df[0]));
            if (de[0] == df[0]) {
                throw new IllegalArgumentException("RelationTable update e==f");
            }
            if (de[0] > df[0]) {
                logger.error((Object)("warning: update e > f " + e + " " + f + " changed"));
                ExpVector tmp = e;
                e = f;
                f = tmp;
                Map.Entry m = p.leadingMonomial();
                AbelianGroupElem<GenPolynomial<RingElem>> r = p.subtract((RingElem)m.getValue(), m.getKey());
                r = ((GenPolynomial)r).negate();
                p = (GenSolvablePolynomial)((GenPolynomial)r).sum((GenPolynomial<RingElem>)((RingElem)m.getValue()), m.getKey());
            }
        }
        if (!(ef = e.sum(f)).equals(lp = p.leadingExpVector())) {
            logger.error((Object)("relation term order = " + this.ring.tord));
            throw new IllegalArgumentException("RelationTable update e*f != lt(p)");
        }
        List<Integer> key = this.makeKey(e, f);
        ExpVectorPair evp = new ExpVectorPair(e, f);
        if (key.size() != 2) {
            System.out.println("key = " + key + ", evp = " + evp);
        }
        if ((part = this.table.get(key)) == null) {
            part = new LinkedList<Serializable>();
            part.add(evp);
            part.add(p);
            this.table.put(key, part);
            return;
        }
        int index = -1;
        LinkedList<Serializable> linkedList = part;
        synchronized (linkedList) {
            ListIterator it = part.listIterator();
            while (it.hasNext()) {
                ExpVectorPair look = (ExpVectorPair)it.next();
                Object o = it.next();
                if (!look.isMultiple(evp)) continue;
                index = it.nextIndex();
            }
            if (index < 0) {
                index = 0;
            }
            part.add(index, evp);
            part.add(index + 1, p);
        }
    }

    public void update(GenPolynomial<C> E2, GenPolynomial<C> F2, GenSolvablePolynomial<C> p) {
        if (E2.isZERO() || F2.isZERO()) {
            throw new IllegalArgumentException("polynomials may not be zero: " + E2 + ", " + F2);
        }
        C ce = E2.leadingBaseCoefficient();
        C cf = F2.leadingBaseCoefficient();
        if (!ce.isONE() || !cf.isONE()) {
            throw new IllegalArgumentException("lbcf of polynomials must be one: " + ce + ", " + cf);
        }
        ExpVector e = E2.leadingExpVector();
        ExpVector f = F2.leadingExpVector();
        this.update(e, f, p);
    }

    public void update(GenPolynomial<C> E2, GenPolynomial<C> F2, GenPolynomial<C> p) {
        if (p.isZERO()) {
            throw new IllegalArgumentException("polynomial may not be zero: " + p);
        }
        if (p.isONE()) {
            throw new IllegalArgumentException("product of polynomials may not be one: " + p);
        }
        GenSolvablePolynomial<C> sp = new GenSolvablePolynomial<C>(this.ring, p.val);
        this.update(E2, F2, sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRelation<C> lookup(ExpVector e, ExpVector f) {
        List<Integer> key = this.makeKey(e, f);
        List part = this.table.get(key);
        if (part == null) {
            ExpVector ef = e.sum(f);
            GenPolynomial p = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
            return new TableRelation(null, null, p);
        }
        ExpVectorPair evp = new ExpVectorPair(e, f);
        ExpVector ep = null;
        ExpVector fp = null;
        ExpVectorPair look = null;
        GenSolvablePolynomial p = null;
        List list = part;
        synchronized (list) {
            Iterator it = part.iterator();
            while (it.hasNext()) {
                look = (ExpVectorPair)it.next();
                p = (GenSolvablePolynomial)it.next();
                if (!evp.isMultiple(look)) continue;
                ep = e.subtract(look.getFirst());
                fp = f.subtract(look.getSecond());
                if (ep.isZERO()) {
                    ep = null;
                }
                if (fp.isZERO()) {
                    fp = null;
                }
                return new TableRelation(ep, fp, p);
            }
        }
        throw new RuntimeException("no entry found in relation table for " + evp);
    }

    protected List<Integer> makeKey(ExpVector e, ExpVector f) {
        int[] de = e.dependencyOnVariables();
        int[] df = f.dependencyOnVariables();
        ArrayList<Integer> key = new ArrayList<Integer>(de.length + df.length);
        int i = 0;
        while (i < de.length) {
            key.add(new Integer(de[i]));
            ++i;
        }
        i = 0;
        while (i < df.length) {
            key.add(new Integer(df[i]));
            ++i;
        }
        return key;
    }

    public int size() {
        int s = 0;
        if (this.table == null) {
            return s;
        }
        for (List list : this.table.values()) {
            s += list.size() / 2;
        }
        return s;
    }

    public void extend(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        int i = this.ring.nvar - tab.ring.nvar;
        int j = 0;
        long k = 0L;
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                ExpVector ex = e.extend(i, j, k);
                ExpVector fx = f.extend(i, j, k);
                GenSolvablePolynomial px = (GenSolvablePolynomial)p.extend(this.ring, j, k);
                this.update(ex, fx, px);
            }
        }
    }

    public void contract(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        int i = tab.ring.nvar - this.ring.nvar;
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                Map<ExpVector, GenPolynomial<C>> mc;
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                ExpVector ec = e.contract(i, e.length() - i);
                ExpVector fc = f.contract(i, f.length() - i);
                if (ec.isZERO() || fc.isZERO() || (mc = p.contract(this.ring)).size() != 1) continue;
                GenSolvablePolynomial pc = null;
                for (GenPolynomial<C> x : mc.values()) {
                    if (pc != null) {
                        logger.info((Object)("e = " + e + ", f = " + f + ", ec = " + ec + ", fc = " + fc));
                        logger.info((Object)("p = " + p + ", mc = " + mc));
                        throw new RuntimeException("Map.size() != 1: " + mc.size());
                    }
                    pc = (GenSolvablePolynomial)x;
                }
                this.update(ec, fc, pc);
            }
        }
    }

    public void reverse(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        if (this.table.size() != 0) {
            logger.error((Object)"reverse table not empty");
        }
        int k = -1;
        if (this.ring.tord.getEvord2() != 0 && this.ring.partial) {
            k = this.ring.tord.getSplit();
        }
        logger.debug((Object)("k split = " + k));
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                ExpVector fx;
                ExpVector ex;
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                boolean change = true;
                if (k >= 0) {
                    int[] fd;
                    ex = e.reverse(k);
                    fx = f.reverse(k);
                    int[] ed = ex.dependencyOnVariables();
                    if (ed.length == 0 || ed[0] >= k) {
                        change = false;
                    }
                    if ((fd = fx.dependencyOnVariables()).length == 0 || fd[0] >= k) {
                        change = false;
                    }
                } else {
                    ex = e.reverse();
                    fx = f.reverse();
                }
                GenSolvablePolynomial px = (GenSolvablePolynomial)p.reverse(this.ring);
                if (!change) {
                    this.update(e, f, px);
                    continue;
                }
                this.update(fx, ex, px);
            }
        }
    }
}

