/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TableRelation;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RelationTableTest
extends TestCase {
    RelationTable<BigRational> table;
    GenSolvablePolynomialRing<BigRational> ring;
    int rl = 5;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RelationTableTest.suite());
    }

    public RelationTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RelationTableTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational cfac = new BigRational(1L);
        this.ring = new GenSolvablePolynomialRing<BigRational>(cfac, this.rl);
        this.table = this.ring.table;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
    }

    public void testConstructor() {
        this.table = new RelationTable<BigRational>(this.ring);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        RelationTableTest.assertEquals((String)"ring == table.ring", this.ring, this.table.ring);
        String s = "RelationTable[]";
        String t = this.table.toString();
        RelationTableTest.assertEquals((String)"RelationTable[]", (String)s, (String)t);
    }

    public void testUpdateOneKey() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector e = ExpVector.create(this.rl, 2, 1L);
        ExpVector f = ExpVector.create(this.rl, 3, 1L);
        ExpVector ef = e.sum(f);
        GenPolynomial a = this.ring.getONE();
        GenPolynomial b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        GenSolvablePolynomial rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 2L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 4L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 4", (int)4, (int)this.table.size());
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 3L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 5", (int)5, (int)this.table.size());
    }

    public void testUpdateKeys() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector e = ExpVector.create(this.rl, 2, 1L);
        ExpVector f = ExpVector.create(this.rl, 3, 1L);
        ExpVector ef = e.sum(f);
        GenPolynomial a = this.ring.getONE();
        GenPolynomial b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        GenSolvablePolynomial rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        e = ExpVector.create(this.rl, 0, 1L);
        f = ExpVector.create(this.rl, 2, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        e = ExpVector.create(this.rl, 2, 1L);
        f = ExpVector.create(this.rl, 4, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
    }

    public void testLookupOneKey() {
        GenSolvablePolynomial rel;
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector e = ExpVector.create(this.rl, 2, 1L);
        ExpVector f = ExpVector.create(this.rl, 3, 1L);
        ExpVector ef = e.sum(f);
        GenPolynomial a = this.ring.getONE();
        GenPolynomial b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        GenSolvablePolynomial r1 = rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        TableRelation<BigRational> r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 2L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 4L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 4", (int)4, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 2L);
        f = ExpVector.create(this.rl, 3, 3L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 5", (int)5, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 1L);
        f = ExpVector.create(this.rl, 3, 1L);
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)r1, r.p);
    }

    public void testLookupKeys() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector e = ExpVector.create(this.rl, 2, 1L);
        ExpVector f = ExpVector.create(this.rl, 3, 1L);
        ExpVector ef = e.sum(f);
        GenPolynomial a = this.ring.getONE();
        GenPolynomial b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        GenSolvablePolynomial rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        TableRelation<BigRational> r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 0, 1L);
        f = ExpVector.create(this.rl, 2, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
        e = ExpVector.create(this.rl, 2, 1L);
        f = ExpVector.create(this.rl, 4, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        rel = (GenSolvablePolynomial)a.sum(b);
        this.table.update(e, f, (GenSolvablePolynomial<BigRational>)rel);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)rel, r.p);
    }

    public void testSymmetric() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector e = ExpVector.create(this.rl, 2, 1L);
        ExpVector f = ExpVector.create(this.rl, 3, 1L);
        ExpVector ef = e.sum(f);
        GenPolynomial b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        TableRelation<BigRational> r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)b, r.p);
        e = ExpVector.create(this.rl, 0, 1L);
        f = ExpVector.create(this.rl, 2, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)b, r.p);
        e = ExpVector.create(this.rl, 2, 1L);
        f = ExpVector.create(this.rl, 4, 1L);
        ef = e.sum(f);
        b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(ef);
        r = this.table.lookup(e, f);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)r.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)r.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)b, r.p);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
    }
}

