/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ResidueRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Residue<C extends RingElem<C>>
implements RingElem<Residue<C>> {
    private static final Logger logger = Logger.getLogger(Residue.class);
    private boolean debug = logger.isDebugEnabled();
    protected final ResidueRing<C> ring;
    protected final C val;
    protected int isunit = -1;

    public Residue(ResidueRing<C> r) {
        this(r, (RingElem)r.ring.getZERO(), 0);
    }

    public Residue(ResidueRing<C> r, C a) {
        this(r, a, -1);
    }

    public Residue(ResidueRing<C> r, C a, int u) {
        this.ring = r;
        RingElem v = (RingElem)a.remainder(this.ring.modul);
        if (v.signum() < 0) {
            v = (RingElem)v.sum(this.ring.modul);
        }
        this.val = v;
        switch (u) {
            case 0: {
                this.isunit = u;
                break;
            }
            case 1: {
                this.isunit = u;
                break;
            }
            default: {
                this.isunit = -1;
            }
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
    }

    @Override
    public ResidueRing<C> factory() {
        return this.ring;
    }

    public Residue<C> clone() {
        return new Residue<C>(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(this.ring.ring.getZERO());
    }

    @Override
    public boolean isONE() {
        return this.val.equals(this.ring.ring.getONE());
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.val instanceof GcdRingElem && this.ring.modul instanceof GcdRingElem) {
            boolean u;
            GcdRingElem v = (GcdRingElem)this.val;
            GcdRingElem m = (GcdRingElem)this.ring.modul;
            GcdRingElem gcd = v.gcd(m);
            if (this.debug) {
                logger.info((Object)("gcd = " + gcd));
            }
            this.isunit = (u = gcd.isONE()) ? 1 : 0;
            return u;
        }
        return false;
    }

    public String toString() {
        return "Residue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Residue( " + this.val.toScript() + " , " + this.ring.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((ResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Residue<C> b) {
        Object v = b.val;
        if (!this.ring.equals(b.ring)) {
            v = (RingElem)v.remainder(this.ring.modul);
        }
        return this.val.compareTo(v);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Residue)) {
            return false;
        }
        Residue a = null;
        try {
            a = (Residue)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.val.hashCode();
        return h;
    }

    @Override
    public Residue<C> abs() {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.abs());
    }

    @Override
    public Residue<C> sum(Residue<C> S) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.sum(S.val));
    }

    @Override
    public Residue<C> negate() {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public Residue<C> subtract(Residue<C> S) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.subtract(S.val));
    }

    @Override
    public Residue<C> divide(Residue<C> S) {
        return this.multiply((Residue<C>)S.inverse());
    }

    @Override
    public Residue<C> inverse() {
        if (this.isunit == 0) {
            throw new NotInvertibleException("element not invertible (0) " + this);
        }
        if (this.val instanceof GcdRingElem && this.ring.modul instanceof GcdRingElem) {
            GcdRingElem v = (GcdRingElem)this.val;
            GcdRingElem m = (GcdRingElem)this.ring.modul;
            RingElem[] egcd = v.egcd(m);
            if (this.debug) {
                logger.info((Object)("egcd = " + egcd[0] + ", f = " + egcd[1]));
            }
            if (!egcd[0].isONE()) {
                this.isunit = 0;
                throw new NotInvertibleException("element not invertible (gcd)" + this);
            }
            this.isunit = 1;
            RingElem x = egcd[1];
            return new Residue<RingElem>(this.ring, x);
        }
        if (this.val.isUnit()) {
            RingElem x = (RingElem)this.val.inverse();
            return new Residue<RingElem>(this.ring, x);
        }
        System.out.println("isunit = " + this.isunit + ", isUnit() = " + this.isUnit());
        throw new NotInvertibleException("element not invertible (!gcd)" + this);
    }

    @Override
    public Residue<C> remainder(Residue<C> S) {
        RingElem x = (RingElem)this.val.remainder(S.val);
        return new Residue<RingElem>(this.ring, x);
    }

    @Override
    public Residue<C> multiply(Residue<C> S) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.multiply(S.val));
    }

    @Override
    public Residue<C> gcd(Residue<C> b) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public Residue<C>[] egcd(Residue<C> b) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

