/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.TermOrder;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class TermOrderTest
extends TestCase {
    ExpVector a;
    ExpVector b;
    ExpVector c;
    ExpVector d;
    TermOrder t;
    TermOrder s;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)TermOrderTest.suite());
    }

    public TermOrderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TermOrderTest.class);
        return suite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    public void testConstructor() {
        this.s = new TermOrder();
        this.t = new TermOrder();
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String x = this.t.toString();
        String y = this.s.toString();
        TermOrderTest.assertEquals((String)"x = y", (String)x, (String)y);
        this.t = new TermOrder(2);
        x = "INVLEX";
        boolean z = this.t.toString().startsWith(x);
        TermOrderTest.assertTrue((String)"INVLEX(.)", (boolean)z);
        this.s = new TermOrder(4);
        this.t = new TermOrder(4);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorSplit() {
        int r = 10;
        int sp = 5;
        this.s = new TermOrder(r, sp);
        this.t = new TermOrder(r, sp);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String x = this.t.toString();
        String y = this.s.toString();
        TermOrderTest.assertEquals((String)"x = y", (String)x, (String)y);
        this.s = new TermOrder(4, 2, r, sp);
        this.t = new TermOrder(4, 2, r, sp);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorWeight() {
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.s = new TermOrder(w);
        this.t = new TermOrder(w);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String x = this.t.toString();
        String y = this.s.toString();
        TermOrderTest.assertEquals((String)"x = y", (String)x, (String)y);
        w = new long[][]{{5L, 4L, 3L, 2L, 1L}};
        x = "W(";
        boolean z = this.t.toString().startsWith(x);
        TermOrderTest.assertTrue((String)"W(.)", (boolean)z);
    }

    public void testCompareWeight() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.sum(this.b);
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.t = new TermOrder(w);
        int x = ExpVector.EVIWLC(w, this.c, this.a);
        int y = ExpVector.EVIWLC(w, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.c);
        y = ExpVector.EVIWLC(w, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.a);
        y = ExpVector.EVIWLC(w, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testCompareWeight2() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.sum(this.b);
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L}, {1L, 1L, 1L, 1L, 1L}};
        this.t = new TermOrder(w);
        int x = ExpVector.EVIWLC(w, this.c, this.a);
        int y = ExpVector.EVIWLC(w, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.c);
        y = ExpVector.EVIWLC(w, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.a);
        y = ExpVector.EVIWLC(w, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testCompareWeightSplit() {
        float q = 0.9f;
        int r = 8;
        int sp = 4;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        this.c = this.a.sum(this.b);
        long[][] w = new long[][]{{1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}};
        int x = ExpVector.EVIWLC(w, this.c, this.a);
        int y = ExpVector.EVIWLC(w, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w, this.c, this.a, 0, sp);
        y = ExpVector.EVIWLC(w, this.c, this.b, 0, sp);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w, this.c, this.a, sp, r);
        y = ExpVector.EVIWLC(w, this.c, this.b, sp, r);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.c);
        y = ExpVector.EVIWLC(w, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.c, 0, sp);
        y = ExpVector.EVIWLC(w, this.b, this.c, 0, sp);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.c, sp, r);
        y = ExpVector.EVIWLC(w, this.b, this.c, sp, r);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.a);
        y = ExpVector.EVIWLC(w, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.a, 0, sp);
        y = ExpVector.EVIWLC(w, this.b, this.b, 0, sp);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x = ExpVector.EVIWLC(w, this.a, this.a, sp, r);
        y = ExpVector.EVIWLC(w, this.b, this.b, sp, r);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        long[][] lArrayArray = new long[2][];
        long[] lArray = new long[8];
        lArray[0] = 1L;
        lArray[1] = 1L;
        lArray[2] = 1L;
        lArray[3] = 1L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[8];
        lArray2[4] = 1L;
        lArray2[5] = 1L;
        lArray2[6] = 1L;
        lArray2[7] = 1L;
        lArrayArray[1] = lArray2;
        long[][] w2 = lArrayArray;
        x = ExpVector.EVIWLC(w2, this.c, this.a);
        y = ExpVector.EVIWLC(w2, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w2, this.c, this.a, 0, sp);
        y = ExpVector.EVIWLC(w2, this.c, this.b, 0, sp);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w2, this.c, this.a, sp, r);
        y = ExpVector.EVIWLC(w2, this.c, this.b, sp, r);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.c);
        y = ExpVector.EVIWLC(w2, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.c, 0, sp);
        y = ExpVector.EVIWLC(w2, this.b, this.c, 0, sp);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.c, sp, r);
        y = ExpVector.EVIWLC(w2, this.b, this.c, sp, r);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.a);
        y = ExpVector.EVIWLC(w2, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.a, 0, sp);
        y = ExpVector.EVIWLC(w2, this.b, this.b, 0, sp);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x = ExpVector.EVIWLC(w2, this.a, this.a, sp, r);
        y = ExpVector.EVIWLC(w2, this.b, this.b, sp, r);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testAscendComparator() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder();
        int x = this.t.getAscendComparator().compare(this.c, this.a);
        int y = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = this.t.getAscendComparator().compare(this.a, this.c);
        y = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = this.t.getAscendComparator().compare(this.a, this.a);
        y = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testAscendComparatorSplit() {
        float q = 0.9f;
        int r = 10;
        int sp = 5;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(r, sp);
        int x = this.t.getAscendComparator().compare(this.c, this.a);
        int y = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = this.t.getAscendComparator().compare(this.a, this.c);
        y = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = this.t.getAscendComparator().compare(this.a, this.a);
        y = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testAscendComparatorWeightSplit() {
        float q = 0.9f;
        int r = 8;
        int sp = 5;
        long[][] w = new long[][]{{1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L}};
        long[][] lArrayArray = new long[2][];
        long[] lArray = new long[8];
        lArray[0] = 1L;
        lArray[1] = 2L;
        lArray[2] = 3L;
        lArray[3] = 4L;
        lArray[4] = 5L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[8];
        lArray2[5] = 1L;
        lArray2[6] = 2L;
        lArray2[7] = 3L;
        lArrayArray[1] = lArray2;
        long[][] w2 = lArrayArray;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(w2);
        TermOrder t2 = new TermOrder(w2);
        int x = this.t.getAscendComparator().compare(this.c, this.a);
        int y = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        int x2 = t2.getAscendComparator().compare(this.c, this.a);
        int y2 = t2.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x2 = 1", (int)1, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = 1", (int)1, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
        x = this.t.getAscendComparator().compare(this.a, this.c);
        y = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x2 = t2.getAscendComparator().compare(this.a, this.c);
        y2 = t2.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x2 = -1", (int)-1, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = -1", (int)-1, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
        x = this.t.getAscendComparator().compare(this.a, this.a);
        y = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x2 = t2.getAscendComparator().compare(this.a, this.a);
        y2 = t2.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x2 = 0", (int)0, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = 0", (int)0, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
    }

    public void testDescendComparator() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder();
        int x = this.t.getDescendComparator().compare(this.c, this.a);
        int y = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = this.t.getDescendComparator().compare(this.a, this.c);
        y = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = this.t.getDescendComparator().compare(this.a, this.a);
        y = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testDescendComparatorSplit() {
        float q = 0.9f;
        int r = 10;
        int sp = 5;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(r, sp);
        int x = this.t.getDescendComparator().compare(this.c, this.a);
        int y = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        x = this.t.getDescendComparator().compare(this.a, this.c);
        y = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x = this.t.getDescendComparator().compare(this.a, this.a);
        y = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
    }

    public void testDescendComparatorWeightSplit() {
        float q = 0.9f;
        int r = 8;
        int sp = 5;
        long[][] w = new long[][]{{1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L}};
        long[][] lArrayArray = new long[2][];
        long[] lArray = new long[8];
        lArray[0] = 1L;
        lArray[1] = 2L;
        lArray[2] = 3L;
        lArray[3] = 4L;
        lArray[4] = 5L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[8];
        lArray2[5] = 1L;
        lArray2[6] = 2L;
        lArray2[7] = 3L;
        lArrayArray[1] = lArray2;
        long[][] w2 = lArrayArray;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(w2);
        TermOrder t2 = new TermOrder(w2);
        int x = this.t.getDescendComparator().compare(this.c, this.a);
        int y = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)x);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)y);
        int x2 = t2.getDescendComparator().compare(this.c, this.a);
        int y2 = t2.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x2 = -1", (int)-1, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = -1", (int)-1, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
        x = this.t.getDescendComparator().compare(this.a, this.c);
        y = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)x);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)y);
        x2 = t2.getDescendComparator().compare(this.a, this.c);
        y2 = t2.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x2 = 1", (int)1, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = 1", (int)1, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
        x = this.t.getDescendComparator().compare(this.a, this.a);
        y = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)x);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)y);
        x2 = t2.getDescendComparator().compare(this.a, this.a);
        y2 = t2.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x2 = 0", (int)0, (int)x2);
        TermOrderTest.assertEquals((String)"y2 = 0", (int)0, (int)y2);
        TermOrderTest.assertEquals((String)"x = x2", (int)x, (int)x2);
        TermOrderTest.assertEquals((String)"y = y2", (int)y, (int)y2);
    }

    public void testException() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        int wrong = 99;
        boolean x = false;
        try {
            this.t = new TermOrder(wrong);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testExceptionSplit() {
        float q = 0.9f;
        int r = 10;
        int sp = 5;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        int wrong = 99;
        boolean x = false;
        try {
            this.t = new TermOrder(wrong, wrong, r, sp);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testCompareException() {
        float q = 0.9f;
        this.a = ExpVector.EVRAND(5, 10L, q);
        this.b = ExpVector.EVRAND(5, 10L, q);
        int notimpl = 10;
        int x = 0;
        try {
            this.t = new TermOrder(notimpl);
            x = this.t.getDescendComparator().compare(this.a, this.b);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testCompareExceptionSplit() {
        float q = 0.9f;
        int r = 10;
        int sp = 5;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        int notimpl = 10;
        int x = 0;
        try {
            this.t = new TermOrder(notimpl, notimpl, r, sp);
            x = this.t.getDescendComparator().compare(this.a, this.b);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testCompareExceptionWeigth() {
        float q = 0.9f;
        int r = 10;
        int sp = 5;
        this.a = ExpVector.EVRAND(r, 10L, q);
        this.b = ExpVector.EVRAND(r, 10L, q);
        int x = 0;
        try {
            this.t = new TermOrder(null);
            x = this.t.getDescendComparator().compare(this.a, this.b);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }
}

