/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class WeylRelations<C extends RingElem<C>> {
    private final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(WeylRelations.class);

    public WeylRelations(GenSolvablePolynomialRing<C> r) {
        if (r == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.ring = r;
        if (this.ring.nvar <= 1 || this.ring.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + this.ring.nvar);
        }
    }

    public void generate() {
        RelationTable table = this.ring.table;
        int r = this.ring.nvar;
        int m = r / 2;
        GenPolynomial one = ((GenSolvablePolynomial)this.ring.getONE()).clone();
        GenPolynomial zero = ((GenSolvablePolynomial)this.ring.getZERO()).clone();
        int i = m;
        while (i < r) {
            ExpVector f = ExpVector.create(r, i, 1L);
            int j = i - m;
            ExpVector e = ExpVector.create(r, j, 1L);
            ExpVector ef = e.sum(f);
            GenPolynomial b = ((GenSolvablePolynomial)one).multiply(ef);
            GenSolvablePolynomial rel = (GenSolvablePolynomial)b.sum(one);
            if (rel.isZERO()) {
                logger.info((Object)("ring = " + this.ring));
                logger.info((Object)("one  = " + one));
                logger.info((Object)("zero = " + zero));
                logger.info((Object)("b    = " + b));
                logger.info((Object)("rel  = " + rel));
                throw new RuntimeException("rel.isZERO()");
            }
            table.update(e, f, rel);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nWeyl relations = " + table));
        }
    }
}

