/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.ReductionSeq;
import edu.jas.ps.StandardBaseSeq;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class ExamplesMulti {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        if (args.length > 0) {
            ExamplesMulti.example1();
            ExamplesMulti.example2();
            ExamplesMulti.example3();
            ExamplesMulti.example4();
            ExamplesMulti.example5();
            ExamplesMulti.example6();
            ExamplesMulti.example7();
            ExamplesMulti.example8();
            ExamplesMulti.example9();
            ExamplesMulti.example10();
        }
        ExamplesMulti.example11();
    }

    public static void example1() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x^2  + x y");
        Element b = pfac.parse("y^2  + x y");
        Element c = pfac.parse("x^3  + x^2");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        ReductionSeq<BigRational> red = new ReductionSeq<BigRational>();
        MultiVarPowerSeries<BigRational> dp = red.normalform(L, cp);
        System.out.println("dp = " + dp);
    }

    public static void example2() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x - x y");
        Element b = pfac.parse("y^2  + x^3");
        Element c = pfac.parse("x^2  + y^2");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        ReductionSeq<BigRational> red = new ReductionSeq<BigRational>();
        MultiVarPowerSeries<BigRational> dp = red.normalform(L, cp);
        System.out.println("dp = " + dp);
    }

    public static void example3() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x");
        Element b = pfac.parse("y");
        Element c = pfac.parse("x^2 + y^2 + z^3 + x^4 + y^5");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        ReductionSeq<BigRational> red = new ReductionSeq<BigRational>();
        MultiVarPowerSeries<BigRational> dp = red.normalform(L, cp);
        System.out.println("dp = " + dp);
    }

    public static void example4() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x + x^3 + x^5");
        Element c = pfac.parse("x + x^2");
        System.out.println("a = " + a);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        ReductionSeq<BigRational> red = new ReductionSeq<BigRational>();
        MultiVarPowerSeries<BigRational> dp = red.normalform(L, cp);
        System.out.println("dp = " + dp);
    }

    public static void example5() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element c = pfac.parse("x^2  + y^2 - 1");
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.getSIN(0);
        MultiVarPowerSeries<BigRational> bp = fac.getCOS(1);
        MultiVarPowerSeries<BigRational> ep = fac.getCOS(0);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("ep = " + ep);
        System.out.println("cp = " + cp);
        System.out.println("ap^2 + ep^2 = " + ap.multiply(ap).sum(ep.multiply(ep)));
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        ReductionSeq<BigRational> red = new ReductionSeq<BigRational>();
        MultiVarPowerSeries<BigRational> dp = red.normalform(L, cp);
        System.out.println("dp = " + dp);
    }

    public static void example6() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x^5 - x y^6 + z^7");
        Element b = pfac.parse("x y + y^3 + z^3");
        Element c = pfac.parse("x^2 + y^2 - z^2");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        L.add(cp);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
    }

    public static void example7() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x^10 + x^9 y^2");
        Element b = pfac.parse("y^8 - x^2 y^7");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        fac.setTruncate(12);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("\nS contains L = " + s);
    }

    public static void example8() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element c = pfac.parse("x^2  + y^2");
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.getSIN(0);
        MultiVarPowerSeries<BigRational> bp = fac.getTAN(0);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        System.out.println("\nL = " + L);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
    }

    public static void example9() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x z - y z - y^2 z");
        Element b = pfac.parse("x z - y z + y^2 z");
        Element c = pfac.parse("z + y^2 z");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        fac.setTruncate(11);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        L.add(cp);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
    }

    public static void example10() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x^2 z^2 - y^6");
        Element b = pfac.parse("x y z^2 + y^4 z - x^5 z - x^4 y^3");
        Element c = pfac.parse("x z - y^3 + x^2 z - x y^3");
        Element d = pfac.parse("y z + x y z - x^4 - x^5");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        System.out.println("d = " + d);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        fac.setTruncate(9);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        MultiVarPowerSeries<BigRational> dp = fac.fromPolynomial((GenPolynomial<BigRational>)d);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        System.out.println("dp = " + dp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        L.add(cp);
        L.add(dp);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
        List R = red.totalNormalform(S);
        System.out.println("R = " + R);
        s = red.contains(R, L);
        System.out.println("R contains L = " + s);
        s = red.contains(R, S);
        System.out.println("R contains S = " + s);
    }

    public static void example11() {
        BigRational br = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(br, vars);
        System.out.println("pfac = " + pfac.toScript());
        Element a = pfac.parse("x^5 - x y^6 - z^7");
        Element b = pfac.parse("x y + y^3 + z^3");
        Element c = pfac.parse("x^2 + y^2 - z^2");
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        MultiVarPowerSeriesRing<BigRational> fac = new MultiVarPowerSeriesRing<BigRational>(pfac);
        System.out.println("fac = " + fac.toScript());
        MultiVarPowerSeries<BigRational> ap = fac.fromPolynomial((GenPolynomial<BigRational>)a);
        MultiVarPowerSeries<BigRational> bp = fac.fromPolynomial((GenPolynomial<BigRational>)b);
        MultiVarPowerSeries<BigRational> cp = fac.fromPolynomial((GenPolynomial<BigRational>)c);
        System.out.println("ap = " + ap);
        System.out.println("bp = " + bp);
        System.out.println("cp = " + cp);
        ArrayList L = new ArrayList();
        L.add(ap);
        L.add(bp);
        L.add(cp);
        StandardBaseSeq tm = new StandardBaseSeq();
        List S = tm.STD(L);
        for (MultiVarPowerSeries ps : S) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nS = " + S);
        boolean s = tm.isSTD(S);
        System.out.println("\nisSTD = " + s);
        ReductionSeq red = new ReductionSeq();
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
        List R = red.totalNormalform(S);
        for (MultiVarPowerSeries ps : R) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nR = " + R);
        s = tm.isSTD(R);
        System.out.println("\nisSTD = " + s);
        s = red.contains(R, L);
        System.out.println("R contains L = " + s);
        s = red.contains(R, S);
        System.out.println("R contains S = " + s);
        s = red.contains(S, R);
        System.out.println("S contains R = " + s);
        s = red.contains(S, L);
        System.out.println("S contains L = " + s);
        List Rs = tm.STD(R);
        for (MultiVarPowerSeries ps : Rs) {
            System.out.println("ps = " + ps);
        }
        System.out.println("\nRs = " + Rs);
        s = tm.isSTD(Rs);
        System.out.println("\nisSTD = " + s);
        s = red.contains(Rs, R);
        System.out.println("Rs contains R = " + s);
        s = red.contains(Rs, S);
        System.out.println("Rs contains S = " + s);
    }
}

