/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.BinaryFunctor;
import edu.jas.structure.RingElem;
import edu.jas.structure.Selector;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ExpVectorIterable;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MultiVarPowerSeries<C extends RingElem<C>>
implements RingElem<MultiVarPowerSeries<C>> {
    public final MultiVarPowerSeriesRing<C> ring;
    MultiVarCoefficients<C> lazyCoeffs;
    private int truncate;
    private int order = -1;
    private ExpVector evorder = null;

    private MultiVarPowerSeries() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    MultiVarPowerSeries(MultiVarPowerSeriesRing<C> ring) {
        this.ring = ring;
        this.lazyCoeffs = null;
        this.truncate = ring.truncate;
    }

    public MultiVarPowerSeries(MultiVarPowerSeriesRing<C> ring, MultiVarCoefficients<C> lazyCoeffs) {
        this(ring, lazyCoeffs, ring.truncate);
    }

    public MultiVarPowerSeries(MultiVarPowerSeriesRing<C> ring, MultiVarCoefficients<C> lazyCoeffs, int trunc) {
        if (lazyCoeffs == null || ring == null) {
            throw new IllegalArgumentException("null not allowed: ring = " + ring + ", lazyCoeffs = " + lazyCoeffs);
        }
        this.ring = ring;
        this.lazyCoeffs = lazyCoeffs;
        this.truncate = Math.min(trunc, ring.truncate);
    }

    @Override
    public MultiVarPowerSeriesRing<C> factory() {
        return this.ring;
    }

    public MultiVarPowerSeries<C> clone() {
        return new MultiVarPowerSeries<C>(this.ring, this.lazyCoeffs);
    }

    public String toString() {
        return this.toString(this.truncate);
    }

    public String toString(int trunc) {
        StringBuffer sb = new StringBuffer();
        MultiVarPowerSeries s = this;
        String[] vars = this.ring.vars;
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, trunc)) {
            Object c = s.coefficient(i);
            int si = c.signum();
            if (si == 0) continue;
            if (si > 0) {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
            } else {
                c = (RingElem)c.negate();
                sb.append(" - ");
            }
            if (!c.isONE() || i.isZERO()) {
                sb.append(c.toString());
                if (!i.isZERO()) {
                    sb.append(" * ");
                }
            }
            if (i.isZERO()) continue;
            sb.append(i.toString(vars));
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        sb.append(" + BigO( (" + this.ring.varsToString() + ")^" + (trunc + 1) + "(" + (this.ring.truncate + 1) + ") )");
        return sb.toString();
    }

    @Override
    public String toScript() {
        StringBuffer sb = new StringBuffer("");
        MultiVarPowerSeries s = this;
        String[] vars = this.ring.vars;
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            Object c = s.coefficient(i);
            int si = c.signum();
            if (si == 0) continue;
            if (si > 0) {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
            } else {
                c = (RingElem)c.negate();
                sb.append(" - ");
            }
            if (!c.isONE() || i.isZERO()) {
                sb.append(c.toScript());
                if (!i.isZERO()) {
                    sb.append(" * ");
                }
            }
            if (i.isZERO()) continue;
            sb.append(i.toScript(vars));
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        sb.append(" + BigO( (" + this.ring.varsToString() + ")**" + (this.truncate + 1) + " )");
        return sb.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((MultiVarPowerSeriesRing)this.factory()).toScript();
    }

    public C coefficient(ExpVector index) {
        if (index == null) {
            throw new IndexOutOfBoundsException("null index not allowed");
        }
        return this.lazyCoeffs.get(index);
    }

    public GenPolynomial<C> homogeneousPart(long tdeg) {
        return this.lazyCoeffs.getHomPart(tdeg);
    }

    public GenPolynomial<C> asPolynomial() {
        GenPolynomial<GenPolynomial<C>> p = this.homogeneousPart(0L);
        int i = 1;
        while (i <= this.truncate) {
            p = p.sum(this.homogeneousPart(i));
            ++i;
        }
        return p;
    }

    public C leadingCoefficient() {
        return this.coefficient(this.ring.EVZERO);
    }

    public MultiVarPowerSeries<C> reductum(final int r) {
        if (r < 0 || this.ring.nvar < r) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                ExpVector e = i.subst(r, i.getVal(r) + 1L);
                return MultiVarPowerSeries.this.coefficient(e);
            }
        });
    }

    public MultiVarPowerSeries<C> prepend(C h, int r) {
        if (r < 0 || this.ring.nvar < r) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)h, r){
            private final /* synthetic */ RingElem val$h;
            private final /* synthetic */ int val$r;
            {
                this.val$h = ringElem;
                this.val$r = n;
                super($anonymous0);
            }

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return this.val$h;
                }
                ExpVector e = i.subst(this.val$r, i.getVal(this.val$r) - 1L);
                if (e.signum() < 0) {
                    return (RingElem)this.pfac.coFac.getZERO();
                }
                return MultiVarPowerSeries.this.coefficient(e);
            }
        });
    }

    public MultiVarPowerSeries<C> shift(final int k, final int r) {
        if (r < 0 || this.ring.nvar < r) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        int nt = Math.min(this.truncate + k, this.ring.truncate);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                long d = i.getVal(r);
                if (d - (long)k < 0L) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                ExpVector e = i.subst(r, i.getVal(r) - (long)k);
                return MultiVarPowerSeries.this.coefficient(e);
            }
        }, nt);
    }

    public MultiVarPowerSeries<C> reductum() {
        Map.Entry<ExpVector, C> m = this.orderMonomial();
        ExpVector e = m.getKey();
        long d = e.totalDeg();
        MultiVarCoefficients<C> mc = this.lazyCoeffs;
        HashMap cc = new HashMap(mc.coeffCache);
        GenPolynomial<RingElem> p = cc.get(d);
        if (p != null && !p.isZERO()) {
            p = p.subtract((RingElem)m.getValue(), e);
            cc.put(d, p);
        }
        HashSet<ExpVector> z = new HashSet<ExpVector>(mc.zeroCache);
        if (!mc.homCheck.get((int)d)) {
            z.add(e);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(mc.pfac, cc, z, mc.homCheck){

            @Override
            public C generate(ExpVector i) {
                return MultiVarPowerSeries.this.coefficient(i);
            }
        });
    }

    public MultiVarPowerSeries<C> shift(final ExpVector k) {
        if (k == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (k.signum() == 0) {
            return this;
        }
        int nt = Math.min(this.truncate + (int)k.totalDeg(), this.ring.truncate);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                ExpVector d = i.subtract(k);
                if (d.signum() < 0) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                return MultiVarPowerSeries.this.coefficient(d);
            }
        }, nt);
    }

    public MultiVarPowerSeries<C> multiply(C c, final ExpVector k) {
        if (k == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (k.signum() == 0) {
            return this.multiply(c);
        }
        if (c.signum() == 0) {
            return this.ring.getZERO();
        }
        int nt = Math.min(this.ring.truncate, this.truncate + (int)k.totalDeg());
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)c){
            private final /* synthetic */ RingElem val$c;
            {
                this.val$c = ringElem;
                super($anonymous0);
            }

            @Override
            public C generate(ExpVector i) {
                ExpVector d = i.subtract(k);
                if (d.signum() < 0) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                long tdegd = d.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)tdegd)) {
                    GenPolynomial<RingElem> p = MultiVarPowerSeries.this.homogeneousPart(tdegd).multiply(this.val$c, k);
                    long tdegi = i.totalDeg();
                    this.coeffCache.put(tdegi, p);
                    this.homCheck.set((int)tdegi);
                    RingElem b = p.coefficient(i);
                    return b;
                }
                return MultiVarPowerSeries.this.coefficient(d).multiply((RingElem)this.val$c);
            }
        }, nt);
    }

    @Override
    public MultiVarPowerSeries<C> sum(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            throw new IllegalArgumentException("null Map.Entry not allowed");
        }
        return this.sum((RingElem)m.getValue(), m.getKey());
    }

    public MultiVarPowerSeries<C> sum(C c, ExpVector k) {
        if (k == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (c.signum() == 0) {
            return this;
        }
        long d = k.totalDeg();
        MultiVarCoefficients<C> mc = this.lazyCoeffs;
        HashMap cc = new HashMap(mc.coeffCache);
        AbelianGroupElem p = cc.get(d);
        if (p == null) {
            p = mc.pfac.getZERO();
        }
        p = ((GenPolynomial)p).sum(c, k);
        cc.put(d, p);
        HashSet<ExpVector> z = new HashSet<ExpVector>(mc.zeroCache);
        if (((GenPolynomial)p).coefficient(k).isZERO() && !mc.homCheck.get((int)d)) {
            z.add(k);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(mc.pfac, cc, z, mc.homCheck){

            @Override
            public C generate(ExpVector i) {
                return MultiVarPowerSeries.this.coefficient(i);
            }
        });
    }

    public MultiVarPowerSeries<C> subtract(C c, ExpVector k) {
        if (k == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (c.signum() == 0) {
            return this;
        }
        long d = k.totalDeg();
        MultiVarCoefficients<C> mc = this.lazyCoeffs;
        HashMap cc = new HashMap(mc.coeffCache);
        AbelianGroupElem p = cc.get(d);
        if (p == null) {
            p = mc.pfac.getZERO();
        }
        p = ((GenPolynomial)p).subtract(c, k);
        cc.put(d, p);
        HashSet<ExpVector> z = new HashSet<ExpVector>(mc.zeroCache);
        if (((GenPolynomial)p).coefficient(k).isZERO() && !mc.homCheck.get((int)d)) {
            z.add(k);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(mc.pfac, cc, z, mc.homCheck){

            @Override
            public C generate(ExpVector i) {
                return MultiVarPowerSeries.this.coefficient(i);
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> sum(MultiVarCoefficients<C> mvc) {
        MultiVarCoefficients<C> mc = this.lazyCoeffs;
        TreeMap cc = new TreeMap(mc.coeffCache);
        TreeMap ccv = new TreeMap(mvc.coeffCache);
        long d1 = cc.size() > 0 ? cc.lastKey() : 0L;
        long d2 = ccv.size() > 0 ? ccv.lastKey() : 0L;
        HashSet<ExpVector> z = new HashSet<ExpVector>(mc.zeroCache);
        z.addAll(mvc.zeroCache);
        long d = Math.max(d1, d2);
        BitSet hc = new BitSet((int)d);
        long i = 0L;
        while (i <= d) {
            AbelianGroupElem p1 = cc.get(i);
            AbelianGroupElem p2 = mvc.coeffCache.get(i);
            if (p1 == null) {
                p1 = mc.pfac.getZERO();
            }
            if (p2 == null) {
                p2 = mc.pfac.getZERO();
            }
            GenPolynomial p = ((GenPolynomial)p1).sum(p2);
            cc.put(i, p);
            if (mc.homCheck.get((int)i) && mvc.homCheck.get((int)i)) {
                hc.set((int)i);
            } else {
                HashSet<ExpVector> ev = new HashSet<ExpVector>(((GenPolynomial)p1).getMap().keySet());
                ev.addAll(((GenPolynomial)p2).getMap().keySet());
                ev.removeAll(p.getMap().keySet());
                z.addAll(ev);
            }
            ++i;
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(mc.pfac, new HashMap(cc), z, hc){

            @Override
            public C generate(ExpVector i) {
                return MultiVarPowerSeries.this.coefficient(i);
            }
        });
    }

    public MultiVarPowerSeries<C> select(final Selector<? super C> sel) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                Object c = MultiVarPowerSeries.this.coefficient(i);
                if (sel.select(c)) {
                    return c;
                }
                return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> shiftSelect(final Selector<? super C> sel) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){
            ExpVectorIterable ib;
            Iterator<ExpVector> pos;
            {
                super($anonymous0);
                this.ib = new ExpVectorIterable(MultiVarPowerSeries.this.ring.nvar, true, MultiVarPowerSeries.this.truncate);
                this.pos = this.ib.iterator();
            }

            @Override
            public C generate(ExpVector i) {
                ExpVector e;
                RingElem c;
                if (i.signum() > 0) {
                    int[] deps = i.dependencyOnVariables();
                    ExpVector x = i.subst(deps[0], i.getVal(deps[0]) - 1L);
                    Object c2 = this.get(x);
                }
                do {
                    c = null;
                } while (this.pos.hasNext() && !sel.select(c = MultiVarPowerSeries.this.coefficient(e = this.pos.next())));
                if (c == null) {
                    c = (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                return c;
            }
        });
    }

    public MultiVarPowerSeries<C> map(final UnaryFunctor<? super C, C> f) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                return (RingElem)f.eval(MultiVarPowerSeries.this.coefficient(i));
            }
        });
    }

    public MultiVarPowerSeries<C> zip(final BinaryFunctor<? super C, ? super C, C> f, final MultiVarPowerSeries<C> ps) {
        int m = Math.min(this.ring.truncate, Math.max(this.truncate, ps.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                return (RingElem)f.eval(MultiVarPowerSeries.this.coefficient(i), ps.coefficient(i));
            }
        }, m);
    }

    public MultiVarPowerSeries<C> sumZip(MultiVarPowerSeries<C> ps) {
        return this.zip(new BinaryFunctor<C, C, C>(){

            @Override
            public C eval(C c1, C c2) {
                return (RingElem)c1.sum(c2);
            }
        }, ps);
    }

    public MultiVarPowerSeries<C> subtractZip(MultiVarPowerSeries<C> ps) {
        return this.zip(new BinaryFunctor<C, C, C>(){

            @Override
            public C eval(C c1, C c2) {
                return (RingElem)c1.subtract(c2);
            }
        }, ps);
    }

    @Override
    public MultiVarPowerSeries<C> multiply(C a) {
        if (a.isZERO()) {
            return this.ring.getZERO();
        }
        if (a.isONE()) {
            return this;
        }
        return this.map(new UnaryFunctor<C, C>((RingElem)a){
            private final /* synthetic */ RingElem val$a;
            {
                this.val$a = ringElem;
            }

            @Override
            public C eval(C c) {
                return c.multiply((RingElem)this.val$a);
            }
        });
    }

    public MultiVarPowerSeries<C> monic() {
        ExpVector e = this.orderExpVector();
        if (e == null) {
            return this;
        }
        C a = this.coefficient(e);
        if (a.isONE()) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        final RingElem b = (RingElem)a.inverse();
        return this.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)b.multiply(c);
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> negate() {
        return this.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)c.negate();
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public C evaluate(List<C> a) {
        RingElem v = (RingElem)this.ring.coFac.getZERO();
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            Object c = this.coefficient(i);
            if (c.isZERO()) continue;
            c = (RingElem)c.multiply(i.evaluate(this.ring.coFac, a));
            v = (RingElem)v.sum(c);
        }
        return (C)v;
    }

    public int order() {
        if (this.order >= 0) {
            return this.order;
        }
        GenPolynomial p = null;
        int t = 0;
        while (this.lazyCoeffs.homCheck.get(t)) {
            p = this.lazyCoeffs.coeffCache.get(t);
            if (p == null || p.isZERO()) {
                ++t;
                continue;
            }
            this.order = t;
            this.evorder = p.trailingExpVector();
            return this.order;
        }
        ExpVector x = null;
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            if (!this.coefficient(i).isZERO()) {
                this.order = (int)i.totalDeg();
                this.evorder = i;
                return this.order;
            }
            x = i;
        }
        this.order = this.truncate + 1;
        return this.order;
    }

    public ExpVector orderExpVector() {
        int x = this.order();
        return this.evorder;
    }

    public Map.Entry<ExpVector, C> orderMonomial() {
        ExpVector e = this.orderExpVector();
        if (e == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<ExpVector, C>(e, this.coefficient(e));
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int t) {
        if (t < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int ot = this.truncate;
        if (this.order >= 0 && this.order > this.truncate) {
            this.order = -1;
            this.evorder = null;
        }
        this.truncate = t;
        return ot;
    }

    public long ecart() {
        long d;
        ExpVector e = this.orderExpVector();
        if (e == null) {
            return 0L;
        }
        long hd = d = e.totalDeg();
        long i = d + 1L;
        while (i <= (long)this.truncate) {
            if (!this.homogeneousPart(i).isZERO()) {
                hd = i;
            }
            ++i;
        }
        return hd - d;
    }

    @Override
    public int signum() {
        int i = this.order();
        if (this.evorder != null) {
            return this.coefficient(this.evorder).signum();
        }
        return 0;
    }

    @Override
    public int compareTo(MultiVarPowerSeries<C> ps) {
        int m = this.truncate();
        int n = ps.truncate();
        int pos = Math.min(this.ring.truncate, Math.min(m, n));
        int s = 0;
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, pos)) {
            s = this.coefficient(i).compareTo(ps.coefficient(i));
            if (s == 0) continue;
            return s;
        }
        int j = pos + 1;
        while (j <= Math.min(this.ring.truncate, Math.max(m, n))) {
            for (ExpVector i : new ExpVectorIterable(this.ring.nvar, j)) {
                s = this.coefficient(i).compareTo(ps.coefficient(i));
                if (s == 0) continue;
                return s;
            }
            ++j;
        }
        return s;
    }

    @Override
    public boolean isZERO() {
        return this.signum() == 0;
    }

    @Override
    public boolean isONE() {
        if (!this.leadingCoefficient().isONE()) {
            return false;
        }
        return this.compareTo(this.ring.ONE) == 0;
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof MultiVarPowerSeries)) {
            return false;
        }
        MultiVarPowerSeries a = null;
        try {
            a = (MultiVarPowerSeries)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ExpVector i : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            C c = this.coefficient(i);
            if (!c.isZERO()) {
                h += i.hashCode();
                h <<= 23;
            }
            h += c.hashCode();
            h <<= 23;
        }
        return h;
    }

    @Override
    public boolean isUnit() {
        return this.leadingCoefficient().isUnit();
    }

    @Override
    public MultiVarPowerSeries<C> sum(final MultiVarPowerSeries<C> ps) {
        int nt = Math.min(this.ring.truncate, Math.max(this.truncate(), ps.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector e) {
                long tdeg = e.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)tdeg)) {
                    GenPolynomial p = MultiVarPowerSeries.this.homogeneousPart(tdeg).sum(ps.homogeneousPart(tdeg));
                    this.coeffCache.put(tdeg, p);
                    this.homCheck.set((int)tdeg);
                    GenPolynomial c = p.coefficient(e);
                    return c;
                }
                return (RingElem)MultiVarPowerSeries.this.coefficient(e).sum(ps.coefficient(e));
            }
        }, nt);
    }

    @Override
    public MultiVarPowerSeries<C> subtract(final MultiVarPowerSeries<C> ps) {
        int nt = Math.min(this.ring.truncate, Math.max(this.truncate(), ps.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector e) {
                long tdeg = e.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)tdeg)) {
                    GenPolynomial p = MultiVarPowerSeries.this.homogeneousPart(tdeg).subtract(ps.homogeneousPart(tdeg));
                    this.coeffCache.put(tdeg, p);
                    this.homCheck.set((int)tdeg);
                    GenPolynomial c = p.coefficient(e);
                    return c;
                }
                return (RingElem)MultiVarPowerSeries.this.coefficient(e).subtract(ps.coefficient(e));
            }
        }, nt);
    }

    @Override
    public MultiVarPowerSeries<C> multiply(final MultiVarPowerSeries<C> ps) {
        int nt = Math.min(this.ring.truncate, this.truncate() + ps.truncate());
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector e) {
                long tdeg = e.totalDeg();
                GenPolynomial p = null;
                int k = 0;
                while ((long)k <= tdeg) {
                    GenPolynomial m = MultiVarPowerSeries.this.homogeneousPart(k).multiply(ps.homogeneousPart(tdeg - (long)k));
                    p = p == null ? m : p.sum(m);
                    ++k;
                }
                this.coeffCache.put(tdeg, p);
                this.homCheck.set((int)tdeg);
                Object c = p.coefficient(e);
                return c;
            }
        }, nt);
    }

    @Override
    public MultiVarPowerSeries<C> inverse() {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector e) {
                long tdeg = e.totalDeg();
                RingElem d = (RingElem)MultiVarPowerSeries.this.leadingCoefficient().inverse();
                if (tdeg == 0L) {
                    return d;
                }
                GenPolynomial<RingElem> p = null;
                int k = 0;
                while ((long)k < tdeg) {
                    GenPolynomial<GenPolynomial<RingElem>> m = this.getHomPart(k).multiply(MultiVarPowerSeries.this.homogeneousPart(tdeg - (long)k));
                    p = p == null ? m : p.sum(m);
                    ++k;
                }
                p = p.multiply((RingElem)d.negate());
                this.coeffCache.put(tdeg, p);
                this.homCheck.set((int)tdeg);
                RingElem c = p.coefficient(e);
                return c;
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> divide(MultiVarPowerSeries<C> ps) {
        int n;
        if (ps.isUnit()) {
            return this.multiply((MultiVarPowerSeries<C>)ps.inverse());
        }
        int m = this.order();
        if (m < (n = ps.order())) {
            return this.ring.getZERO();
        }
        ExpVector em = this.orderExpVector();
        ExpVector en = ps.orderExpVector();
        if (!ps.coefficient(en).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + ps.coefficient(ps.evorder) + ", evorder = " + ps.evorder);
        }
        MultiVarPowerSeries<C> st = m == 0 ? this : this.shift(em.negate());
        MultiVarPowerSeries<C> sps = n == 0 ? ps : ps.shift(en.negate());
        MultiVarPowerSeries<C> q = st.multiply((MultiVarPowerSeries<C>)sps.inverse());
        MultiVarPowerSeries<C> sq = q.shift(em.subtract(en));
        return sq;
    }

    @Override
    public MultiVarPowerSeries<C> remainder(MultiVarPowerSeries<C> ps) {
        int n;
        int m = this.order();
        if (m >= (n = ps.order())) {
            return this.ring.getZERO();
        }
        return this;
    }

    public MultiVarPowerSeries<C> differentiate(final int r) {
        if (r < 0 || this.ring.nvar < r) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector i) {
                long d = i.getVal(r);
                ExpVector e = i.subst(r, d + 1L);
                RingElem v = MultiVarPowerSeries.this.coefficient(e);
                v = v.multiply((RingElem)((RingElem)MultiVarPowerSeries.this.ring.coFac.fromInteger(d + 1L)));
                return v;
            }
        });
    }

    public MultiVarPowerSeries<C> integrate(C c, int r) {
        if (r < 0 || this.ring.nvar < r) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        int nt = Math.min(this.ring.truncate, this.truncate + 1);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)c, r){
            private final /* synthetic */ RingElem val$c;
            private final /* synthetic */ int val$r;
            {
                this.val$c = ringElem;
                this.val$r = n;
                super($anonymous0);
            }

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return this.val$c;
                }
                long d = i.getVal(this.val$r);
                if (d > 0L) {
                    ExpVector e = i.subst(this.val$r, d - 1L);
                    RingElem v = MultiVarPowerSeries.this.coefficient(e);
                    v = v.divide((RingElem)((RingElem)MultiVarPowerSeries.this.ring.coFac.fromInteger(d)));
                    return v;
                }
                return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
            }
        }, nt);
    }

    @Override
    public MultiVarPowerSeries<C> gcd(MultiVarPowerSeries<C> ps) {
        if (ps.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return ps;
        }
        ExpVector em = this.orderExpVector();
        ExpVector en = ps.orderExpVector();
        return ((MultiVarPowerSeries)this.ring.getONE()).shift(em.gcd(en));
    }

    public MultiVarPowerSeries<C>[] egcd(MultiVarPowerSeries<C> S) {
        throw new UnsupportedOperationException("egcd for power series not implemented");
    }
}

