/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesMap;
import edu.jas.ps.TaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ListUtil;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class MultiVarPowerSeriesRing<C extends RingElem<C>>
implements RingFactory<MultiVarPowerSeries<C>> {
    protected static final Random random = new Random();
    public static final int DEFAULT_TRUNCATE = 7;
    int truncate;
    public final ExpVector EVZERO;
    public final RingFactory<C> coFac;
    public final int nvar;
    protected String[] vars;
    public final MultiVarPowerSeries<C> ONE;
    public final MultiVarPowerSeries<C> ZERO;

    private MultiVarPowerSeriesRing() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public MultiVarPowerSeriesRing(GenPolynomialRing<C> fac) {
        this(fac.coFac, fac.nvar, fac.getVars());
    }

    public MultiVarPowerSeriesRing(RingFactory<C> coFac, int nv) {
        this(coFac, nv, 7);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> coFac, int nv, int truncate) {
        this(coFac, nv, truncate, null);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> coFac, String[] names) {
        this(coFac, names.length, 7, names);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> cofac, int nv, String[] names) {
        this(cofac, nv, 7, names);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> cofac, int nv, int truncate, String[] names) {
        this.coFac = cofac;
        this.nvar = nv;
        this.truncate = truncate;
        this.vars = names;
        if (this.vars == null && PrettyPrint.isTrue()) {
            this.vars = GenPolynomialRing.newVars("x", this.nvar);
        } else {
            if (this.vars.length != this.nvar) {
                throw new IllegalArgumentException("incompatible variable size " + this.vars.length + ", " + this.nvar);
            }
            GenPolynomialRing.addVars(this.vars);
        }
        this.EVZERO = ExpVector.create(this.nvar);
        this.ONE = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getONE();
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
        this.ZERO = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> fixPoint(MultiVarPowerSeriesMap<C> map) {
        MultiVarPowerSeries ps1 = new MultiVarPowerSeries(this);
        MultiVarPowerSeries<C> ps2 = map.map(ps1);
        ps1.lazyCoeffs = ps2.lazyCoeffs;
        return ps2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String scf = this.coFac.getClass().getSimpleName();
        sb.append(String.valueOf(scf) + "((" + this.varsToString() + "))");
        return sb.toString();
    }

    public String varsToString() {
        String s = "";
        if (this.vars == null) {
            return String.valueOf(s) + "#" + this.nvar;
        }
        int i = 0;
        while (i < this.vars.length) {
            if (i != 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + this.vars[i];
            ++i;
        }
        return s;
    }

    public String[] getVars() {
        return this.vars;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("MPS(");
        String f = null;
        try {
            f = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception e) {
            f = this.coFac.toScript();
        }
        s.append(String.valueOf(f) + ",\"" + this.varsToString() + "\"," + this.truncate + ")");
        return s.toString();
    }

    public boolean equals(Object B) {
        if (!(B instanceof MultiVarPowerSeriesRing)) {
            return false;
        }
        MultiVarPowerSeriesRing a = null;
        try {
            a = (MultiVarPowerSeriesRing)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return Arrays.equals(this.vars, a.vars);
    }

    public int hashCode() {
        int h = 0;
        h = Arrays.hashCode(this.vars) << 23;
        return h += this.truncate;
    }

    @Override
    public MultiVarPowerSeries<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public MultiVarPowerSeries<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<MultiVarPowerSeries<C>> generators() {
        List rgens = this.coFac.generators();
        ArrayList<MultiVarPowerSeries<C>> gens = new ArrayList<MultiVarPowerSeries<C>>(rgens.size());
        for (final RingElem cg : rgens) {
            MultiVarPowerSeries g = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

                @Override
                public C generate(ExpVector i) {
                    if (i.isZERO()) {
                        return cg;
                    }
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
            });
            gens.add(g);
        }
        int i = 0;
        while (i < this.nvar) {
            gens.add(this.ONE.shift(1, this.nvar - 1 - i));
            ++i;
        }
        return gens;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int t) {
        if (t < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int ot = this.truncate;
        this.truncate = t;
        this.ONE.setTruncate(t);
        this.ZERO.setTruncate(t);
        return ot;
    }

    public MultiVarPowerSeries<C> getEXP(final int r) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> e) {
                return e.integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), r);
            }
        });
    }

    public MultiVarPowerSeries<C> getSIN(final int r) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> s) {
                return ((MultiVarPowerSeries)s.negate()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), r).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), r);
            }
        });
    }

    public MultiVarPowerSeries<C> getCOS(final int r) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> c) {
                return ((MultiVarPowerSeries)c.negate()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), r).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), r);
            }
        });
    }

    public MultiVarPowerSeries<C> getTAN(final int r) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> t) {
                return t.multiply(t).sum((MultiVarPowerSeries)MultiVarPowerSeriesRing.this.getONE()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), r);
            }
        });
    }

    public MultiVarPowerSeries<C> solvePDE(MultiVarPowerSeries<C> f, C c, int r) {
        return f.integrate(c, r);
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    @Override
    public MultiVarPowerSeries<C> fromInteger(final long a) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(a);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> fromInteger(final BigInteger a) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(a);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public GenPolynomialRing<C> polyRing() {
        return new GenPolynomialRing<C>(this.coFac, this.nvar, this.vars);
    }

    public MultiVarPowerSeries<C> fromPolynomial(GenPolynomial<C> a) {
        if (a == null || a.isZERO()) {
            return this.ZERO;
        }
        if (a.isONE()) {
            return this.ONE;
        }
        GenPolynomialRing<C> pfac = this.polyRing();
        HashMap<Long, Object> cache = new HashMap<Long, Object>();
        int mt = 0;
        for (Monomial<C> m : a) {
            ExpVector e = m.exponent();
            long t = e.totalDeg();
            mt = Math.max(mt, (int)t);
            Object p = (GenPolynomial)cache.get(t);
            if (p == null) {
                p = ((GenPolynomial)pfac.getZERO()).clone();
                cache.put(t, p);
            }
            ((GenPolynomial)p).doPutToMap(e, m.coefficient());
        }
        if (++mt > this.truncate()) {
            this.setTruncate(mt);
        }
        BitSet check = new BitSet();
        int i = 0;
        while (i <= this.truncate()) {
            check.set(i);
            if (cache.get(i) == null) {
                Object p = ((GenPolynomial)pfac.getZERO()).clone();
                cache.put(Long.valueOf(i), p);
            }
            ++i;
        }
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(pfac, cache, check){

            @Override
            public C generate(ExpVector e) {
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public List<MultiVarPowerSeries<C>> fromPolynomial(List<GenPolynomial<C>> A) {
        return ListUtil.map(A, new UnaryFunctor<GenPolynomial<C>, MultiVarPowerSeries<C>>(){

            @Override
            public MultiVarPowerSeries<C> eval(GenPolynomial<C> c) {
                return MultiVarPowerSeriesRing.this.fromPolynomial(c);
            }
        });
    }

    public MultiVarPowerSeries<C> fromPowerSeries(final UnivPowerSeries<C> ps, final int r) {
        if (ps == null) {
            return this.ZERO;
        }
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                if (i.isZERO()) {
                    return ps.coefficient(0);
                }
                int[] dep = i.dependencyOnVariables();
                if (dep.length != 1) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                if (dep[0] != r) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                int j = (int)i.getVal(r);
                if (j > 0) {
                    return ps.coefficient(j);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> random() {
        return this.random(5, 0.7f, random);
    }

    @Override
    public MultiVarPowerSeries<C> random(int k) {
        return this.random(k, 0.7f, random);
    }

    @Override
    public MultiVarPowerSeries<C> random(int k, Random rnd) {
        return this.random(k, 0.7f, rnd);
    }

    public MultiVarPowerSeries<C> random(int k, float d) {
        return this.random(k, d, random);
    }

    public MultiVarPowerSeries<C> random(final int k, final float d, final Random rnd) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector i) {
                float f = rnd.nextFloat();
                RingElem c = f < d ? (RingElem)MultiVarPowerSeriesRing.this.coFac.random(k, rnd) : (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                return c;
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> copy(MultiVarPowerSeries<C> c) {
        return new MultiVarPowerSeries(this, c.lazyCoeffs);
    }

    @Override
    public MultiVarPowerSeries<C> parse(String s) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    @Override
    public MultiVarPowerSeries<C> parse(Reader r) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    public MultiVarPowerSeries<C> seriesOfTaylor(TaylorFunction<C> f, List<C> a) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this, f, a){
            TaylorFunction<C> der;
            final List<C> v;
            {
                this.der = taylorFunction;
                this.v = list;
            }

            @Override
            public C generate(ExpVector i) {
                int s = i.signum();
                if (s == 0) {
                    Object c = this.der.evaluate(this.v);
                    return c;
                }
                TaylorFunction pder = this.der.deriviative(i);
                if (pder.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                RingElem c = pder.evaluate(this.v);
                if (c.isZERO()) {
                    return c;
                }
                long f = pder.getFacul();
                c = c.divide((RingElem)((RingElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(f)));
                return c;
            }
        });
    }
}

