/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.util.ExpVectorIterable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MultiVarPowerSeriesTest
extends TestCase {
    MultiVarPowerSeriesRing<BigRational> fac;
    MultiVarPowerSeries<BigRational> a;
    MultiVarPowerSeries<BigRational> b;
    MultiVarPowerSeries<BigRational> c;
    MultiVarPowerSeries<BigRational> d;
    MultiVarPowerSeries<BigRational> e;
    MultiVarPowerSeries<BigRational> f;
    int rl = 2;
    int kl = 10;
    float q = 0.3f;

    public static void main(String[] args) {
        TestRunner.run((Test)MultiVarPowerSeriesTest.suite());
    }

    public MultiVarPowerSeriesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MultiVarPowerSeriesTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        String[] vars = new String[]{"x", "y"};
        this.fac = new MultiVarPowerSeriesRing<BigRational>(new BigRational(1L), this.rl, vars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testCoefficients() {
        GenPolynomial c;
        BigRational c2;
        BigRational cf = new BigRational(0L);
        GenPolynomialRing<BigRational> pring = new GenPolynomialRing<BigRational>(cf, this.rl);
        MultiVarCoefficients<BigRational> zeros = new MultiVarCoefficients<BigRational>(pring){

            @Override
            public BigRational generate(ExpVector i) {
                return (BigRational)this.pfac.coFac.getZERO();
            }
        };
        MultiVarCoefficients<BigRational> ones = new MultiVarCoefficients<BigRational>(pring){

            @Override
            public BigRational generate(ExpVector i) {
                return (BigRational)this.pfac.coFac.getONE();
            }
        };
        MultiVarCoefficients<BigRational> vars = new MultiVarCoefficients<BigRational>(pring){

            @Override
            public BigRational generate(ExpVector i) {
                int[] v = i.dependencyOnVariables();
                if (v.length == 1 && i.getVal(v[0]) == 1L) {
                    return (BigRational)this.pfac.coFac.getONE();
                }
                return (BigRational)this.pfac.coFac.getZERO();
            }
        };
        int m = 5;
        ExpVectorIterable eiter = new ExpVectorIterable(this.rl, true, m);
        for (ExpVector e : eiter) {
            c2 = (BigRational)zeros.get(e);
            MultiVarPowerSeriesTest.assertTrue((String)"isZERO( c )", (boolean)c2.isZERO());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"coeffCache is one element", (zeros.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        for (ExpVector e : eiter) {
            c2 = (BigRational)ones.get(e);
            MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)c2.isONE());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)ones.zeroCache.isEmpty());
        int i = 0;
        while (i <= m) {
            c = ones.getHomPart(i);
            GenPolynomial d = ones.getHomPart(i);
            MultiVarPowerSeriesTest.assertTrue((String)"c.equals(d) ", (boolean)c.equals(d));
            ++i;
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)ones.zeroCache.isEmpty());
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + m), (ones.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + m), (ones.homCheck.length() == m + 1 ? 1 : 0) != 0);
        i = 0;
        while (i <= m) {
            c = vars.getHomPart(i);
            MultiVarPowerSeriesTest.assertTrue((String)"c==0 || deg(c)==1 ", (c.isZERO() || c.degree() == 1L ? 1 : 0) != 0);
            ++i;
        }
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + m), (vars.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + m), (vars.homCheck.length() == m + 1 ? 1 : 0) != 0);
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        List<MultiVarPowerSeries<BigRational>> gens = this.fac.generators();
        MultiVarPowerSeriesTest.assertTrue((String)"#gens == rl+1 ", (this.rl + 1 == gens.size() ? 1 : 0) != 0);
        for (MultiVarPowerSeries<BigRational> p : gens) {
            MultiVarPowerSeriesTest.assertTrue((String)"red(p) == 0 ", (boolean)p.reductum().isZERO());
        }
        this.a = this.fac.copy(this.c);
        this.b = this.c.clone();
        MultiVarPowerSeriesTest.assertEquals((String)"copy(c) == c.clone() ", this.a, this.b);
        this.a = this.fac.fromInteger(1L);
        MultiVarPowerSeriesTest.assertEquals((String)"1 == fromInteger(1) ", this.a, this.c);
        this.b = this.fac.fromInteger(BigInteger.ONE);
        MultiVarPowerSeriesTest.assertEquals((String)"1 == fromInteger(1) ", this.b, this.c);
    }

    public void testRandom() {
        int i = 0;
        while (i < 5) {
            this.a = this.fac.random(i + 2);
            MultiVarPowerSeriesTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            MultiVarPowerSeriesTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testCoefficientsInPS() {
        GenPolynomial<BigRational> p;
        BigRational r;
        MultiVarCoefficients<BigRational> zeros = new MultiVarCoefficients<BigRational>(this.fac){

            @Override
            public BigRational generate(ExpVector i) {
                return (BigRational)this.pfac.coFac.getZERO();
            }
        };
        MultiVarCoefficients<BigRational> ones = new MultiVarCoefficients<BigRational>(this.fac){

            @Override
            public BigRational generate(ExpVector i) {
                return (BigRational)this.pfac.coFac.getONE();
            }
        };
        MultiVarCoefficients<BigRational> vars = new MultiVarCoefficients<BigRational>(this.fac){

            @Override
            public BigRational generate(ExpVector i) {
                int[] v = i.dependencyOnVariables();
                if (v.length == 1 && i.getVal(v[0]) == 1L) {
                    return (BigRational)this.pfac.coFac.getONE();
                }
                return (BigRational)this.pfac.coFac.getZERO();
            }
        };
        this.a = new MultiVarPowerSeries<BigRational>(this.fac, zeros);
        this.b = new MultiVarPowerSeries<BigRational>(this.fac, ones);
        this.c = new MultiVarPowerSeries<BigRational>(this.fac, vars);
        int m = 5;
        ExpVectorIterable eiter = new ExpVectorIterable(this.rl, true, m);
        for (ExpVector e : eiter) {
            r = this.a.coefficient(e);
            MultiVarPowerSeriesTest.assertTrue((String)"isZERO( r )", (boolean)r.isZERO());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"coeffCache is one element", (this.a.lazyCoeffs.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        for (ExpVector e : eiter) {
            r = this.b.coefficient(e);
            MultiVarPowerSeriesTest.assertTrue((String)"isONE( r )", (boolean)r.isONE());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)this.b.lazyCoeffs.zeroCache.isEmpty());
        int i = 0;
        while (i <= m) {
            p = this.b.homogeneousPart(i);
            GenPolynomial<BigRational> q = this.b.homogeneousPart(i);
            MultiVarPowerSeriesTest.assertTrue((String)"p.equals(q) ", (boolean)p.equals(q));
            ++i;
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)this.b.lazyCoeffs.zeroCache.isEmpty());
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + m), (this.b.lazyCoeffs.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + m), (this.b.lazyCoeffs.homCheck.length() == m + 1 ? 1 : 0) != 0);
        i = 0;
        while (i <= m) {
            p = this.c.homogeneousPart(i);
            MultiVarPowerSeriesTest.assertTrue((String)"p==0 || deg(p)==1 ", (p.isZERO() || p.degree() == 1L ? 1 : 0) != 0);
            ++i;
        }
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + m), (this.c.lazyCoeffs.coeffCache.size() == m + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + m), (this.c.lazyCoeffs.homCheck.length() == m + 1 ? 1 : 0) != 0);
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        MultiVarPowerSeriesTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.d = this.c.subtract(this.b);
        MultiVarPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.d = this.c.sum((MultiVarPowerSeries<BigRational>)this.b.negate());
        MultiVarPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.sum(this.b.sum(this.c));
        this.e = this.a.sum(this.b).sum(this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        Map.Entry<ExpVector, BigRational> ma = this.a.orderMonomial();
        this.c = this.a.reductum().sum(ma);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+om(a)", this.a, this.c);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        MultiVarPowerSeriesTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        MultiVarPowerSeriesTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        MultiVarPowerSeriesTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MultiVarPowerSeriesTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        ExpVector ev = ExpVector.random(this.rl, 5L, 0.8f);
        BigRational br = (BigRational)this.fac.coFac.random(5);
        this.b = this.a.shift(ev).multiply(br);
        this.c = this.a.multiply(br, ev);
        MultiVarPowerSeriesTest.assertEquals((String)"(a ev) br = a (ev,br)", this.b, this.c);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        MultiVarPowerSeriesTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testInverse() {
        this.a = this.fac.getONE();
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isUnit( a )", (boolean)this.a.isUnit());
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.a = this.fac.random(this.kl);
        if (!this.a.isUnit()) {
            this.a = this.fac.fromInteger(23L);
        }
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.b = this.fac.random(this.kl);
        this.c = this.b.divide(this.a);
        this.d = this.c.multiply(this.a);
        MultiVarPowerSeriesTest.assertEquals((String)"b/a * a == b ", this.d, this.b);
    }

    public void testFixpoints() {
        int r = 0;
        UnivPowerSeriesRing ufac = new UnivPowerSeriesRing(this.fac.coFac, this.fac.vars[r]);
        UnivPowerSeries exp = ufac.getEXP();
        this.a = this.fac.fromPowerSeries(exp, 0);
        this.b = this.fac.fromPowerSeries(exp, 1);
        this.c = this.fac.getEXP(0);
        this.d = this.fac.getEXP(1);
        MultiVarPowerSeriesTest.assertEquals((String)"a == c ", this.a, this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"b == d ", this.b, this.d);
        this.e = this.d.differentiate(0);
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.d.differentiate(1);
        MultiVarPowerSeriesTest.assertEquals((String)"e == d ", this.d, this.e);
    }

    public void testReductum() {
        this.a = this.fac.random(this.kl);
        Map.Entry<ExpVector, BigRational> m = this.a.orderMonomial();
        ExpVector k = m.getKey();
        BigRational br = m.getValue();
        this.b = ((MultiVarPowerSeries)this.fac.getONE()).multiply(br, k);
        this.c = this.a.reductum();
        this.d = this.c.sum(this.b);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+1*lm(a) ", this.a, this.d);
        this.e = this.c.sum(br, k);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+lm(a) ", this.a, this.e);
        this.e = this.a.subtract(br, k);
        MultiVarPowerSeriesTest.assertEquals((String)"a - lm(a) = red(a) ", this.c, this.e);
        this.b = this.fac.random(this.kl);
        String s = this.b.toString();
        this.c = this.a.sum(this.b);
        this.d = this.a.sum(this.b.lazyCoeffs);
        br = new BigRational(2L, 3L);
        this.c = this.a.prepend(br, 0);
        this.d = this.c.reductum(0);
        MultiVarPowerSeriesTest.assertEquals((String)"red(a + br_0,0) = a ", this.d, this.a);
        this.c = this.a.shift(3, 0);
        this.d = this.c.shift(-3, 0);
        MultiVarPowerSeriesTest.assertEquals((String)"shift(shift(a,3,),-3,0) = a ", this.d, this.a);
    }

    public void testPolynomial() {
        GenPolynomialRing<BigRational> pr = this.fac.polyRing();
        GenPolynomial<BigRational> p = pr.random(this.kl, 3, 3, this.q + this.q);
        this.a = this.fac.fromPolynomial(p);
        GenPolynomial<BigRational> s = this.a.asPolynomial();
        MultiVarPowerSeriesTest.assertEquals((String)"asPolynomial(fromPolynomial(p)) = p ", p, s);
    }

    public void testGcd() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.gcd(this.b);
        this.d = this.a.divide(this.c);
        this.e = this.b.divide(this.c);
        this.f = this.d.gcd(this.e);
        MultiVarPowerSeriesTest.assertTrue((String)"gcd(a/gcd(a,b),b/gcd(a,b)) == 1 ", (boolean)this.f.isONE());
    }

    public void testTaylor() {
        BigRational ar = new BigRational(5L);
        BigRational br = new BigRational(0L);
        BigRational cr = new BigRational(-5L);
        ArrayList<BigRational> Ar = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> Br = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> Cr = new ArrayList<BigRational>(this.rl);
        int i = 0;
        while (i < this.rl) {
            Ar.add(ar);
            Br.add(br);
            Cr.add(cr);
            ++i;
        }
        GenPolynomialRing<BigRational> pr = this.fac.polyRing();
        GenPolynomial<BigRational> p = pr.random(this.kl, 3, 3, this.q + this.q);
        System.out.println("p   = " + p);
        int tdeg = (int)p.degree();
        this.fac.setTruncate(tdeg + 1);
        PolynomialTaylorFunction<BigRational> F2 = new PolynomialTaylorFunction<BigRational>(p);
        MultiVarPowerSeriesRing<BigRational> psr = new MultiVarPowerSeriesRing<BigRational>(pr);
        MultiVarPowerSeries<BigRational> pps = this.fac.fromPolynomial(p);
        MultiVarPowerSeries<BigRational> ps = this.fac.seriesOfTaylor(F2, Br);
        MultiVarPowerSeriesTest.assertEquals((String)"taylor(p) == p", ps, pps);
        MultiVarPowerSeries<BigRational> psa = this.fac.seriesOfTaylor(F2, Ar);
        F2 = new PolynomialTaylorFunction<BigRational>(psa.asPolynomial());
        MultiVarPowerSeries<BigRational> psc = this.fac.seriesOfTaylor(F2, Cr);
        MultiVarPowerSeriesTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", ps, psc);
        for (GenPolynomial<BigRational> g : pr.generators()) {
            F2 = new PolynomialTaylorFunction<BigRational>(g);
            ps = this.fac.seriesOfTaylor(F2, Br);
            pps = this.fac.fromPolynomial(g);
            MultiVarPowerSeriesTest.assertEquals((String)"taylor(p) == p", ps, pps);
            psa = this.fac.seriesOfTaylor(F2, Ar);
            F2 = new PolynomialTaylorFunction<BigRational>(psa.asPolynomial());
            psc = this.fac.seriesOfTaylor(F2, Cr);
            System.out.println("psc  = " + psc);
            MultiVarPowerSeriesTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", ps, psc);
        }
    }

    public void testEvaluation() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        BigRational fv = new BigRational(0L);
        ArrayList<BigRational> v = new ArrayList<BigRational>(this.rl);
        int i = 0;
        while (i < this.rl) {
            v.add(fv.random(this.kl));
            ++i;
        }
        BigRational av = this.a.evaluate(v);
        BigRational bv = this.b.evaluate(v);
        this.c = this.a.sum(this.b);
        BigRational cv = this.c.evaluate(v);
        BigRational dv = av.sum(bv);
        MultiVarPowerSeriesTest.assertEquals((String)"a(v)+b(v) = (a+b)(v) ", (Object)cv, (Object)dv);
        this.c = this.fac.getZERO();
        cv = this.c.evaluate(v);
        dv = fv.getZERO();
        MultiVarPowerSeriesTest.assertEquals((String)"0(v) = 0 ", (Object)cv, (Object)dv);
        this.c = this.fac.getONE();
        cv = this.c.evaluate(v);
        dv = fv.getONE();
        MultiVarPowerSeriesTest.assertEquals((String)"1(v) = 1 ", (Object)cv, (Object)dv);
    }
}

