/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.ps.TaylorFunction;
import edu.jas.structure.RingElem;
import java.util.List;

public class PolynomialTaylorFunction<C extends RingElem<C>>
implements TaylorFunction<C> {
    final GenPolynomial<C> pol;
    final long facul;

    public PolynomialTaylorFunction(GenPolynomial<C> p) {
        this(p, 1L);
    }

    public PolynomialTaylorFunction(GenPolynomial<C> p, long f) {
        this.pol = p;
        this.facul = f;
    }

    public String toString() {
        return this.pol.toString();
    }

    @Override
    public long getFacul() {
        return this.facul;
    }

    @Override
    public boolean isZERO() {
        return this.pol.isZERO();
    }

    @Override
    public TaylorFunction<C> deriviative() {
        return new PolynomialTaylorFunction<C>(PolyUtil.baseDeriviative(this.pol));
    }

    @Override
    public TaylorFunction<C> deriviative(ExpVector i) {
        GenPolynomial<C> p = this.pol;
        long f = 1L;
        if (i.signum() == 0 || this.pol.isZERO()) {
            return new PolynomialTaylorFunction<C>(p, f);
        }
        int j = 0;
        while (j < i.length()) {
            long e = i.getVal(j);
            if (e != 0L) {
                int jl = i.length() - 1 - j;
                long k = 0L;
                while (k < e) {
                    p = PolyUtil.baseDeriviative(p, jl);
                    f *= k + 1L;
                    if (p.isZERO()) {
                        return new PolynomialTaylorFunction<C>(p, f);
                    }
                    ++k;
                }
            }
            ++j;
        }
        return new PolynomialTaylorFunction<C>(p, f);
    }

    @Override
    public C evaluate(C a) {
        return PolyUtil.evaluateMain(this.pol.ring.coFac, this.pol, a);
    }

    @Override
    public C evaluate(List<C> a) {
        return PolyUtil.evaluateAll(this.pol.ring.coFac, this.pol.ring, this.pol, a);
    }
}

