/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReductionSeq<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(ReductionSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    public boolean moduleCriterion(int modv, MultiVarPowerSeries<C> A, MultiVarPowerSeries<C> B) {
        if (modv == 0) {
            return true;
        }
        ExpVector ei = A.orderExpVector();
        ExpVector ej = B.orderExpVector();
        return this.moduleCriterion(modv, ei, ej);
    }

    public boolean moduleCriterion(int modv, ExpVector ei, ExpVector ej) {
        if (modv == 0) {
            return true;
        }
        return ei.invLexCompareTo(ej, 0, modv) == 0;
    }

    public boolean criterion4(MultiVarPowerSeries<C> A, MultiVarPowerSeries<C> B, ExpVector e) {
        ExpVector ej;
        ExpVector ei;
        ExpVector g;
        ExpVector h;
        int s;
        if (logger.isInfoEnabled()) {
            if (!A.ring.equals(B.ring)) {
                logger.error((Object)("rings not equal " + A.ring + ", " + B.ring));
            }
            if (!A.ring.isCommutative()) {
                logger.error((Object)"GBCriterion4 not applicabable to non-commutative power series");
                return true;
            }
        }
        return (s = (h = (g = (ei = A.orderExpVector()).sum(ej = B.orderExpVector())).subtract(e)).signum()) != 0;
    }

    public MultiVarPowerSeries<C> SPolynomial(MultiVarPowerSeries<C> A, MultiVarPowerSeries<C> B) {
        if (B == null || B.isZERO()) {
            if (A == null) {
                return B;
            }
            return A.ring.getZERO();
        }
        if (A == null || A.isZERO()) {
            return B.ring.getZERO();
        }
        if (this.debug && !A.ring.equals(B.ring)) {
            logger.error((Object)("rings not equal " + A.ring + ", " + B.ring));
        }
        Map.Entry<ExpVector, C> ma = A.orderMonomial();
        Map.Entry<ExpVector, C> mb = B.orderMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        MultiVarPowerSeries<RingElem> Ap = A.multiply(b, e1);
        MultiVarPowerSeries<RingElem> Bp = B.multiply(a, f1);
        MultiVarPowerSeries<RingElem> C = Ap.subtract(Bp);
        return C;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiVarPowerSeries<C> normalform(List<MultiVarPowerSeries<C>> Pp, MultiVarPowerSeries<C> Ap) {
        Map.Entry<ExpVector, Object> m;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        if (!Ap.ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        ArrayList<MultiVarPowerSeries<C>> P = new ArrayList<MultiVarPowerSeries<C>>(Pp.size());
        List<MultiVarPowerSeries<C>> list = Pp;
        synchronized (list) {
            P.addAll(Pp);
        }
        ArrayList<ExpVector> htl = new ArrayList<ExpVector>(P.size());
        ArrayList<RingElem> lbc = new ArrayList<RingElem>(P.size());
        ArrayList<MultiVarPowerSeries<RingElem>> p = new ArrayList<MultiVarPowerSeries<RingElem>>(P.size());
        ArrayList<Long> ecart = new ArrayList<Long>(P.size());
        int j = 0;
        int i = 0;
        while (i < P.size()) {
            m = ((MultiVarPowerSeries)P.get(i)).orderMonomial();
            if (m != null) {
                p.add((MultiVarPowerSeries)P.get(i));
                htl.add(m.getKey());
                lbc.add((RingElem)m.getValue());
                ecart.add(((MultiVarPowerSeries)P.get(i)).ecart());
                ++j;
            }
            ++i;
        }
        int ll = j;
        MultiVarPowerSeries<Object> S = Ap;
        m = S.orderMonomial();
        while (m != null) {
            if (S.isZERO()) {
                return S;
            }
            ExpVector e = m.getKey();
            if (this.debug) {
                logger.debug((Object)("e = " + e.toString(Ap.ring.vars)));
            }
            ArrayList<Integer> li = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < htl.size()) {
                if (e.multipleOf((ExpVector)htl.get(i2))) {
                    li.add(i2);
                }
                ++i2;
            }
            if (li.isEmpty()) {
                return S;
            }
            long mi = Long.MAX_VALUE;
            int k = 0;
            while (k < li.size()) {
                int ki = (Integer)li.get(k);
                long x = (Long)ecart.get(ki);
                if (x < mi) {
                    mi = x;
                    i2 = ki;
                }
                ++k;
            }
            long si = S.ecart();
            if (mi > si) {
                p.add(S);
                htl.add(m.getKey());
                lbc.add((RingElem)m.getValue());
                ecart.add(si);
            }
            e = e.subtract((ExpVector)htl.get(i2));
            RingElem a = ((RingElem)m.getValue()).divide((RingElem)lbc.get(i2));
            MultiVarPowerSeries<RingElem> Q = ((MultiVarPowerSeries)p.get(i2)).multiply(a, e);
            S = S.subtract(Q);
            m = S.orderMonomial();
        }
        return S;
    }

    public MultiVarPowerSeries<C> totalNormalform(List<MultiVarPowerSeries<C>> P, MultiVarPowerSeries<C> A) {
        if (P == null || P.isEmpty()) {
            return A;
        }
        if (A == null) {
            return A;
        }
        MultiVarPowerSeries<C> R = this.normalform(P, A);
        if (R.isZERO()) {
            return R;
        }
        MultiVarCoefficients Rc = new MultiVarCoefficients<C>(A.ring){

            @Override
            public C generate(ExpVector i) {
                return (RingElem)this.pfac.coFac.getZERO();
            }
        };
        GenPolynomialRing pfac = A.lazyCoeffs.pfac;
        while (!R.isZERO()) {
            Map.Entry<ExpVector, C> m = R.orderMonomial();
            if (m == null) break;
            R = R.reductum();
            ExpVector e = m.getKey();
            long t = e.totalDeg();
            AbelianGroupElem p = Rc.coeffCache.get(t);
            if (p == null) {
                p = pfac.getZERO();
            }
            p = p.sum((RingElem)m.getValue(), e);
            Rc.coeffCache.put(t, p);
            R = this.normalform(P, R);
        }
        R = R.sum(Rc);
        return R;
    }

    public List<MultiVarPowerSeries<C>> totalNormalform(List<MultiVarPowerSeries<C>> P) {
        if (P == null || P.isEmpty()) {
            return P;
        }
        ArrayList<MultiVarPowerSeries<C>> R = new ArrayList<MultiVarPowerSeries<C>>(P.size());
        ArrayList<MultiVarPowerSeries<C>> S = new ArrayList<MultiVarPowerSeries<C>>(P);
        for (MultiVarPowerSeries<C> a : P) {
            Map.Entry<ExpVector, C> m = a.orderMonomial();
            if (m == null) continue;
            MultiVarPowerSeries<C> r = a.reductum();
            MultiVarPowerSeries<C> b = this.normalform(S, r);
            if ((b = b.sum(m)).isZERO()) continue;
            R.add(b);
        }
        return R;
    }

    public boolean isTopReducible(List<MultiVarPowerSeries<C>> P, MultiVarPowerSeries<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null) {
            return false;
        }
        ExpVector e = A.orderExpVector();
        if (e == null) {
            return false;
        }
        for (MultiVarPowerSeries<C> p : P) {
            ExpVector ep = p.orderExpVector();
            if (e == null || !e.multipleOf(ep)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(List<MultiVarPowerSeries<C>> S, List<MultiVarPowerSeries<C>> B) {
        if (B == null || B.size() == 0) {
            return true;
        }
        if (S == null || S.size() == 0) {
            return true;
        }
        for (MultiVarPowerSeries<C> b : B) {
            MultiVarPowerSeries<C> z;
            if (b == null || (z = this.normalform(S, b)).isZERO()) continue;
            System.out.println("contains nf(b) != 0: " + b + ", z = " + z);
            return false;
        }
        return true;
    }
}

